/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.util.ArrayList;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.TaxUtils;
import org.apache.commons.lang3.StringUtils;

public class MsgSendAuthHelper {
    public static boolean getSendMsgFlag() {
        String sendMsgFlag = CacheHelper.get("sendMsgFlag");
        if (StringUtils.isBlank((CharSequence)sendMsgFlag)) {
            QFilter filter = new QFilter("id", "=", (Object)1);
            DynamicObject sendMsgAuthSetObj = QueryServiceHelper.queryOne((String)"bdm_msg_auth_setting", (String)"msgswitch", (QFilter[])filter.toArray());
            sendMsgFlag = null != sendMsgAuthSetObj ? sendMsgAuthSetObj.getString("msgswitch") : "false";
            CacheHelper.put("sendMsgFlag", sendMsgFlag);
        }
        return "true".equals(sendMsgFlag);
    }

    public static boolean authEpInfoByTaxNo(String taxNo) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return false;
        }
        String[] setValues = MsgSendAuthHelper.getAuthEpInfo();
        if (setValues == null || setValues.length == 0) {
            DynamicObject[] epinfos = BusinessDataServiceHelper.load((String)"bdm_send_epinfo_setting", (String)"epinfo", null);
            if (null != epinfos && epinfos.length > 0) {
                setValues = (String[])Stream.of(epinfos).filter(o -> o.getDynamicObject("epinfo") != null).map(o -> o.getDynamicObject("epinfo").getString("number")).toArray(String[]::new);
                if (setValues.length == 0) {
                    return false;
                }
                CacheHelper.addToSet("msgAuthEpInfo", setValues);
            } else {
                setValues = new String[]{};
            }
        }
        for (String str : setValues) {
            if (!str.equals(taxNo)) continue;
            return true;
        }
        return false;
    }

    private static String[] getAuthEpInfo() {
        String[] setValues = CacheHelper.getSetValues("msgAuthEpInfo");
        if (setValues == null || setValues.length == 0) {
            DynamicObject[] epInfoSettings = BusinessDataServiceHelper.load((String)"bdm_send_epinfo_setting", (String)"epinfo", null);
            ArrayList<String> authEpInfo = new ArrayList<String>(epInfoSettings.length);
            for (DynamicObject epInfoSetting : epInfoSettings) {
                DynamicObject epinfo = epInfoSetting.getDynamicObject("epinfo");
                if (epinfo == null) continue;
                authEpInfo.add(epinfo.getString("number"));
            }
            setValues = authEpInfo.toArray(new String[0]);
        }
        return setValues;
    }

    public static boolean msgSendAuthByCurrentOrgId() {
        return MsgSendAuthHelper.msgSendAuthByOrgId(RequestContext.get().getOrgId());
    }

    public static boolean msgSendAuthByOrgId(Long orgid) {
        boolean msgSendFlag = false;
        try {
            if (MsgSendAuthHelper.getSendMsgFlag()) {
                msgSendFlag = MsgSendAuthHelper.authEpInfoByTaxNo(TaxUtils.getSaleInfoByOrg(orgid).getSaleTaxNo());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msgSendFlag;
    }
}

