/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ITreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.TreeUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgHelper {
    public static List<Long> getChildrenOrgIds(long orgId) {
        return OrgHelper.getChildrenOrgIds(orgId, true);
    }

    public static List<Long> getChildrenOrgIds(long orgId, boolean isContainOwn) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_org", (String)"longnumber", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (obj == null) {
            if (isContainOwn) {
                return Collections.singletonList(orgId);
            }
            return new ArrayList<Long>();
        }
        QFilter orgFilter = new QFilter("longnumber", "like", (Object)(obj.getString("longnumber") + ".%"));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])orgFilter.toArray());
        List<Long> orgIds = Stream.of(objs).map(o -> o.getLong("id")).collect(Collectors.toList());
        if (isContainOwn) {
            orgIds.add(orgId);
        }
        return orgIds;
    }

    public static List<Long> getChildrenOrgIdsNotBindEnterprise(Long orgId, boolean isContainOwn) {
        long aLong;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org");
        QFilter orgFilter = new QFilter("longnumber", "like", (Object)(dynamicObject.getString("longnumber") + ".%"));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id,devlist,enterprisemainorg,longnumber", (QFilter[])orgFilter.toArray());
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<Long> excludeIds = new ArrayList<Long>();
        for (DynamicObject obj : objs) {
            aLong = obj.getLong("id");
            if (!"1".equals(obj.getString("enterprisemainorg"))) continue;
            excludeIds.add(aLong);
        }
        for (DynamicObject obj : objs) {
            aLong = obj.getLong("id");
            boolean isMain = false;
            for (Long mainId : excludeIds) {
                if (!obj.getString("longnumber").contains(mainId.toString())) continue;
                isMain = true;
            }
            if (isMain) continue;
            orgIds.add(aLong);
        }
        if (isContainOwn) {
            orgIds.add(orgId);
        }
        return orgIds;
    }

    public static void createOrgTree(ITreeListView treeListView, List<QFilter> qFilters) {
        List<TreeNode> treeNodes = OrgHelper.createTreeNodes(qFilters);
        HashMap nodeMap = Maps.newHashMapWithExpectedSize((int)10);
        ArrayList roots = Lists.newArrayListWithCapacity((int)100);
        OrgHelper.findRoots(treeNodes, roots, nodeMap);
        if (roots.size() == 0) {
            return;
        }
        for (TreeNode root : roots) {
            TreeUtils.findChildren(root, nodeMap);
        }
        treeListView.getTreeView().deleteAllNodes();
        if (roots.size() == 1) {
            ((TreeNode)roots.get(0)).setIsOpened(true);
            treeListView.getTreeModel().setRoot((TreeNode)roots.get(0));
            treeListView.getTreeView().addNode((TreeNode)roots.get(0));
            return;
        }
        TreeNode rootNode = new TreeNode();
        rootNode.setId("-1");
        rootNode.addChildren((List)roots);
        rootNode.setIsOpened(true);
        rootNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgHelper_29", (String)"imc-bdm-common", (Object[])new Object[0]));
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("level", "0");
        rootNode.setData(data);
        treeListView.getTreeModel().setRoot(rootNode);
        treeListView.getTreeView().addNode(rootNode);
    }

    private static void findRoots(List<TreeNode> treeNodes, List<TreeNode> roots, Map<String, List<TreeNode>> nodeMap) {
        List idList = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        for (TreeNode node : treeNodes) {
            if ("0".equals(node.getId())) continue;
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put("level", "1");
            if (StringUtils.isEmpty((CharSequence)node.getParentid())) {
                node.setParentid("");
                node.setData(data);
                roots.add(node);
            } else if (!idList.contains(node.getParentid())) {
                node.setParentid("");
                node.setData(data);
                roots.add(node);
            }
            if (nodeMap.containsKey(node.getParentid())) {
                nodeMap.get(node.getParentid()).add(node);
                continue;
            }
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            list.add(node);
            nodeMap.put(node.getParentid(), list);
        }
    }

    private static List<TreeNode> createTreeNodes(List<QFilter> qFilters) {
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            qFilters.add(OrgHelper.getIdFilter(userHasPermOrgs.getHasPermOrgs()));
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdm_org", (String)String.join((CharSequence)",", "id", "number", "name", "parent", "longnumber"), (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(8);
        for (DynamicObject entry : collection) {
            TreeNode node = new TreeNode();
            node.setId(entry.getString("id"));
            node.setText(entry.getString("name"));
            node.setParentid(entry.getString("parent"));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("longnumber", entry.getString("longnumber"));
            node.setData(data);
            nodeList.add(node);
        }
        return nodeList;
    }

    public static void checkOrgIsImport(PreOpenFormEventArgs e) {
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (orgObj == null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u672a\u5f15\u5165\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91=\u300b\u57fa\u7840\u8d44\u6599=\u300b\u4f01\u4e1a\u7ba1\u7406=\u300b\u4f01\u4e1a\u4fe1\u606f\u8fdb\u884c\u5f15\u5165!", (String)"OrgHelper_26", (String)"imc-bdm-common", (Object[])new Object[0]));
            return;
        }
        long epInfoId = DynamicObjectUtil.getDynamicObjectLongValue(orgObj.get("epinfo"));
        if (epInfoId == 0L) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u672a\u627e\u5230\u7ed1\u5b9a\u7684\u4f01\u4e1a\u7a0e\u53f7\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91=\u300b\u57fa\u7840\u8d44\u6599=\u300b\u4f01\u4e1a\u7ba1\u7406=\u300b\u4f01\u4e1a\u4fe1\u606f\u8fdb\u884c\u7ed1\u5b9a\u4f01\u4e1a\uff01", (String)"OrgHelper_27", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
    }

    public static HasPermOrgResultImpl getUserHasPermEpInfo() {
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (userHasPermOrgs.hasAllOrgPerm()) {
            return new HasPermOrgResultImpl(true, null);
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo", (QFilter[])OrgHelper.getIdFilter(userHasPermOrgs.getHasPermOrgs()).toArray());
        List epinfoIds = Stream.of(orgs).map(org -> DynamicObjectUtil.getDynamicObjectLongValue(org.get("epinfo"))).filter(epInfo -> epInfo != 0L).collect(Collectors.toList());
        return new HasPermOrgResultImpl(false, epinfoIds);
    }

    public static List<Long> getAuthOrgs() {
        QFilter permissionFilter = new QFilter("servergroup", "=", (Object)PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo()).and("authstate", "=", (Object)"1");
        DynamicObject[] invoicePermission = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])permissionFilter.toArray());
        List authEpInfos = Stream.of(invoicePermission).map(permission -> DynamicObjectUtil.getDynamicObjectLongValue(permission.get("epinfo"))).distinct().collect(Collectors.toList());
        QFilter qFilter = OrgHelper.getIdFilter(authEpInfos, "epinfo");
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bdm_org", (String)"id", (QFilter[])qFilter.toArray());
        return Arrays.stream(orgArr).map(org -> org.getLong("id")).collect(Collectors.toList());
    }

    public static <T> QFilter getIdFilter(Collection<T> ids) {
        return OrgHelper.getIdFilter(ids, "id");
    }

    public static <T> QFilter getIdFilter(Collection<T> ids, String idKey) {
        QFilter qFilter = new QFilter("1", "=", (Object)-1);
        if (CollectionUtils.isEmpty(ids)) {
            return qFilter;
        }
        if (ids.size() <= 1000) {
            qFilter = new QFilter(idKey, "in", ids);
        } else {
            int group = (ids.size() + 1000 - 1) / 1000;
            List partition = Stream.iterate(0, i -> i + 1).limit(group).map(i -> ids.stream().skip(i * 1000).limit(1000L).collect(Collectors.toList())).collect(Collectors.toList());
            for (List hasPermOrg : partition) {
                qFilter.or(idKey, "in", (Object)hasPermOrg);
            }
        }
        return qFilter;
    }

    public static <T> DynamicObjectCollection getListByIds(String formId, String selectField, Collection<T> ids, String idKey) {
        if (ids.size() <= 1000) {
            return QueryServiceHelper.query((String)formId, (String)selectField, (QFilter[])new QFilter(idKey, "in", ids).toArray());
        }
        int group = (ids.size() + 1000 - 1) / 1000;
        List partition = Stream.iterate(0, i -> i + 1).limit(group).map(i -> ids.stream().skip(i * 1000).limit(1000L).collect(Collectors.toList())).collect(Collectors.toList());
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (List idList : partition) {
            collection.addAll((Collection)QueryServiceHelper.query((String)formId, (String)selectField, (QFilter[])new QFilter(idKey, "in", (Object)idList).toArray()));
        }
        return collection;
    }

    public static Set<Long> getUserHasPermEpPk() {
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        QFilter qFilter = userHasPermOrgs.hasAllOrgPerm() ? new QFilter("1", "=", (Object)1) : OrgHelper.getIdFilter(userHasPermOrgs.getHasPermOrgs());
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo", (QFilter[])qFilter.toArray());
        return Stream.of(orgs).map(org -> DynamicObjectUtil.getDynamicObjectLongValue(org.get("epinfo"))).filter(epInfo -> epInfo != 0L).collect(Collectors.toSet());
    }

    public static Set<String> getUserHasPermTaxNo() {
        DynamicObject[] array;
        HasPermOrgResultImpl userHasPermEpInfo = OrgHelper.getUserHasPermEpInfo();
        HashSet<String> taxNoSet = new HashSet<String>();
        QFilter qFilter = null;
        if (!userHasPermEpInfo.hasAllOrgPerm()) {
            qFilter = OrgHelper.getIdFilter(userHasPermEpInfo.getHasPermOrgs());
        }
        if ((array = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])(qFilter == null ? null : qFilter.toArray()))).length > 0) {
            for (DynamicObject ep : array) {
                taxNoSet.add(ep.getString("number"));
            }
        }
        return taxNoSet;
    }

    public static String getDefaultDevFromCache(Long orgId, String batchNo) {
        if (StringUtils.isBlank((CharSequence)batchNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"batchNo\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrgHelper_28", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String cacheKey = "DefaultDevNoFromCache" + batchNo + orgId;
        String cacheDevNo = CacheHelper.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheDevNo)) {
            if ("null".equalsIgnoreCase(cacheDevNo)) {
                return null;
            }
            return cacheDevNo;
        }
        DynamicObject[] imcOrgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"defaultdev", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        String defaultdev = imcOrgs[0].getString("defaultdev");
        CacheHelper.put(cacheKey, "" + defaultdev, 60);
        return defaultdev;
    }

    public Object[] getOrgIdsByTaxNo(String taxNo) {
        DynamicObject[] epInfo = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)taxNo).toArray());
        if (epInfo.length == 0) {
            return new Object[0];
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)"", (QFilter[])new QFilter("epinfo", "in", (Object)Arrays.stream(epInfo).map(DataEntityBase::getPkValue).toArray()).toArray());
        if (orgs.length == 0) {
            return new Object[0];
        }
        return Arrays.stream(orgs).map(DataEntityBase::getPkValue).toArray();
    }

    public static Long getOrgIdByOrgCode(String orgCode) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])new QFilter("number", "=", (Object)orgCode).toArray());
        if (dynamicObject != null) {
            return DynamicObjectUtil.getDynamicObjectLongValue(dynamicObject.getPkValue());
        }
        return null;
    }
}

