/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import org.apache.commons.lang3.StringUtils;

public class PermissionHelper {
    private static final Log log = LogFactory.getLog(PermissionHelper.class);

    public static void checkPermission(AbstractFormPlugin that, ImcPermItemEnum permItemEnum) {
        String entityId = PermissionHelper.getEntityIdByView(that.getView());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String appId = mainEntityType.getAppId();
        PermissionHelper.checkPermission(appId, entityId, permItemEnum);
    }

    public static void checkPermission(String appId, String entityId, ImcPermItemEnum permItemEnum) {
        PermissionHelper.checkPermission(appId, entityId, RequestContext.get().getOrgId(), permItemEnum);
    }

    public static void checkPermission(String appId, String entityId, long orgId, ImcPermItemEnum permItemEnum) {
        RequestContext requestContext = RequestContext.get();
        if (PermissionServiceHelper.checkPermission((Long)Long.parseLong(requestContext.getUserId()), (Long)orgId, (String)appId, (String)entityId, (String)permItemEnum.getPermId()) != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"PermissionHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)entityId).getDisplayName().getLocaleValue(), permItemEnum.getDescription()));
        }
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view) {
        return PermissionHelper.getAllPermOrgs(view, ImcPermItemEnum.ITEM_VIEW.getPermId());
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String perm) {
        return PermissionHelper.getAllPermOrgs(view, PermissionHelper.getEntityIdByView(view), perm);
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String entityId, String perm) {
        return PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(RequestContext.get().getUserId()), (String)PermissionHelper.getAppId(view, entityId), (String)entityId, (String)perm);
    }

    private static String getEntityIdByView(IFormView view) {
        String entityId = view.getEntityId();
        if (view instanceof ListView) {
            entityId = ((ListView)view).getEntityTypeId();
        }
        return entityId;
    }

    private static String getAppId(IFormView view, String entityId) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                appid = mainEntityType.getAppId();
            }
        }
        return appid;
    }

    public static boolean checkOrgPermission(AbstractFormPlugin that, ImcPermItemEnum permItemEnum, Long orgId) {
        return PermissionHelper.checkOrgPermission(that, permItemEnum, "", orgId);
    }

    public static boolean checkOrgPermission(AbstractFormPlugin that, ImcPermItemEnum permItemEnum, String entityId, Long orgId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            entityId = PermissionHelper.getEntityIdByView(that.getView());
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String appId = mainEntityType.getAppId();
        RequestContext requestContext = RequestContext.get();
        return PermissionServiceHelper.checkPermission((Long)Long.parseLong(requestContext.getUserId()), (Long)orgId, (String)appId, (String)entityId, (String)permItemEnum.getPermId()) == 1;
    }

    public static void checkTempFilePermission(String url, String appId, String entityNum, String permItemId) {
        try {
            String tempFileId = UrlUtil.getParam((String)url, (String)"id");
            HashMap<String, String> refEntitiyMap = new HashMap<String, String>(4);
            refEntitiyMap.put("entityNum", entityNum);
            refEntitiyMap.put("appId", appId);
            refEntitiyMap.put("permissionItemId", permItemId);
            DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
            redisCache.put("is_Lose_Efficacy" + tempFileId, (Object)"false", 7200);
            redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
        }
        catch (Throwable e) {
            log.error("\u4e34\u65f6\u6587\u4ef6\u6821\u9a8c\u5931\u8d25" + e.getMessage(), e);
        }
    }
}

