/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.Base64Util;

public class QrCodeUtil {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static final Log LOGGER = LogFactory.getLog(QrCodeUtil.class);

    public static String generateCodeAsBase64Str(String baseUrl, String businessScene, String orgId) throws Exception {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org");
        String taxNo = org.getString("epinfo.number");
        String text = baseUrl + "?businessScene=" + businessScene + "&accountId=" + RequestContext.get().getAccountId() + "&orgId=" + orgId + "&taxNo=" + taxNo;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("qrcode\u5730\u5740\uff1a" + text);
        }
        int width = 165;
        int height = 165;
        Hashtable<EncodeHintType, Object> ht = new Hashtable<EncodeHintType, Object>();
        ht.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        ht.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, ht);
        int b_width = bitMatrix.getWidth();
        int b_height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(b_width, b_height, 5);
        for (int x = 0; x < b_width; ++x) {
            for (int y = 0; y < b_height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", stream);
        return Base64Util.encode(stream.toByteArray());
    }
}

