/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.bo.SmsSettingParamBO;
import kd.imc.bdm.common.constant.SmsSettingConstant;
import kd.imc.bdm.common.enums.SmsBillStatusEnum;
import kd.imc.bdm.common.enums.SmsModuleStatusEnum;
import kd.imc.bdm.common.enums.SmsSignatureStatusEnum;
import kd.imc.bdm.common.helper.SmsSettingHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;

public class SmsSettingHelper {
    private static Log LOGGER = LogFactory.getLog(SmsSettingHelper.class);

    private SmsSettingHelper() {
    }

    private static int countBillCannotSubmit() {
        QFilter filter = new QFilter("billstatus", "in", SmsSettingConstant.BILL_STATUS_CANNOT_SUBMIT);
        DynamicObjectCollection idList = QueryServiceHelper.query((String)"bdm_sms_setting", (String)"id", (QFilter[])filter.toArray());
        return idList.size();
    }

    public static boolean checkSubmitAuditSize(AbstractFormPlugin formPlugin, Integer size) {
        int count = SmsSettingHelper.countBillCannotSubmit();
        if (10 <= count) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u4e2d\u3001\u5ba1\u6838\u6210\u529f\u7684\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"SmsSettingHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]), Integer.valueOf(2000));
            return true;
        }
        if (10 < count + size) {
            formPlugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u4e2d\u3001\u5ba1\u6838\u6210\u529f\u7684\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u8d85\u8fc710\u4e2a,\u5217\u8868\u4e2d\u5ba1\u6838\u4e2d\u3001\u5ba1\u6838\u6210\u529f\u7684\u5df2\u7ecf\u6709%1$s\u4e2a,\u5f53\u524d\u6700\u591a\u53ea\u80fd\u63d0\u4ea4\u5ba1\u6838%2$s\u4e2a", (String)"SmsSettingHelper_6", (String)"imc-bdm-common", (Object[])new Object[0]), count, 10 - count), Integer.valueOf(2000));
            return true;
        }
        return false;
    }

    private static String createSmsSignature(DynamicObject dataEntity) {
        SmsSettingParamBO smsSettingParam = SmsSettingHelper.getSmsSettingParam();
        String url = smsSettingParam.getSignatureCreateUrl();
        String signature = dataEntity.getString("formworkcontent");
        String approve = dataEntity.getString("applyreason");
        HashSet param = Sets.newHashSet((Object[])new NameValuePair[]{new BasicNameValuePair("signature", signature), new BasicNameValuePair("approve", approve), new BasicNameValuePair("sms_dev_id", smsSettingParam.getSmsDevIdValue()), new BasicNameValuePair("sms_project_id", smsSettingParam.getSmsProjectIdValue()), new BasicNameValuePair("sms_user_id", smsSettingParam.getSmsUserIdValue())});
        return HttpUtil.doPostForm(url, new ArrayList<NameValuePair>(param), SmsSettingHelper.creatHeaderMap(smsSettingParam.getSmsClientIdValue()));
    }

    private static String createSmsContentModule(Long signatureId) {
        LOGGER.info("\u7b7e\u540d\u53c2\u6570\u4e3a\uff1a{}", (Object)signatureId);
        SmsSettingParamBO smsSettingParam = SmsSettingHelper.getSmsSettingParam();
        String url = smsSettingParam.getModuleCreateUrl();
        HashSet param = Sets.newHashSet((Object[])new NameValuePair[]{new BasicNameValuePair("name", String.format("\u53d1\u7968\u4e91\u661f\u701a\u53d1\u7968\u77ed\u4fe1\u5185\u5bb9\u6a21\u677f_%s", signatureId)), new BasicNameValuePair("type", "0"), new BasicNameValuePair("content", "\u7535\u5b50\u53d1\u7968\u5df2\u5f00\u5177,\u53d1\u7968\u91d1\u989d{{.}},\u62ac\u5934:{{.}} \u4e0b\u8f7d\u53d1\u7968\uff1a{{.}}"), new BasicNameValuePair("app_id", smsSettingParam.getSmsClientIdValue()), new BasicNameValuePair("sign_id", String.valueOf(signatureId)), new BasicNameValuePair("sms_dev_id", smsSettingParam.getSmsDevIdValue()), new BasicNameValuePair("sms_project_id", smsSettingParam.getSmsProjectIdValue()), new BasicNameValuePair("sms_user_id", smsSettingParam.getSmsUserIdValue())});
        return HttpUtil.doPostForm(url, new ArrayList<NameValuePair>(param), SmsSettingHelper.creatHeaderMap(smsSettingParam.getSmsClientIdValue()));
    }

    private static void updateSmsSttingStatus(DynamicObject dataEntity, Long smsSignatureId, Long smsCode, Integer billStatus, Integer dxqmStatus, Integer dxnrStatus) {
        QFilter filter = new QFilter("id", "=", (Object)dataEntity.getLong("id"));
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bdm_sms_setting", (String)"id,billstatus,dxqm_status,dxqmid,dxnrid,dxnr_status,failreason", (QFilter[])filter.toArray());
        if (null != billStatus) {
            object.set("billstatus", (Object)billStatus);
        }
        if (null != dxqmStatus) {
            object.set("dxqm_status", (Object)dxqmStatus);
        }
        if (null != dxnrStatus) {
            object.set("dxnr_status", (Object)dxnrStatus);
        }
        if (null != smsSignatureId) {
            object.set("dxqmid", (Object)smsSignatureId);
        }
        if (null != smsCode) {
            object.set("dxnrid", (Object)smsCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)object.getString("failreason"))) {
            object.set("failreason", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public static Map<String, JSONObject> getAuditResult(DynamicObject dataEntity, SmsSettingParamBO smsSettingParam, String dataEntityIdName, String path, String dxptIdName) {
        String id = dataEntity.getString(dataEntityIdName);
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            ids.add(id);
        }
        String billStatus = dataEntity.getString("billstatus");
        if (String.valueOf(SmsBillStatusEnum.AUDIT_SUCCESS.getStatus()).equals(billStatus)) {
            return new HashMap<String, JSONObject>();
        }
        return SmsSettingHelper.querySmsAuditResult(smsSettingParam, path, dxptIdName, ids);
    }

    public static SmsSettingParamBO getSmsSettingParam() {
        ImcConfigUtil.removeCache("bdm_sms_config");
        Map<String, String> smsSettingParamMap = ImcConfigUtil.getValue("bdm_sms_config");
        StringBuilder errorMsg = new StringBuilder();
        SmsSettingParamBO smsSettingParamBO = null;
        try {
            smsSettingParamBO = (SmsSettingParamBO)SmsSettingParamBO.class.newInstance();
            Map<String, String> fieldMap = SmsSettingConstant.SMS_SETTING_CONFIG_FIELD_MAP;
            for (Map.Entry<String, String> fieldEntry : fieldMap.entrySet()) {
                try {
                    if (smsSettingParamMap.containsKey(fieldEntry.getKey())) {
                        Field declaredField = smsSettingParamBO.getClass().getDeclaredField(fieldEntry.getValue());
                        ReflectionUtils.makeAccessible((Field)declaredField);
                        declaredField.set(smsSettingParamBO, smsSettingParamMap.get(fieldEntry.getKey()));
                        continue;
                    }
                    errorMsg.append(fieldEntry.getKey()).append(',');
                }
                catch (NoSuchFieldException e) {
                    errorMsg.append(fieldEntry.getKey()).append(',');
                }
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            errorMsg.append(e.getMessage());
        }
        if (0 < errorMsg.length() || smsSettingParamBO == null) {
            String msg = errorMsg.toString();
            if (errorMsg.toString().endsWith(",")) {
                msg = errorMsg.substring(0, errorMsg.length() - 1);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u914d\u7f6e\u5355\u636e\u672a\u914d\u7f6e:%s", (String)"SmsSettingHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]), msg));
        }
        return smsSettingParamBO;
    }

    public static Map<String, JSONObject> querySmsAuditResult(SmsSettingParamBO smsSettingParamBO, String path, String dxptIdName, List<String> ids) {
        1 param;
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        if (CollectionUtils.isEmpty(ids)) {
            return result;
        }
        String url = SmsSettingHelper.createUrl(smsSettingParamBO.getSmsPrefixUrl(), path, smsSettingParamBO.getSmsClientIdValue(), smsSettingParamBO.getSmsClientSecretValue());
        String getResp = HttpUtil.doGet(url, (Map<String, String>)(param = new /* Unavailable Anonymous Inner Class!! */));
        if (StringUtils.isEmpty((CharSequence)getResp)) {
            return result;
        }
        JSONObject resultJSON = JSONObject.parseObject((String)getResp);
        if (Long.valueOf("0").equals(resultJSON.getLong("errcode"))) {
            JSONArray data = resultJSON.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String pkId = String.valueOf(jsonObject.getLong(dxptIdName));
                if (!ids.contains(pkId)) continue;
                result.put(pkId, jsonObject);
            }
        }
        return result;
    }

    public static String createUrl(String prefixUrl, String path, String clientId, String clientSecret) {
        StringBuilder urlBuilder = new StringBuilder(prefixUrl);
        urlBuilder.append(path);
        TreeMap<String, String> queryParamMap = new TreeMap<String, String>();
        queryParamMap.put("client_id", clientId);
        queryParamMap.put("client_secret", clientSecret);
        StringBuilder pathBuilder = new StringBuilder();
        if (queryParamMap.size() > 0) {
            urlBuilder.append('?');
            for (Map.Entry entry : queryParamMap.entrySet()) {
                pathBuilder.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('&');
            }
            urlBuilder.append(pathBuilder.substring(0, pathBuilder.length() - 1));
        }
        return urlBuilder.toString();
    }

    private static Map<String, String> creatHeaderMap(String clientId) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        headerMap.put("X-Api-ClientID", clientId);
        return headerMap;
    }

    public static void submitAndAudit(DynamicObject dataEntity) {
        Long signatureId = SmsSettingHelper.getSignatureId(dataEntity);
        SmsSettingHelper.createSmsContentModule(dataEntity, signatureId);
    }

    private static void createSmsContentModule(DynamicObject dataEntity, Long signatureId) {
        LOGGER.info("\u83b7\u53d6\u77ed\u4fe1\u6a21\u677f:{}", (Object)signatureId);
        String dxnrStatus = dataEntity.getString("dxnr_status");
        String dxnrId = dataEntity.getString("dxnrid");
        if (!SmsModuleStatusEnum.validStatus(dxnrStatus) || StringUtils.isEmpty((CharSequence)dxnrId)) {
            String smsContentCreateResult = SmsSettingHelper.createSmsContentModule(signatureId);
            JSONObject smsContentCreateResultJSON = JSONObject.parseObject((String)smsContentCreateResult);
            if (Long.valueOf("0").equals(smsContentCreateResultJSON.getLong("errcode"))) {
                Long mid = smsContentCreateResultJSON.getJSONObject("data").getLong("mid");
                SmsSettingHelper.updateSmsSttingStatus(dataEntity, null, mid, SmsBillStatusEnum.AUDITTING.getStatus(), null, SmsModuleStatusEnum.AUDITTING.getStatus());
            } else {
                String description = smsContentCreateResultJSON.getString("description_cn");
                throw new KDBizException(description);
            }
        }
    }

    private static Long getSignatureId(DynamicObject dataEntity) {
        Long sid;
        String dxqmStatus = dataEntity.getString("dxqm_status");
        String dxqmId = dataEntity.getString("dxqmid");
        if (SmsSignatureStatusEnum.cannotSubmit(dxqmStatus) && StringUtils.isNotEmpty((CharSequence)dxqmId)) {
            sid = Long.parseLong(dxqmId);
        } else {
            String signatureCreateResult = SmsSettingHelper.createSmsSignature(dataEntity);
            JSONObject signatureCreateResultJSON = JSONObject.parseObject((String)signatureCreateResult);
            if (Long.valueOf("0").equals(signatureCreateResultJSON.getLong("errcode"))) {
                sid = signatureCreateResultJSON.getJSONObject("data").getLongValue("sid");
                SmsSettingHelper.updateSmsSttingStatus(dataEntity, sid, null, SmsBillStatusEnum.AUDITTING.getStatus(), SmsSignatureStatusEnum.AUDITTING.getStatus(), null);
            } else {
                String description = signatureCreateResultJSON.getString("description_cn");
                if (Long.valueOf("5306").equals(signatureCreateResultJSON.getLong("errorcode"))) {
                    description = String.format(ResManager.loadKDString((String)"\u77ed\u4fe1\u7b7e\u540d\u5185\u5bb9:\"%s\"\u5df2\u5b58\u5728", (String)"SmsSettingHelper_5", (String)"imc-bdm-common", (Object[])new Object[0]), dataEntity.getString("formworkcontent"));
                }
                throw new KDBizException(description);
            }
        }
        return sid;
    }

    private static void updateSmsSettingStatus(Map<String, JSONObject> auditResultMap, DynamicObject dynamicObject, StringBuilder failReason, String dxptId, String dxptStatusName) {
        JSONObject jsonObject = auditResultMap.get(dxptId);
        if (jsonObject != null) {
            String description;
            String state = jsonObject.getString("state");
            dynamicObject.set(dxptStatusName, (Object)state);
            if (SmsSignatureStatusEnum.AUDIT_FAIL.getStatusText().equals(state) && StringUtils.isNotEmpty((CharSequence)(description = jsonObject.getString("description")))) {
                failReason.append(description).append(';');
            }
        }
    }

    public static void updateSmsSettingStatus(Map<String, JSONObject> smsSignatureMap, Map<String, JSONObject> smsModuleMap, DynamicObject dynamicObject) {
        String dxqmId = dynamicObject.getString("dxqmid");
        if (StringUtils.isEmpty((CharSequence)dxqmId)) {
            return;
        }
        StringBuilder failReason = new StringBuilder();
        SmsSettingHelper.updateSmsSettingStatus(smsSignatureMap, dynamicObject, failReason, dxqmId, "dxqm_status");
        String dxnrId = dynamicObject.getString("dxnrid");
        if (StringUtils.isEmpty((CharSequence)dxnrId)) {
            return;
        }
        SmsSettingHelper.updateSmsSettingStatus(smsModuleMap, dynamicObject, failReason, dxnrId, "dxnr_status");
        if (SmsSignatureStatusEnum.validStatus(dynamicObject.getString("dxqm_status")) && SmsModuleStatusEnum.validStatus(dynamicObject.getString("dxnr_status"))) {
            dynamicObject.set("billstatus", (Object)SmsBillStatusEnum.AUDIT_SUCCESS.getStatus());
        }
        if (SmsSignatureStatusEnum.AUDIT_FAIL.getStatusText().equals(dynamicObject.getString("dxqm_status")) || SmsModuleStatusEnum.AUDIT_FAIL.getStatusText().equals(dynamicObject.getString("dxnr_status"))) {
            dynamicObject.set("billstatus", (Object)SmsBillStatusEnum.AUDIT_FAIL.getStatus());
        }
        if (failReason.length() > 0) {
            dynamicObject.set("failreason", (Object)failReason.toString());
        }
    }
}

