/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HTXXUtil;

public class SynchronizationQuotaHelper {
    private static Log logger = LogFactory.getLog(SynchronizationQuotaHelper.class);
    public static final String CLOSED_QUOTA = "CLOSED_QUOTA_CONFIRM";

    public static JSONObject synEntityUKeyQuota(String deviceNo) {
        String componentRequestUrl = ComponentServiceHelper.getComponentRequestUrl(deviceNo);
        JSONObject requestData = new JSONObject();
        requestData.put("czlx", (Object)"7");
        requestData.put("sfrz", null);
        requestData.put("hxbzdh", (Object)"");
        if (UnitTestHelper.isUnitTest()) {
            JSONObject json = new JSONObject();
            json.put("errcode", (Object)"0");
            JSONObject sjd = new JSONObject();
            sjd.put("zyfpkpxe", (Object)1000);
            sjd.put("ptfpkpxe", (Object)1000);
            sjd.put("djdpfpkpxe", (Object)1000);
            sjd.put("djdpzyfpkpxe", (Object)1000);
            json.put("sjd", (Object)sjd);
            return json;
        }
        return ComponentServiceHelper.doPost(componentRequestUrl, JSON.toJSONString((Object)requestData));
    }

    public static void checkAndOpenSyncQuota(AbstractFormPlugin form, String taxNo, String devNo) {
        DynamicObjectCollection devList;
        if (null == form || kd.bos.util.StringUtils.isBlank((String)devNo) || "0".equals(devNo)) {
            return;
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)taxNo) && "0".equals(taxNo)) {
            taxNo = null;
        }
        if (null != (devList = SynchronizationQuotaHelper.getDevList(taxNo, devNo)) && devList.size() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSED_QUOTA, (IFormPlugin)form);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SynchronizationQuotaHelper_0", (String)"imc-bdm-common", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540c\u6b65", (String)"SynchronizationQuotaHelper_1", (String)"imc-bdm-common", (Object[])new Object[0]));
            form.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f00\u7968\u8bbe\u5907(%1$s)\u5c1a\u672a\u540c\u6b65\u9650\u989d\u4fe1\u606f\uff0c\u8bf7\u5148\u63d2\u5165\u5b9e\u4f53\u5f00\u7968\u8bbe\u5907\uff0c\u7136\u540e\u70b9\u51fb%2$s\u540c\u6b65%3$s\u4ee5\u5b8c\u6210\u4fe1\u606f\u540c\u6b65(\u865a\u62df\u8bbe\u5907\u53ef\u76f4\u63a5\u70b9\u51fb)\u3002", (String)"SynchronizationQuotaHelper_10", (String)"imc-bdm-common", (Object[])new Object[0]), devNo, "\"", "\""), "", MessageBoxOptions.YesNo, ConfirmTypes.Wait, confirmCallBacks, btnNameMaps);
        }
    }

    public static void closedCallBack(MessageBoxClosedEvent messageBoxClosedEvent, AbstractFormPlugin form, String taxNo, String devNo) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CLOSED_QUOTA.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            DynamicObjectCollection devList = SynchronizationQuotaHelper.getDevList(taxNo, devNo);
            if (null != devList && devList.size() > 0) {
                DynamicObject o = (DynamicObject)devList.get(0);
                String s = SynchronizationQuotaHelper.saveQuota(o.getString("id"), taxNo, o.getString("equipmentno"), o.getString("equipmenttype"));
                if ("success".equals(s)) {
                    form.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"SynchronizationQuotaHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]), Integer.valueOf(3000));
                } else if ("error".equals(s)) {
                    form.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"SynchronizationQuotaHelper_5", (String)"imc-bdm-common", (Object[])new Object[0]));
                } else {
                    form.getView().showTipNotification(s, Integer.valueOf(3000));
                }
            } else {
                form.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"SynchronizationQuotaHelper_4", (String)"imc-bdm-common", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    private static DynamicObjectCollection getDevList(String taxNo, String devNo) {
        QFilter filter = new QFilter("paperzticketquota", "=", (Object)0);
        filter.and("paperpticketquota", "=", (Object)0);
        filter.and("electzticketquota", "=", (Object)0);
        filter.and("electpticketquota", "=", (Object)0);
        filter.and("equipmenttype", "in", (Object)new String[]{"0", "1", "2", "3", "9", "10", "11"});
        if (kd.bos.util.StringUtils.isNotEmpty((String)taxNo) && !"0".equals(taxNo)) {
            filter.and("epinfo.number", "=", (Object)taxNo);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)devNo) && !"0".equals(devNo)) {
            filter.and("equipmentno", "=", (Object)devNo);
        }
        return QueryServiceHelper.query((String)"bdm_tax_equipment", (String)"id,equipmentno,equipmenttype", (QFilter[])filter.toArray());
    }

    public static void syncNowTaxQuotaNoByOrg() {
        String taxNo;
        DynamicObject epInfo;
        QFilter filter = new QFilter("id", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])filter.toArray());
        if (null != org && null != (epInfo = org.getDynamicObject("epinfo")) && StringUtils.isNotBlank((CharSequence)(taxNo = epInfo.get("number") + "")) && !"0".equals(taxNo)) {
            SynchronizationQuotaHelper.saveQuotaByTaxNoAsync(taxNo);
        }
    }

    private static void saveQuotaByTaxNoAsync(String taxNo) {
        String prefix = "IMC_BDM_DEV_QUOTA_";
        String key = CacheHelper.get(prefix + taxNo);
        if (kd.bos.util.StringUtils.isNotEmpty((String)key)) {
            return;
        }
        CacheHelper.put(prefix + taxNo, prefix + taxNo + "-" + System.currentTimeMillis(), 1);
        ThreadPools.executeOnce((String)"asyncSaveDevQuotaByTaxNo", () -> {
            DynamicObjectCollection devList = SynchronizationQuotaHelper.getDevList(taxNo, null);
            devList.forEach(o -> SynchronizationQuotaHelper.saveQuota(o.getString("id"), taxNo, o.getString("equipmentno"), o.getString("equipmenttype")));
        });
    }

    public static String saveQuota(String eqInfoId, String taxNo, String deviceNo, String eqInfoType) {
        if (kd.bos.util.StringUtils.isEmpty((String)eqInfoId)) {
            return ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff01", (String)"SynchronizationQuotaHelper_11", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        String result = "success";
        try {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)eqInfoId, (String)"bdm_tax_equipment");
            StringBuilder invoiceTypes = new StringBuilder();
            if ("0".equals(eqInfoType) || "1".equals(eqInfoType) || "2".equals(eqInfoType)) {
                JSONObject resp = SynchronizationQuotaHelper.synEntityUKeyQuota(deviceNo);
                if ("0".equals(resp.get((Object)"errcode"))) {
                    Object djdpfpkpxe;
                    Object djdpzyfpkpxe;
                    Object ptfpkpxe;
                    JSONObject sjd = resp.getJSONObject("sjd");
                    Object zyfpkpxe = sjd.get((Object)"zyfpkpxe");
                    if (zyfpkpxe != null) {
                        invoiceTypes.append("004,");
                        obj.set("paperzticketquota", (Object)(zyfpkpxe + ""));
                    }
                    if ((ptfpkpxe = sjd.get((Object)"ptfpkpxe")) != null) {
                        invoiceTypes.append("007,");
                        obj.set("paperpticketquota", (Object)(ptfpkpxe + ""));
                    }
                    if ((djdpzyfpkpxe = sjd.get((Object)"djdpzyfpkpxe")) != null) {
                        invoiceTypes.append("028,");
                        obj.set("electzticketquota", (Object)(djdpzyfpkpxe + ""));
                    }
                    if ((djdpfpkpxe = sjd.get((Object)"djdpfpkpxe")) != null) {
                        invoiceTypes.append("026,");
                        obj.set("electpticketquota", (Object)(djdpfpkpxe + ""));
                    }
                    obj.set("ticketquota", null);
                    obj.set("motorticketquota", null);
                } else {
                    result = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76d8\u6216UKEY\u662f\u5426\u8fde\u63a5\u6b63\u5e38\uff01", (String)"SynchronizationQuotaHelper_12", (String)"imc-bdm-common", (Object[])new Object[0]);
                }
            } else if ("3".equals(eqInfoType)) {
                result = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u865a\u62dfUKEY\u540c\u6b65\u9650\u989d", (String)"SynchronizationQuotaHelper_13", (String)"imc-bdm-common", (Object[])new Object[0]);
            } else if (EquipmentType.isLyServer(eqInfoType)) {
                MsgResponse res = SynchronizationQuotaHelper.synLyServerQuota(deviceNo);
                if ("0000".equals(res.getErrorCode())) {
                    String json = res.getRespData();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)json)) {
                        List list = JSON.parseArray((String)json, Map.class);
                        SynchronizationQuotaHelper.setQuota(obj, invoiceTypes, list);
                    }
                } else {
                    result = ResManager.loadKDString((String)"\u540c\u6b65\u8054\u4e91\u8bbe\u5907\u9650\u989d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7a0e\u63a7\u7cfb\u7edf\u4e91\u914d\u7f6e\uff01", (String)"SynchronizationQuotaHelper_14", (String)"imc-bdm-common", (Object[])new Object[0]);
                }
            }
            ImcSaveServiceHelper.save(obj);
        }
        catch (Exception e) {
            logger.error("\u5b58\u5165\u9650\u989d\u4fe1\u606f\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            result = "error";
        }
        return result;
    }

    private static void setQuota(DynamicObject obj, StringBuilder invoiceTypes, List<Map> list) {
        for (Map map : list) {
            String num = map.get("limit") + "";
            switch (map.get("invoiceType") + "") {
                case "004": {
                    invoiceTypes.append("004,");
                    obj.set("paperzticketquota", (Object)num);
                    break;
                }
                case "007": {
                    invoiceTypes.append("007,");
                    obj.set("paperpticketquota", (Object)num);
                    break;
                }
                case "028": {
                    invoiceTypes.append("028,");
                    obj.set("electzticketquota", (Object)num);
                    break;
                }
                case "026": {
                    invoiceTypes.append("026,");
                    obj.set("electpticketquota", (Object)num);
                    break;
                }
                case "025": {
                    invoiceTypes.append("025,");
                    obj.set("ticketquota", (Object)num);
                    break;
                }
                case "005": {
                    invoiceTypes.append("005,");
                    obj.set("motorticketquota", (Object)num);
                    break;
                }
            }
        }
    }

    public static MsgResponse synLyServerQuota(String devNo) {
        MsgResponse response = new MsgResponse();
        JSONObject params = new JSONObject();
        try {
            params.put("jqbh", (Object)devNo);
            logger.info(String.format("synLyServerQuota taxNo:%s", devNo));
            String res = UnitTestHelper.isUnitTest() ? "[{\"limit\": \"99999999.99\",\"invoiceType\": \"004\"},{\"limit\": \"99999999.99\",\"invoiceType\": \"007\"},{\"limit\": \"99999999.99\",\"invoiceType\": \"026\"},{\"limit\": \"99999999.99\",\"invoiceType\": \"028\"},{\"limit\": \"99999999.99\",\"invoiceType\": \"025\"},{\"limit\": \"99999999.99\",\"invoiceType\": \"005\"}]" : HTXXUtil.callIsmcInvoice(params, "LyServerOpenInvoice", "query_limit");
            logger.info(String.format("synLyServerQuota res:%s", res));
            response.setRespData(res);
            response.setErrorCode(ErrorType.SUCCESS.getCode());
            logger.info(String.format("synLyServerQuota res:%s", res));
        }
        catch (MsgException e) {
            logger.error((Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(e.getMessage());
        }
        return response;
    }
}

