/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.beanutils.ConvertUtils;

public class HSAmountSplitHelper {
    public static DynamicObject getHSAmountSplitConfigDynamicObject(long orgId) {
        DynamicObject[] hsConfigDynamicObjectList = HSAmountSplitHelper.getHSConfigDynamicObjectList();
        if (hsConfigDynamicObjectList == null || hsConfigDynamicObjectList.length < 1) {
            return null;
        }
        for (DynamicObject dynamicObject : hsConfigDynamicObjectList) {
            List<Long> orgList = HSAmountSplitHelper.getOrgList(dynamicObject.getString("orgs_tag"));
            for (Long aLong : orgList) {
                if (aLong != orgId) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    public static String getHSAmountSplitRuleType(long orgId) {
        DynamicObject hsConfigDynamicObject = HSAmountSplitHelper.getHSAmountSplitConfigDynamicObject(orgId);
        if (hsConfigDynamicObject == null) {
            return "1";
        }
        return hsConfigDynamicObject.getString("splitrule");
    }

    public static List<Long> getOrgList(String orgListStr) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)orgListStr)) {
            orgList.addAll(Arrays.asList((Long[])ConvertUtils.convert((String[])orgListStr.split(","), Long.class)));
        }
        return orgList;
    }

    public static DynamicObject[] getHSConfigDynamicObjectList() {
        QFilter qFilter = new QFilter("hssplitamountenable", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"bdm_split_hs_config", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_split_hs_config"), (QFilter[])new QFilter[]{qFilter});
    }

    public static BigDecimal getUserSetHSAmountLimitByInvoiceType(DynamicObject dynamicObject, String invoiceType) {
        BigDecimal hsLimit = BigDecimal.ZERO;
        if (dynamicObject == null) {
            return hsLimit;
        }
        if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            hsLimit = dynamicObject.getBigDecimal("normalelectroniclimit");
        } else if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            hsLimit = dynamicObject.getBigDecimal("specialelectroniclimit");
        } else if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            hsLimit = dynamicObject.getBigDecimal("normalpaperlimit");
        } else if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            hsLimit = dynamicObject.getBigDecimal("specialpaperlimit");
        } else if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
            hsLimit = dynamicObject.getBigDecimal("normalallelimit");
        } else if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(invoiceType)) {
            hsLimit = dynamicObject.getBigDecimal("specialallelimit");
        }
        return hsLimit;
    }
}

