/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.helper.cache;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.PropertieUtil;

public class MsgAuthSettingCacheHelper {
    public static String getCacheByOrgId(long orgId) {
        String settingCache = CacheHelper.get("msgAuthSetting" + orgId);
        if (Objects.isNull(settingCache)) {
            QFilter filter = new QFilter("orgid", "=", (Object)orgId);
            DynamicObject setting = BusinessDataServiceHelper.loadSingle((String)"bdm_msg_auth_setting", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_msg_auth_setting"), (QFilter[])filter.toArray());
            HashMap<String, String> map = new HashMap<String, String>(4);
            if (setting != null) {
                map.put("checkphone", StringUtils.isBlank((CharSequence)setting.getString("checkphone")) ? CheckPhoneEnum.DEFAULT.getCode() : setting.getString("checkphone"));
            } else {
                map.put("checkphone", CheckPhoneEnum.DEFAULT.getCode());
            }
            settingCache = JSONObject.toJSONString(map);
            CacheHelper.put("msgAuthSetting" + orgId, settingCache);
        }
        return settingCache;
    }

    public static String getCacheCheckPhoneByOrgId(long orgId) {
        String cacheStr = MsgAuthSettingCacheHelper.getCacheByOrgId(orgId);
        if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
            Map cacheJson = (Map)JSONObject.parseObject((String)cacheStr, Map.class);
            return (String)cacheJson.get("checkphone");
        }
        return CheckPhoneEnum.DEFAULT.getCode();
    }

    public static boolean isCheckPhone(long orgId) {
        return CheckPhoneEnum.DEFAULT.getCode().equals(MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId(orgId));
    }

    public static void deleteCacheByOry(long orgId) {
        CacheHelper.remove("msgAuthSetting" + orgId);
    }
}

