/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.invoicecallback.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.imc.bdm.common.constant.FiBotpReplayEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.CallBackProcessDto;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.dto.FiBotpCallBackArBillItemVo;
import kd.imc.bdm.common.dto.FiBotpCallBackArBillVo;
import kd.imc.bdm.common.dto.FiBotpCallBackReplayVo;
import kd.imc.bdm.common.dto.FiBotpCallBackVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.invoicecallback.AbstractInvoiceCallBackServiceImpl;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class FiBotpCallBackServiceImpl
extends AbstractInvoiceCallBackServiceImpl {
    private String tgtEntryNumber = "sim_original_bill_item";
    private static final String SIM_BILL_RELATION_FIELDS = "id,sbillid,sdetailid,tbillid,tdetailid,amount,tax,num,pushtype";
    private static final Log LOGGER = LogFactory.getLog(FiBotpCallBackServiceImpl.class);
    private static final String QUERY_RELATION_WAY_SMART = "2";
    private static final String QUERY_RELATION_WAY_BILL_INV_RELATION = "1";

    @Override
    public boolean support(CallbackLogVo callbackLogVo) {
        String businessSystemCode = callbackLogVo.getBusinessSystemCode();
        return "AR_FINARBILL".equals(businessSystemCode) || "\u8d22\u52a1\u5e94\u6536\u5355".equals(businessSystemCode) || "AR_BUSBILL".equals(businessSystemCode);
    }

    @Override
    public CallbackResponseVo callBack(CallbackLogVo callbackLogVo, DynamicObject invoice) {
        try {
            String invoiceNo = invoice.getString("invoiceno");
            String invoiceCode = invoice.getString("invoicecode");
            LOGGER.info(String.format("user:%s,FiBotpCallBackServiceImplCallBack\u53d1\u7968\u53f7\u7801\uff1a%s,\u53d1\u7968\u4ee3\u7801\uff1a%s,\u4e1a\u52a1\u7cfb\u7edf\uff1a%s\u8fdb\u5165\u56de\u8c03", RequestContext.get().getUserName(), invoiceNo, invoiceCode, callbackLogVo.getBusinessSystemCode()));
            invoice = this.useInvoiceWithPk(invoiceNo, invoiceCode);
            FiBotpCallBackVo callBackVo = this.generateCallBackVo(invoice);
            CallBackProcessDto processDto = new CallBackProcessDto();
            processDto.setCallBackType(callbackLogVo.getCallbackType());
            processDto.setCallBackNo(callbackLogVo.getCallBackNo());
            if (OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL_FILL_IN.getCode().equals(callbackLogVo.getBusinessType())) {
                callBackVo.setInvoiceStatus("6");
            }
            List<ArBillRelationExtensionDTO> billRelationDTOS = this.queryInvoiceItemRelation(invoice, processDto);
            String invoiceStatus = invoice.getString("invoicestatus");
            String issueType = invoice.getString("issuetype");
            LOGGER.info(String.format("invoiceNo:%s,invoiceStatus:%s,issueType:%s,firstRelation:%s", invoiceNo, invoiceStatus, issueType, JSONObject.toJSONString(billRelationDTOS)));
            if (null != billRelationDTOS && billRelationDTOS.size() > 0) {
                LOGGER.info("\u67e5\u627e\u5230\u5173\u7cfb");
                processDto.setNoRelation(false);
                processDto.setInvoiceBillRelation(billRelationDTOS);
                this.pushedBillCallBack(invoice, callBackVo, billRelationDTOS, processDto);
                if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                    callBackVo.setOriInvoiceCode(invoice.getString("originalinvoicecode"));
                    callBackVo.setOriInvoiceNo(invoice.getString("originalinvoiceno"));
                    callBackVo.setOriInvoiceStatus("3");
                }
            } else {
                LOGGER.info("\u6ca1\u6709\u67e5\u627e\u5230\u5173\u7cfb");
                processDto.setNoRelation(true);
                this.noRelationCallBack(invoice, callBackVo, processDto);
            }
            callBackVo.setFrom(processDto.getFrom());
            if (StringUtils.isNotBlank((CharSequence)processDto.getMergeLable())) {
                callBackVo.setMergeLable(processDto.getMergeLable());
            }
            LOGGER.info("\u5e94\u6536BOTP\u56de\u63a8\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)callBackVo));
            this.dealFromData(callBackVo);
            String responseStr = this.callBack(callbackLogVo, callBackVo);
            FiBotpCallBackReplayVo response = (FiBotpCallBackReplayVo)JSONObject.parseObject((String)responseStr, FiBotpCallBackReplayVo.class);
            if (FiBotpReplayEnum.Success == response.getReplayStatus()) {
                this.verificate(invoiceStatus, issueType, processDto);
                this.addBotpLog(invoiceStatus, JSONObject.toJSONString((Object)callBackVo), invoice);
                return CallbackResponseVo.valueOfSuccess(responseStr, FiBotpReplayEnum.Success.getStatus());
            }
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), response.getErrorMsg());
        }
        catch (MsgException e) {
            LOGGER.error("\u56de\u5199\u5e94\u6536\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + e.getErrorMsg(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("\u56de\u5199\u5e94\u6536\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return CallbackResponseVo.valueOfError(String.valueOf(FiBotpReplayEnum.fail.getCode()), e.getMessage());
        }
        catch (Throwable t) {
            LOGGER.error("\u56de\u5199\u5e94\u6536\u4e1a\u52a1\u5904\u7406\u5931\u8d25:" + t.getMessage(), t);
            throw t;
        }
    }

    private void dealFromData(FiBotpCallBackVo callBackVo) {
        if (callBackVo.getFrom().booleanValue()) {
            this.convertCallBackVo(callBackVo);
            LOGGER.info("\u5e94\u6536BOTP\u56de\u63a8\u5916\u5e01\u8f6c\u5316\u540e\u7684\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)callBackVo));
        } else {
            this.fillFromData(callBackVo);
        }
    }

    public void addBotpLog(String invoiceStatus, String paramJson, DynamicObject invoice) {
        try {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
            log.set("invoicecode", (Object)invoice.getString("invoicecode"));
            log.set("invoiceno", (Object)invoice.getString("invoiceno"));
            log.set("createtime", (Object)new Date());
            log.set("business", (Object)"0");
            log.set("param_tag", (Object)paramJson);
            log.set("invoicestatus", (Object)invoiceStatus);
            ImcSaveServiceHelper.save(log);
        }
        catch (Exception e) {
            LOGGER.error("addBotpLogFail" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verificate(String invoiceStatus, String issueType, CallBackProcessDto processDto) {
        try {
            String key;
            List<ArBillRelationExtensionDTO> invoiceBillRelation = processDto.getInvoiceBillRelation();
            ArrayList billPks = new ArrayList(invoiceBillRelation.stream().map(BillRelationDTO::getsBillId).collect(Collectors.toSet()));
            HashMap unVerfyByOp = new HashMap(8);
            if (processDto.isNoRelation()) {
                if ("6".equals(invoiceStatus)) {
                    if (!IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) {
                        LOGGER.info("\u7ea2\u7968\u4f5c\u5e9f\uff0c\u4e0d\u8c03\u7528\u51b2\u9500");
                        return;
                    }
                    key = "billcancel";
                } else {
                    key = "billred";
                }
            } else {
                key = "6".equals(invoiceStatus) ? "billcancel" : "billopen";
            }
            unVerfyByOp.put(key, billPks);
            LOGGER.info("\u6838\u9500\u63a5\u53e3\u53c2\u6570\uff1a" + JSONObject.toJSONString(unVerfyByOp));
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"SimtoArVerifyByOpService", (String)"simAndArVerifyByOp", (Object[])new Object[]{JSONObject.toJSONString(unVerfyByOp)});
            return;
        }
        catch (Exception e) {
            LOGGER.info("\u51b2\u9500\u5931\u8d25:" + e.getMessage(), (Object)e);
        }
    }

    private String callBack(CallbackLogVo callbackLogVo, FiBotpCallBackVo callBackVo) {
        String responseStr;
        String systemCode;
        switch (systemCode = callbackLogVo.getBusinessSystemCode()) {
            case "AR_BUSBILL": {
                responseStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"updateBusArBill", (String)"updateBusArBill", (Object[])new Object[]{JSONObject.toJSONString((Object)callBackVo)});
                break;
            }
            default: {
                responseStr = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"updateFinArBill", (String)"updateFinArBill", (Object[])new Object[]{JSONObject.toJSONString((Object)callBackVo)});
            }
        }
        return responseStr;
    }

    private void fillFromData(FiBotpCallBackVo callBackVo) {
        List<FiBotpCallBackArBillVo> ars = callBackVo.getArs();
        for (FiBotpCallBackArBillVo billVo : ars) {
            List<FiBotpCallBackArBillItemVo> items = billVo.getArItems();
            for (FiBotpCallBackArBillItemVo item : items) {
                item.setInfluenceFromAmount(item.getInfluenceAmount());
                item.setInfluenceFromTaxAmount(item.getInfluenceAmountIncludeTax());
                item.setInfluenceFromTax(item.getInfluencetax());
            }
        }
    }

    public void convertCallBackVo(FiBotpCallBackVo callBackVo) {
        List<FiBotpCallBackArBillVo> ars = callBackVo.getArs();
        for (FiBotpCallBackArBillVo ar : ars) {
            List<FiBotpCallBackArBillItemVo> arItems = ar.getArItems();
            for (FiBotpCallBackArBillItemVo arItem : arItems) {
                BigDecimal influenceTax = arItem.getInfluenceFromTax();
                BigDecimal influenceAmount = arItem.getInfluenceFromAmount();
                BigDecimal influenceTaxAmount = arItem.getInfluenceFromTaxAmount();
                arItem.setInfluenceFromAmount(arItem.getInfluenceAmount());
                arItem.setInfluenceFromTax(arItem.getInfluencetax());
                arItem.setInfluenceFromTaxAmount(arItem.getInfluenceAmountIncludeTax());
                arItem.setInfluencetax(influenceTax);
                arItem.setInfluenceAmount(influenceAmount);
                arItem.setInfluenceAmountIncludeTax(influenceTaxAmount);
            }
        }
    }

    private DynamicObject useInvoiceWithPk(String invoiceNo, String invoiceCode) {
        QFilter allFilter = new QFilter("invoicecode", "=", (Object)invoiceCode).and(new QFilter("invoiceno", "=", (Object)invoiceNo));
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])allFilter.toArray());
        if (array.length == 0) {
            throw new MsgException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u5230\u8be5\u53d1\u7968\uff0c\u56de\u8c03\u5931\u8d25", (String)"FiBotpCallBackServiceImpl_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return array[0];
    }

    private void noRelationCallBack(DynamicObject invoice, FiBotpCallBackVo callBackVo, CallBackProcessDto processDto) {
        String invoiceCode = invoice.getString("invoicecode");
        String invoiceNo = invoice.getString("invoiceno");
        String issueType = invoice.getString("issuetype");
        String invoiceStatus = invoice.getString("invoicestatus");
        String oriInvoiceCode = invoice.getString("originalinvoicecode");
        String oriInvoiceNo = invoice.getString("originalinvoiceno");
        QFilter allFilter = new QFilter("invoicecode", "=", (Object)oriInvoiceCode).and(new QFilter("invoiceno", "=", (Object)oriInvoiceNo));
        DynamicObject[] oriBlueInvoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_vatinvoice", true), (QFilter[])allFilter.toArray());
        if (oriBlueInvoice.length == 0) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s,\u5bf9\u5e94\u7684\u84dd\u7968\u6ca1\u6709\u627e\u5230", (String)"FiBotpCallBackServiceImpl_15", (String)"imc-bdm-common", (Object[])new Object[0]), invoiceCode, invoiceNo));
        }
        if (oriBlueInvoice[0].getBigDecimal("totalamount").negate().compareTo(invoice.getBigDecimal("totalamount")) == 0) {
            List<ArBillRelationExtensionDTO> oriBlueRelation = this.queryInvoiceItemRelation(oriBlueInvoice[0], processDto);
            processDto.setInvoiceBillRelation(oriBlueRelation);
            this.pushedBillCallBack(oriBlueInvoice[0], callBackVo, oriBlueRelation, processDto);
            callBackVo.setOriInvoiceCode(oriInvoiceCode);
            callBackVo.setOriInvoiceNo(oriInvoiceNo);
            if ("6".equals(invoiceStatus)) {
                callBackVo.setOriInvoiceStatus("0");
                callBackVo.setInvoiceStatus("6");
            }
            if (InvoiceStatus.isNormalInvIncludePartRed(invoiceStatus)) {
                callBackVo.setOriInvoiceStatus("3");
                callBackVo.setInvoiceStatus("0");
                this.negateAllNum(callBackVo);
            }
            return;
        }
        if (QUERY_RELATION_WAY_BILL_INV_RELATION.equals(issueType) && "0".equals(invoiceStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u5355\u90e8\u5206\u7ea2\u51b2\u56de\u8c03\u6682\u4e0d\u652f\u6301", (String)"FiBotpCallBackServiceImpl_11", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (QUERY_RELATION_WAY_BILL_INV_RELATION.equals(issueType) && "6".equals(invoiceStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u6536\u5355\u90e8\u5206\u7ea2\u51b2\u7684\u53d1\u7968\u8fdb\u884c\u4f5c\u5e9f\u56de\u8c03\u6682\u4e0d\u652f\u6301", (String)"FiBotpCallBackServiceImpl_12", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5173\u7cfb", (String)"FiBotpCallBackServiceImpl_13", (String)"imc-bdm-common", (Object[])new Object[0]));
    }

    public void negateAllNum(FiBotpCallBackVo callBackVo) {
        List<FiBotpCallBackArBillVo> ars = callBackVo.getArs();
        for (FiBotpCallBackArBillVo ar : ars) {
            List<FiBotpCallBackArBillItemVo> items = ar.getArItems();
            for (FiBotpCallBackArBillItemVo item : items) {
                item.setInfluenceAmountIncludeTax(item.getInfluenceAmountIncludeTax().negate());
                item.setInfluenceAmount(item.getInfluenceAmount().negate());
                item.setInfluencetax(item.getInfluencetax().negate());
                item.setInfluenceNum(item.getInfluenceNum().negate());
                item.setInfluenceFromTax(item.getInfluenceFromTax().negate());
                item.setInfluenceFromAmount(item.getInfluenceFromAmount().negate());
                item.setInfluenceFromTaxAmount(item.getInfluenceFromTaxAmount().negate());
            }
        }
    }

    private void pushedBillCallBack(DynamicObject invoice, FiBotpCallBackVo callBackVo, List<ArBillRelationExtensionDTO> billRelationDTOS, CallBackProcessDto processDto) {
        ArrayList<Long> itemPks = new ArrayList<Long>();
        ArrayList<Long> billPks = new ArrayList<Long>();
        Map<Object, DynamicObject> billPkMap = processDto.getBillPkMap();
        HashMap<String, ArBillRelationExtensionDTO> relationMap = new HashMap<String, ArBillRelationExtensionDTO>();
        for (ArBillRelationExtensionDTO billRelation : billRelationDTOS) {
            itemPks.add(billRelation.getsDetailId());
            billPks.add(billRelation.getsBillId());
            relationMap.put(billRelation.getsBillId() + "" + billRelation.getsDetailId(), billRelation);
        }
        LOGGER.info(String.format("billPks:%s,billItemPks:%s", JSONObject.toJSONString(billPks), itemPks));
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"sim_original_bill", (String)this.tgtEntryNumber, (Long[])billPks.toArray(new Long[0]), (Long[])itemPks.toArray(new Long[0]), (OperateOption)OperateOption.create());
        LOGGER.info("queryRelationsSize:" + bfRowLinkUpNodes.size());
        HashMap<Long, FiBotpCallBackArBillVo> arBillMap = new HashMap<Long, FiBotpCallBackArBillVo>();
        for (BFRowLinkUpNode node : bfRowLinkUpNodes) {
            Map sNodes = node.getSNodes();
            for (Map.Entry<BFRowId, BFRowLinkUpNode> entry : sNodes.entrySet()) {
                this.createNewArItemVo(invoice, arBillMap, entry, node, relationMap, billPkMap, processDto);
            }
        }
        ArrayList<FiBotpCallBackArBillVo> arBillVos = new ArrayList<FiBotpCallBackArBillVo>(arBillMap.values());
        callBackVo.setArs(arBillVos);
    }

    private List<ArBillRelationExtensionDTO> useOriginalIssuedRelation(DynamicObject invoice, CallBackProcessDto process) {
        DynamicObject[] array;
        String invoiceStatus = invoice.getString("invoicestatus");
        boolean needNegate = "6".equals(invoiceStatus);
        String mergeKey = BotpHelper.getMergeKey(invoice, needNegate);
        if (CallBackLogTypeEnum.fillin.getValue().equals(process.getCallBackType())) {
            mergeKey = BotpHelper.getFillInMergeKey(invoice.getString("invoicecode"), invoice.getString("invoiceno"), process.getCallBackNo());
        }
        if ((array = BusinessDataServiceHelper.load((String)"invsm_botp_callback_log", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_botp_callback_log"), (QFilter[])new QFilter("invoiceno", "=", (Object)mergeKey).toArray())).length == 0) {
            String value = ImcConfigUtil.getValue(CacheKeyEnum.SIM_CALL_BACK_AR_BILL_FROM_BILL_INV_RELATION);
            if (QUERY_RELATION_WAY_SMART.equals(value)) {
                return new ArrayList<ArBillRelationExtensionDTO>();
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u7533\u8bf7\u5355\u8bb0\u5f55\u7684\u5df2\u5f00\u5173\u7cfb", (String)"FiBotpCallBackServiceImpl_16", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String param = array[0].getString("param_tag");
        return JSONObject.parseArray((String)param, ArBillRelationExtensionDTO.class);
    }

    private FiBotpCallBackVo generateCallBackVo(DynamicObject invoice) {
        FiBotpCallBackVo callBackVo = new FiBotpCallBackVo();
        callBackVo.setInvoiceCode(invoice.getString("invoicecode"));
        callBackVo.setInvoiceNo(invoice.getString("invoiceno"));
        callBackVo.setInvoiceStatus(invoice.getString("invoicestatus"));
        callBackVo.setMergeLable(invoice.getString("mergelable"));
        callBackVo.setIssueDate(invoice.getDate("issuetime"));
        return callBackVo;
    }

    private void createNewArItemVo(DynamicObject invoice, HashMap<Long, FiBotpCallBackArBillVo> arBillMap, Map.Entry<BFRowId, BFRowLinkUpNode> entry, BFRowLinkUpNode node, HashMap<String, ArBillRelationExtensionDTO> relationMap, Map<Object, DynamicObject> originalBillsMap, CallBackProcessDto processDto) {
        List<FiBotpCallBackArBillItemVo> arBillItems;
        DynamicObject[] array;
        BFRowId rowId = node.getRowId();
        Long tgtBillId = rowId.getBillId();
        Long tgtEntryId = rowId.getEntryId();
        if (!originalBillsMap.containsKey(tgtBillId) && (array = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"closestatus", (QFilter[])new QFilter("id", "=", (Object)tgtBillId).toArray())).length > 0) {
            originalBillsMap.put(tgtBillId, array[0]);
        }
        ArBillRelationExtensionDTO billRelationDTO = relationMap.get(tgtBillId + "" + tgtEntryId);
        BFRowId key = entry.getKey();
        Long arBillPk = key.getBillId();
        Long entryId1 = key.getEntryId();
        if (arBillMap.containsKey(arBillPk)) {
            FiBotpCallBackArBillVo fiBotpCallBackArBillVo = arBillMap.get(arBillPk);
            arBillItems = fiBotpCallBackArBillVo.getArItems();
        } else {
            FiBotpCallBackArBillVo fiBotpCallBackArBillVo = new FiBotpCallBackArBillVo();
            arBillMap.put(arBillPk, fiBotpCallBackArBillVo);
            fiBotpCallBackArBillVo.setArBillPk(arBillPk);
            arBillItems = new ArrayList<FiBotpCallBackArBillItemVo>();
            fiBotpCallBackArBillVo.setArItems(arBillItems);
        }
        FiBotpCallBackArBillItemVo arItem = new FiBotpCallBackArBillItemVo();
        arBillItems.add(arItem);
        this.fillInArItemVo(invoice, originalBillsMap, tgtBillId, billRelationDTO, entryId1, arItem, processDto);
    }

    private void fillInArItemVo(DynamicObject invoice, Map<Object, DynamicObject> originalBillsMap, Long tgtBillId, ArBillRelationExtensionDTO billRelationDTO, Long entryId1, FiBotpCallBackArBillItemVo arItem, CallBackProcessDto processDto) {
        arItem.setEntryPk(entryId1);
        String invoiceStatus = invoice.getString("invoicestatus");
        boolean needNegate = "6".equals(invoiceStatus);
        if (processDto.getFromBillIssueRelation().booleanValue()) {
            needNegate = false;
        }
        arItem.setInfluenceNum(needNegate ? billRelationDTO.getNum().negate() : billRelationDTO.getNum());
        DynamicObject originalBill = originalBillsMap.get(tgtBillId);
        if (originalBill != null) {
            arItem.setClosed(QUERY_RELATION_WAY_BILL_INV_RELATION.equals(originalBill.get("closestatus")));
        }
        arItem.setInfluenceAmount(needNegate ? billRelationDTO.getAmount().negate() : billRelationDTO.getAmount());
        arItem.setInfluencetax(needNegate ? billRelationDTO.getTax().negate() : billRelationDTO.getTax());
        BigDecimal amountIncludeTax = billRelationDTO.getAmount().add(billRelationDTO.getTax());
        BigDecimal fromTaxAmount = billRelationDTO.getFromTaxAmount();
        BigDecimal fromTax = billRelationDTO.getFromTax();
        BigDecimal fromAmount = billRelationDTO.getFromAmount();
        arItem.setInfluenceAmountIncludeTax(needNegate ? amountIncludeTax.negate() : amountIncludeTax);
        arItem.setInfluenceFromTax(needNegate ? fromTax.negate() : fromTax);
        arItem.setInfluenceFromAmount(needNegate ? fromAmount.negate() : fromAmount);
        arItem.setInfluenceFromTaxAmount(needNegate ? fromTaxAmount.negate() : fromTaxAmount);
    }

    public List<ArBillRelationExtensionDTO> queryInvoiceItemRelation(DynamicObject invoice, CallBackProcessDto process) {
        List<ArBillRelationExtensionDTO> billRelations;
        if ((!this.isQueryFromBillInvRelation(invoice) || CallBackLogTypeEnum.fillin.getValue().equals(process.getCallBackType())) && (billRelations = this.useOriginalIssuedRelation(invoice, process)).size() > 0) {
            LOGGER.info("arRelationFrom:OriginalBillIssuedInfo");
            Set billPks = billRelations.stream().map(BillRelationDTO::getsBillId).collect(Collectors.toSet());
            QFilter pkFilter = new QFilter("id", "in", billPks);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill", true), (QFilter[])pkFilter.toArray());
            HashMap<Object, DynamicObject> billPkMap = new HashMap<Object, DynamicObject>();
            for (DynamicObject bill : bills) {
                billPkMap.put(bill.getPkValue(), bill);
            }
            process.setBillPkMap(billPkMap);
            process.setFromBillIssueRelation(true);
            process.setFrom(billRelations.get(0).getFrom());
            if (StringUtils.isNotBlank((CharSequence)billRelations.get(0).getMergeLabel())) {
                process.setMergeLable(billRelations.get(0).getMergeLabel());
            }
            return billRelations;
        }
        LOGGER.info("arRelationFrom:BillInvRelation");
        ArrayList<ArBillRelationExtensionDTO> relationResult = new ArrayList<ArBillRelationExtensionDTO>();
        DynamicObject[] array = this.queryBillInvRelation(invoice);
        if (null == array || array.length == 0) {
            return relationResult;
        }
        HashMap<Long, ArBillRelationExtensionDTO> oriItemPkRelation = new HashMap<Long, ArBillRelationExtensionDTO>();
        HashSet<Object> sbillPks = new HashSet<Object>();
        HashMap<String, DynamicObject> relationMap = new HashMap<String, DynamicObject>();
        this.dealRelationArray(array, sbillPks, relationMap);
        array = relationMap.values().toArray(new DynamicObject[0]);
        boolean isPushRelate = "-1".equalsIgnoreCase(array[0].getString("pushtype"));
        QFilter filter = new QFilter("id", "in", (Object)sbillPks.toArray(new Object[0]));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_original_bill", true), (QFilter[])filter.toArray());
        if (isPushRelate) {
            relationResult = this.createRelationFromBill(array, bills, process);
            return relationResult;
        }
        boolean isFrom = false;
        if (bills.length > 0) {
            DynamicObject[] currency = bills[0].getDynamicObject("fromcurr");
            if (CurrencyHelper.isFrom(currency)) {
                isFrom = true;
            }
            int amtPrecision = currency.getInt("amtprecision");
            process.setAmtValue(amtPrecision);
        }
        process.setFrom(isFrom);
        this.fillInfoFromRelationDto(bills, process);
        for (DynamicObject object : array) {
            this.addDto(relationResult, oriItemPkRelation, object, process);
        }
        LOGGER.info("\u53d1\u7968\u7ba1\u7406\u7684\u5f00\u7968\u7533\u8bf7\u5355\u660e\u7ec6\uff1a" + JSONObject.toJSONString(oriItemPkRelation.keySet()));
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        ArrayList<Long> deductionPks = this.queryInvoiceDeductionPks(items);
        if (deductionPks.size() == 0) {
            return relationResult;
        }
        ArrayList<ArBillRelationExtensionDTO> changedRelation = new ArrayList<ArBillRelationExtensionDTO>();
        this.addBlueRelation(relationResult, changedRelation, deductionPks, process);
        HashSet<Object> billZkSet = process.getBillZkSet();
        for (ArBillRelationExtensionDTO relationDto : relationResult) {
            if (!billZkSet.contains(relationDto.getsDetailId())) continue;
            Long originalPk = relationDto.getsBillId();
            Long originalDetailPk = relationDto.getsDetailId();
            HashMap<Object, Object> zkRelationMap = process.getBillZkRelation();
            Long deducatedPk = (Long)zkRelationMap.get(originalDetailPk);
            ArBillRelationExtensionDTO deducatedRelationDto = new ArBillRelationExtensionDTO();
            deducatedRelationDto.setsBillId(originalPk);
            deducatedRelationDto.setsDetailId(deducatedPk);
            deducatedRelationDto.setTax(relationDto.getTax());
            deducatedRelationDto.setAmount(relationDto.getAmount());
            deducatedRelationDto.setNum(relationDto.getNum());
            deducatedRelationDto.setFromAmount(relationDto.getFromAmount());
            deducatedRelationDto.setFromTax(relationDto.getFromTax());
            deducatedRelationDto.setFromTaxAmount(relationDto.getFromTaxAmount());
            ArBillRelationExtensionDTO deducationRelationDto = oriItemPkRelation.get(originalDetailPk);
            deducatedRelationDto.setDeducatedRow(Boolean.TRUE);
            deducatedRelationDto.setDeducatedAmount(deducationRelationDto.getAmount());
            deducatedRelationDto.setDeducatedTax(deducationRelationDto.getTax());
            deducatedRelationDto.setDeducatedFromAmt(deducationRelationDto.getFromAmount());
            deducatedRelationDto.setDeducatedFromTax(deducationRelationDto.getFromTax());
            deducatedRelationDto.setDeducatedFromTaxAmt(deducationRelationDto.getFromTaxAmount());
            changedRelation.add(deducatedRelationDto);
        }
        HashMap<Long, ArBillRelationExtensionDTO> sDetailIdRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>();
        for (ArBillRelationExtensionDTO dto : changedRelation) {
            if (sDetailIdRelationMap.containsKey(dto.getsDetailId())) {
                ArBillRelationExtensionDTO oriDto = (ArBillRelationExtensionDTO)sDetailIdRelationMap.get(dto.getsDetailId());
                oriDto.setNum(oriDto.getNum().add(dto.getNum()));
                oriDto.setAmount(oriDto.getAmount().add(dto.getAmount()));
                oriDto.setTax(oriDto.getTax().add(dto.getTax()));
                oriDto.setDeducatedFromTax(oriDto.getDeducatedFromTax().add(dto.getDeducatedFromTax()));
                oriDto.setDeducatedFromTaxAmt(oriDto.getDeducatedFromTaxAmt().add(dto.getDeducatedFromTaxAmt()));
                oriDto.setDeducatedFromAmt(oriDto.getDeducatedFromAmt().add(dto.getDeducatedFromAmt()));
                oriDto.setFromTaxAmount(oriDto.getFromTaxAmount().add(dto.getFromTaxAmount()));
                oriDto.setFromTax(oriDto.getFromTax().add(dto.getFromTax()));
                oriDto.setFromAmount(oriDto.getFromAmount().add(dto.getFromAmount()));
                continue;
            }
            sDetailIdRelationMap.put(dto.getsDetailId(), dto);
        }
        return new ArrayList<ArBillRelationExtensionDTO>(sDetailIdRelationMap.values());
    }

    private boolean isQueryFromBillInvRelation(DynamicObject invoice) {
        String[] systems;
        String cancelNotWriteBackSystemSources;
        String systemSource = invoice.getString("systemsource");
        if (QUERY_RELATION_WAY_BILL_INV_RELATION.equals(ImcConfigUtil.getValue(CacheKeyEnum.SIM_CALL_BACK_AR_BILL_FROM_BILL_INV_RELATION))) {
            return true;
        }
        String invoiceStatus = invoice.getString("invoicestatus");
        boolean isCancel = "6".equals(invoiceStatus);
        if (isCancel && StringUtils.isNotBlank((CharSequence)(cancelNotWriteBackSystemSources = ImcConfigUtil.getValue(CacheKeyEnum.SIM_WRITEBACK_CONFIG_CANCEL)))) {
            String[] systems2;
            for (String system : systems2 = cancelNotWriteBackSystemSources.split(",")) {
                if (!Objects.equals(system, systemSource)) continue;
                return true;
            }
        }
        String issueType = invoice.getString("issuetype");
        if (IssueType.BLUE_INVOICE.getTypeCode().equals(issueType)) {
            return false;
        }
        String redNotWriteBackSystemSources = ImcConfigUtil.getValue(CacheKeyEnum.SIM_WRITEBACK_CONFIG_REDPUSH);
        for (String system : systems = redNotWriteBackSystemSources.split(",")) {
            if (!Objects.equals(system, systemSource)) continue;
            DynamicObject[] array = this.queryBillInvRelation(invoice);
            if (null == array) {
                return true;
            }
            return array.length == 0;
        }
        return false;
    }

    private DynamicObject[] queryBillInvRelation(DynamicObject invoice) {
        DynamicObject redInfoByInvoice;
        DynamicObject redConfirm;
        if (this.isRedConfirmInvoice(invoice) && null != (redConfirm = RelationHelper.getRedConfirmByInvoice(invoice))) {
            return this.getRelationsByTBillId(redConfirm.getPkValue());
        }
        if (InvoiceUtils.isRedInfo(invoice) && null != (redInfoByInvoice = RelationHelper.getRedInfoByInvoice(invoice))) {
            return this.getRelationsByTBillId(redInfoByInvoice.getPkValue());
        }
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)SIM_BILL_RELATION_FIELDS, (QFilter[])new QFilter("tbillid", "=", invoice.getPkValue()).toArray());
    }

    private boolean isRedConfirmInvoice(DynamicObject invoice) {
        String invoiceType = invoice.getString("invoicetype");
        String isElePaper = invoice.getString("iselepaper");
        BigDecimal totalAmount = invoice.getBigDecimal("totalamount");
        return (InvoiceUtils.isAllEInvoice(invoiceType) || AllEleAuthHelper.isElePaper(isElePaper)) && BigDecimal.ZERO.compareTo(totalAmount) > 0;
    }

    private ArrayList<ArBillRelationExtensionDTO> createRelationFromBill(DynamicObject[] array, DynamicObject[] bills, CallBackProcessDto process) {
        ArrayList<ArBillRelationExtensionDTO> relations = new ArrayList<ArBillRelationExtensionDTO>();
        DynamicObject relationObj = array[0];
        DynamicObject fromCurr = bills[0].getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom(fromCurr);
        process.setFrom(isFrom);
        int amtPrecision = fromCurr.getInt("amtprecision");
        process.setAmtValue(amtPrecision);
        HashMap<Object, DynamicObject> billPkMap = new HashMap<Object, DynamicObject>();
        process.setBillPkMap(billPkMap);
        for (DynamicObject bill : bills) {
            billPkMap.put(bill.getPkValue(), bill);
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject currentRow = (DynamicObject)items.get(i);
                if (QUERY_RELATION_WAY_BILL_INV_RELATION.equals(currentRow.getString("rowtype"))) continue;
                ArBillRelationExtensionDTO dto = new ArBillRelationExtensionDTO();
                dto.settBillId(relationObj.getLong("id"));
                dto.setsBillId(bill.getLong("id"));
                dto.setsDetailId(currentRow.getLong("id"));
                dto.setNum(currentRow.getBigDecimal("num"));
                BotpHelper.setBeforeModelNumRate(currentRow.getBigDecimal("num"), dto, currentRow);
                relations.add(dto);
                if (i + 1 < size) {
                    DynamicObject nextRow = (DynamicObject)items.get(i + 1);
                    if (QUERY_RELATION_WAY_BILL_INV_RELATION.equals(nextRow.getString("rowtype"))) {
                        this.dealDeducateRowDto(isFrom, currentRow, dto, nextRow);
                        continue;
                    }
                    this.dealNormalRowDto(isFrom, currentRow, dto);
                    continue;
                }
                this.dealNormalRowDto(isFrom, currentRow, dto);
            }
        }
        return relations;
    }

    private void dealDeducateRowDto(boolean isFrom, DynamicObject currentRow, ArBillRelationExtensionDTO dto, DynamicObject nextRow) {
        if (isFrom) {
            dto.setFromAmount(currentRow.getBigDecimal("fromamount").add(nextRow.getBigDecimal("fromamount")));
            dto.setFromTax(currentRow.getBigDecimal("fromtax").add(nextRow.getBigDecimal("fromtax")));
            dto.setFromTaxAmount(currentRow.getBigDecimal("fromtaxamount").add(nextRow.getBigDecimal("fromtaxamount")));
            dto.setAmount(currentRow.getBigDecimal("amount").add(nextRow.getBigDecimal("amount")));
            dto.setTax(currentRow.getBigDecimal("tax").add(nextRow.getBigDecimal("tax")));
        } else {
            dto.setAmount(currentRow.getBigDecimal("amount").add(nextRow.getBigDecimal("amount")));
            dto.setTax(currentRow.getBigDecimal("tax").add(nextRow.getBigDecimal("tax")));
        }
    }

    private void dealNormalRowDto(boolean isFrom, DynamicObject currentRow, ArBillRelationExtensionDTO dto) {
        if (isFrom) {
            dto.setFromAmount(currentRow.getBigDecimal("fromamount"));
            dto.setFromTax(currentRow.getBigDecimal("fromtax"));
            dto.setFromTaxAmount(currentRow.getBigDecimal("fromtaxamount"));
            dto.setAmount(currentRow.getBigDecimal("amount"));
            dto.setTax(currentRow.getBigDecimal("tax"));
        } else {
            dto.setAmount(currentRow.getBigDecimal("amount"));
            dto.setTax(currentRow.getBigDecimal("tax"));
        }
    }

    private void dealRelationArray(DynamicObject[] array, HashSet<Object> sbillPks, HashMap<String, DynamicObject> relationMap) {
        for (DynamicObject dynamicObject : array) {
            sbillPks.add(dynamicObject.get("sbillid"));
            Object sDetailId = dynamicObject.get("sdetailid");
            Object tDetailId = dynamicObject.get("tdetailid");
            String relationKey = "" + sDetailId + tDetailId;
            if (relationMap.containsKey(relationKey)) {
                DynamicObject oriRelation = relationMap.get(relationKey);
                oriRelation.set("num", (Object)dynamicObject.getBigDecimal("num").add(oriRelation.getBigDecimal("num")));
                oriRelation.set("tax", (Object)dynamicObject.getBigDecimal("tax").add(oriRelation.getBigDecimal("tax")));
                oriRelation.set("amount", (Object)dynamicObject.getBigDecimal("amount").add(oriRelation.getBigDecimal("amount")));
                continue;
            }
            relationMap.put(relationKey, dynamicObject);
        }
    }

    private void addBlueRelation(ArrayList<ArBillRelationExtensionDTO> relationResult, ArrayList<ArBillRelationExtensionDTO> changedRelation, ArrayList<Long> deductionPks, CallBackProcessDto process) {
        HashSet<Object> billZkSet = process.getBillZkSet();
        for (ArBillRelationExtensionDTO dto : relationResult) {
            Long sDetailId = dto.getsDetailId();
            if (billZkSet.contains(sDetailId)) continue;
            changedRelation.add(dto);
        }
    }

    private ArrayList<Long> queryInvoiceDeductionPks(DynamicObjectCollection items) {
        ArrayList<Long> deductionPks = new ArrayList<Long>();
        for (DynamicObject item : items) {
            if (!QUERY_RELATION_WAY_BILL_INV_RELATION.equals(item.getString("rowtype"))) continue;
            deductionPks.add(item.getLong("id"));
        }
        return deductionPks;
    }

    public void fillInfoFromRelationDto(DynamicObject[] bills, CallBackProcessDto process) {
        HashMap<Object, DynamicObject> billItemMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, DynamicObject> billPkMap = new HashMap<Object, DynamicObject>();
        HashSet<Object> bzkSet = new HashSet<Object>();
        HashSet<Object> zkSet = new HashSet<Object>();
        HashMap<Object, Object> zkRelation = new HashMap<Object, Object>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item = (DynamicObject)items.get(i);
                billItemMap.put(item.getPkValue(), item);
                if (i == 0 || !QUERY_RELATION_WAY_BILL_INV_RELATION.equals(item.getString("rowtype"))) continue;
                Object pkValue = ((DynamicObject)items.get(i - 1)).getPkValue();
                Object currentPk = item.getPkValue();
                zkSet.add(currentPk);
                bzkSet.add(((DynamicObject)items.get(i - 1)).getPkValue());
                zkRelation.put(currentPk, pkValue);
                zkRelation.put(pkValue, currentPk);
            }
            billPkMap.put(bill.getPkValue(), bill);
        }
        process.setBillPkMap(billPkMap);
        process.setBillBzkSet(bzkSet);
        process.setBillItemPkMap(billItemMap);
        process.setBillZkSet(zkSet);
        process.setBillZkRelation(zkRelation);
    }

    public void addDto(ArrayList<ArBillRelationExtensionDTO> relationResult, HashMap<Long, ArBillRelationExtensionDTO> oriItemPkRelation, DynamicObject relation, CallBackProcessDto process) {
        ArBillRelationExtensionDTO dto = new ArBillRelationExtensionDTO();
        BigDecimal amount = relation.getBigDecimal("amount").setScale(2, RoundingMode.HALF_UP);
        dto.setAmount(amount);
        BigDecimal tax = relation.getBigDecimal("tax").setScale(2, RoundingMode.HALF_UP);
        dto.setTax(tax);
        dto.setNum(relation.getBigDecimal("num").setScale(8, RoundingMode.HALF_UP));
        dto.setsBillId(relation.getLong("sbillid"));
        dto.setsDetailId(relation.getLong("sdetailid"));
        dto.settBillId(relation.getLong("tbillid"));
        dto.settDetailId(relation.getLong("tdetailid"));
        dto.setDeducatedRow(Boolean.FALSE);
        oriItemPkRelation.put(relation.getLong("sdetailid"), dto);
        long sBillItemPk = relation.getLong("sdetailid");
        Map<Object, DynamicObject> itemMap = process.getBillItemPkMap();
        DynamicObject item = itemMap.get(sBillItemPk);
        int amtValue = process.getAmtValue();
        if (process.getFrom().booleanValue()) {
            BigDecimal fromTaxAmount = item.getBigDecimal("fromtaxamount");
            BigDecimal itemtaxAmount = item.getBigDecimal("taxamount");
            BigDecimal influenceTaxAmount = amount.add(tax);
            BigDecimal influenceFromTaxAmt = influenceTaxAmount.divide(itemtaxAmount, 20, RoundingMode.HALF_UP).multiply(fromTaxAmount).setScale(amtValue, RoundingMode.HALF_UP);
            BigDecimal influenceFromAmt = amount.divide(influenceTaxAmount, 20, RoundingMode.HALF_UP).multiply(influenceFromTaxAmt).setScale(amtValue, RoundingMode.HALF_UP);
            BigDecimal influenceFromTax = influenceFromTaxAmt.subtract(influenceFromAmt);
            dto.setFromTaxAmount(influenceFromTaxAmt);
            dto.setFromTax(influenceFromTax);
            dto.setFromAmount(influenceFromAmt);
        }
        BotpHelper.setBeforeModelNumRate(relation.getBigDecimal("num"), dto, item);
        LOGGER.info("beforeCalFrom:" + JSONObject.toJSONString((Object)dto) + "afterCalFrom:" + JSONObject.toJSONString((Object)dto));
        relationResult.add(dto);
    }

    public boolean isNotNegativeSpecialInvoice(DynamicObject invoice) {
        return !InvoiceUtils.isSpecialInvoice(invoice.getString("invoicetype")) || invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) >= 0;
    }

    public DynamicObject[] getRelationsByTBillId(Object invoiceId) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceId).toArray());
    }

    public DynamicObject[] getRelationsByTBillNo(Object invoiceBillNo) {
        return BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_bill_inv_relation"), (QFilter[])new QFilter("tbillno", "=", invoiceBillNo).toArray());
    }
}

