/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.message.send;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.model.SystemInfoVo;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.commons.lang.StringUtils;

public class SendMsg2Imac {
    private static Log LOGGER = LogFactory.getLog(SendMsg2Imac.class);
    private static final String TOKEN_NAME = "IMAC_APP_TOKEN";
    public static final String IMAC_CONFIG_KEY = "bdm_ismc_config_move";
    private static final String INCLUDE_KEY = "_cloud";
    public static final String URL = "bdm_ismc_config_move_cloud_url";
    private static final String APPID = "bdm_ismc_config_move_cloud_appid";
    private static final String ACCOUNTID = "bdm_ismc_config_move_cloud_accountid";
    private static final String APP_SECURET = "bdm_ismc_config_move_cloud_appsecuret";
    private static final String USER = "bdm_ismc_config_move_cloud_user";
    public static final String IMAC_ADDRESS = "/kapi/app/imasm/imacWebService";
    public static final String TOKEN_STR = "?access_token=";

    public static MsgResponse registerImc(Map<String, String> paramMap) {
        SystemInfoVo infoVo = SendMsg2Imac.getSystemInfoVo(paramMap);
        MsgRequest request = new MsgRequest();
        request.setIdentifytype("imacImasmFromImc");
        request.setMsgType("register");
        request.setReqData(infoVo);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5411\u79fb\u52a8\u4e91\u6ce8\u518c\u5f53\u524d\u53d1\u7968\u4e91\uff1a" + JSON.toJSONString((Object)request));
        }
        return SendMsg2Imac.send(request, "/kapi/app/imasm/imacWebService?access_token=");
    }

    private static SystemInfoVo getSystemInfoVo(Map<String, String> paramMap) {
        SystemInfoVo systemInfoVo = new SystemInfoVo();
        systemInfoVo.setAppId(paramMap.get("bdm_ismc_config_move_cloud_open3app"));
        systemInfoVo.setAppSecuret(paramMap.get("bdm_ismc_config_move_cloud_open3app_pwd"));
        systemInfoVo.setUser(paramMap.get("bdm_ismc_config_move_cloud_open3app_user"));
        systemInfoVo.setTenantName(paramMap.get("bdm_ismc_config_move_cloud_tenantname"));
        return systemInfoVo;
    }

    private static String getToken() {
        String token = CacheHelper.get(TOKEN_NAME);
        if (StringUtils.isBlank((String)token) || "null".equals(token)) {
            token = SendMsg2Imac.loginImac();
        }
        return token;
    }

    private static String loginImac() {
        Map<String, String> paramMap = ImcConfigUtil.getValue(IMAC_CONFIG_KEY);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u83b7\u53d6\u8fd0\u8425\u5e73\u53f0\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString(paramMap));
        }
        if (paramMap.isEmpty()) {
            throw new MsgException(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u79fb\u52a8\u4e91\uff0c\u8bf7\u5148\u521d\u59cb\u5316\uff0c\u53d1\u7968\u4e91\u300b\u7cfb\u7edf\u7ba1\u7406\u300b\u4e91\u5e94\u7528\u53c2\u6570\u914d\u7f6e", (String)"SendMsg2Imac_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String token = IsmcToken.login(paramMap.get(URL), paramMap.get("bdm_ismc_config_move_cloud_url_proxy"), paramMap.get(APPID), paramMap.get(APP_SECURET), paramMap.get(ACCOUNTID), "register");
        CacheHelper.put(TOKEN_NAME, token, 3600);
        return token;
    }

    private static String getRequestUrl(String url) {
        return ImcConfigUtil.getValue(IMAC_CONFIG_KEY).get(URL) + url;
    }

    public static MsgResponse send(MsgRequest request, String address) {
        request.setTenantId(RequestContext.get().getTenantId());
        request.setImcAccountId(RequestContext.get().getAccountId());
        request.setMsgId(RequestContext.get().getTraceId());
        MsgResponse response = new MsgResponse();
        try {
            if (address.endsWith(TOKEN_STR)) {
                address = address + SendMsg2Imac.getToken();
            }
            Map<String, String> paramMap = ImcConfigUtil.getValue(IMAC_CONFIG_KEY);
            String url = SendMsg2Imac.getRequestUrl(address);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u8bf7\u6c42\u79fb\u52a8\u4e91\uff1a[%s] url:[%s],proxy[%s], request:[%s]", request.getMsgId(), url, paramMap.get("bdm_ismc_config_move_cloud_url_proxy"), SerializationUtils.toJsonString((Object)request.getReqData())));
            }
            String data = HttpUtil.doPostJson(url, paramMap.get("bdm_ismc_config_move_cloud_url_proxy"), null, JSON.toJSONString((Object)request));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u8bf7\u6c42\u79fb\u52a8\u4e91\uff1a%sResponse:%s", request.getMsgType(), data));
            }
            JSONObject json = JSONObject.parseObject((String)data);
            response.setErrorCode(json.getString("errorCode"));
            response.setErrorMsg(json.getString("message"));
            response.setRespData(json.getString("data"));
        }
        catch (MsgException e) {
            LOGGER.error(e.toString(), (Throwable)e);
            response.setErrorCode(e.getErrorCode());
            response.setErrorMsg(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s\u8bf7\u6c42\u79fb\u52a8\u4e91\u53d1\u9001\u5f02\u5e38%s", request.getMsgId(), e.getMessage()), (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u79fb\u52a8\u4e91\u53d1\u9001\u5f02\u5e38:%s", (String)"SendMsg2Imac_3", (String)"imc-bdm-common", (Object[])new Object[0]), e.getMessage()));
        }
        return response;
    }

    public static MsgResponse syncQrKey(Object data) {
        MsgRequest request = new MsgRequest();
        request.setIdentifytype("imacImasmFromImc");
        request.setMsgType("syncQrKey");
        request.setReqData(data);
        LOGGER.info(String.format("\u540c\u6b65qrkey\u5230\u79fb\u52a8\u4e91\uff1a%s", JSON.toJSONString((Object)request)));
        return SendMsg2Imac.send(request, "/kapi/app/imasm/imacWebService?access_token=");
    }
}

