/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.openapi.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.dto.allelespecial.BillTravlerInfoVo;
import kd.imc.bdm.common.dto.allelespecial.BillVehicheVesselShipVo;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceBuildInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceCoBuyerInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceDetailDTO;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceEstateLeaseInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceEstateSaleInfo;
import kd.imc.bdm.common.openapi.alle.AllEInvoiceRequestDTO;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import org.apache.commons.collections.CollectionUtils;

public class AllEApiHelper {
    private static final Log log = LogFactory.getLog(AllEApiHelper.class);

    public AllEInvoiceRequestDTO transferAllEInvoiceVO(DynamicObject invoiceDO) {
        AllEInvoiceRequestDTO invoiceVo = DynamicObjectUtil.dynamicObject2Bean(AllEInvoiceRequestDTO.class, invoiceDO);
        DynamicObjectCollection items = invoiceDO.getDynamicObjectCollection("items");
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            ArrayList<AllEInvoiceDetailDTO> invoiceDetailList = new ArrayList<AllEInvoiceDetailDTO>(items.size());
            for (DynamicObject item : items) {
                AllEInvoiceDetailDTO invoiceDetail = DynamicObjectUtil.dynamicObject2Bean(AllEInvoiceDetailDTO.class, item);
                if (AllEApiHelper.isZero(item.getBigDecimal("discountrate"))) {
                    invoiceDetail.setDiscountRate("");
                }
                invoiceDetailList.add(invoiceDetail);
            }
            invoiceVo.setInvoiceDetail(invoiceDetailList);
        }
        if ("08xdp".equals(invoiceVo.getInvoiceType())) {
            invoiceVo.setInvoiceType("01");
        } else if ("10xdp".equals(invoiceVo.getInvoiceType())) {
            invoiceVo.setInvoiceType("02");
        }
        if ("00".equals(invoiceVo.getSpecialType())) {
            invoiceVo.setSpecialType("");
        }
        if (StringUtils.isEmpty((CharSequence)invoiceDO.getString("invoicestatus"))) {
            if (IssueStatusEnum.submit.getCode().equals(invoiceDO.getString("issuestatus"))) {
                invoiceVo.setInvoiceStatus("2");
            } else if (IssueStatusEnum.failed.getCode().equals(invoiceDO.getString("issuestatus"))) {
                invoiceVo.setInvoiceStatus("4");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)invoiceVo.getInvoiceNum())) {
            invoiceVo.setInvoiceDate(invoiceDO.getDate("issuetime"));
        }
        this.convertSpecialType(invoiceDO, invoiceVo);
        if (invoiceDO.get("operator") != null) {
            DynamicObject agentDO = invoiceDO.getDynamicObject("operator");
            invoiceVo.setAgentUser(agentDO.getString("name"));
            invoiceVo.setAgentCardType(agentDO.getString("certificatetype"));
            invoiceVo.setAgentCardNo(agentDO.getString("certificatenumber"));
            invoiceVo.setAgentCountry(agentDO.getString("county"));
            invoiceVo.setAgentTaxNo(agentDO.getString("taxno"));
        }
        this.setRedConfirmInfo(invoiceDO, invoiceVo);
        return invoiceVo;
    }

    private void setRedConfirmInfo(DynamicObject invoiceDO, AllEInvoiceRequestDTO invoiceVo) {
        String redBillNo = invoiceDO.getString("infocode");
        Object orgIdObj = invoiceDO.get("orgid");
        try {
            if (StringUtils.isNotEmpty((CharSequence)redBillNo)) {
                invoiceVo.setRedInfoBillNo(redBillNo);
                QFilter baseDataFilter = ImcBaseDataHelper.getRedConfirmFilter(orgIdObj);
                baseDataFilter.and("number", "=", (Object)redBillNo);
                DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "govuuid", "uploaddate", "confirmstatus"), (QFilter[])baseDataFilter.toArray());
                if (redConfirmBill != null) {
                    invoiceVo.setGovRedConfirmBillUuid(redConfirmBill.getString("govuuid"));
                    invoiceVo.setRedConfirmBillStatus(redConfirmBill.getString("confirmstatus"));
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u7ea2\u5b57\u786e\u8ba4\u5355\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
        }
    }

    private void convertSpecialType(DynamicObject invoiceDO, AllEInvoiceRequestDTO invoiceVo) {
        if ("E05".equals(invoiceVo.getSpecialType())) {
            DynamicObjectCollection saleCollection = invoiceDO.getDynamicObjectCollection("estatesales");
            if (CollectionUtils.isNotEmpty((Collection)saleCollection)) {
                ArrayList<AllEInvoiceEstateSaleInfo> estateSaleItems = new ArrayList<AllEInvoiceEstateSaleInfo>(saleCollection.size());
                for (Object saleObject : saleCollection) {
                    AllEInvoiceEstateSaleInfo saleInfoVo = DynamicObjectUtil.dynamicObject2Bean(AllEInvoiceEstateSaleInfo.class, (DynamicObject)saleObject);
                    estateSaleItems.add(saleInfoVo);
                }
                invoiceVo.setEstateSaleItems(estateSaleItems);
            }
            invoiceVo.setCoBuyerFlag(invoiceDO.getString("cobuyerflag"));
            DynamicObjectCollection cobuyers = invoiceDO.getDynamicObjectCollection("cobuyers");
            if (CollectionUtils.isNotEmpty((Collection)cobuyers)) {
                ArrayList<AllEInvoiceCoBuyerInfo> cobuyerItems = new ArrayList<AllEInvoiceCoBuyerInfo>(cobuyers.size());
                for (DynamicObject cobuyerObject : cobuyers) {
                    AllEInvoiceCoBuyerInfo cobuyerInfoVo = DynamicObjectUtil.dynamicObject2Bean(AllEInvoiceCoBuyerInfo.class, cobuyerObject);
                    cobuyerItems.add(cobuyerInfoVo);
                }
                invoiceVo.setCoBuyerItems(cobuyerItems);
            }
            invoiceVo.setEstateSaleInfo(null);
        } else if ("E06".equals(invoiceVo.getSpecialType())) {
            AllEInvoiceEstateLeaseInfo estateLeaseInfo = new AllEInvoiceEstateLeaseInfo();
            estateLeaseInfo.setEstateId(invoiceDO.getString("estateid"));
            DynamicObject simpleAddressDO = invoiceDO.getDynamicObject("simpleaddress");
            if (simpleAddressDO != null) {
                estateLeaseInfo.setSimpleAddress(simpleAddressDO.getString("name"));
            }
            estateLeaseInfo.setDetailAddress(invoiceDO.getString("detailaddress"));
            estateLeaseInfo.setCrossCitySign(invoiceDO.getString("crosscitysign"));
            estateLeaseInfo.setAreaUnit(invoiceDO.getString("areaunit"));
            estateLeaseInfo.setStartLeaseDate(DateUtils.format(invoiceDO.getDate("startleasedate"), "yyyyMMdd"));
            estateLeaseInfo.setEndLeaseDate(DateUtils.format(invoiceDO.getDate("endleasedate"), "yyyyMMdd"));
            invoiceVo.setEstateLeaseInfo(estateLeaseInfo);
        } else if ("E03".equals(invoiceVo.getSpecialType())) {
            AllEInvoiceBuildInfo buildInfo = new AllEInvoiceBuildInfo();
            buildInfo.setBuildingName(invoiceDO.getString("buildingname"));
            DynamicObject simpleAddressDO = invoiceDO.getDynamicObject("simpleaddress");
            if (simpleAddressDO != null) {
                buildInfo.setSimpleAddress(simpleAddressDO.getString("name"));
            }
            buildInfo.setDetailAddress(invoiceDO.getString("detailaddress"));
            buildInfo.setCrossCitySign(invoiceDO.getString("crosscitysign"));
            buildInfo.setLandTaxNo(invoiceDO.getString("landtaxno"));
            invoiceVo.setBuildInfo(buildInfo);
        } else if ("E09".equals(invoiceVo.getSpecialType())) {
            DynamicObjectCollection travelerCollection = invoiceDO.getDynamicObjectCollection("travelers");
            if (CollectionUtils.isNotEmpty((Collection)travelerCollection)) {
                ArrayList<BillTravlerInfoVo> billTravelerItemList = new ArrayList<BillTravlerInfoVo>(travelerCollection.size());
                for (DynamicObject travlerObject : travelerCollection) {
                    BillTravlerInfoVo billTravlerInfoVo = DynamicObjectUtil.dynamicObject2Bean(BillTravlerInfoVo.class, travlerObject);
                    AllEApiHelper.formatTravelDateMethod(billTravlerInfoVo);
                    billTravelerItemList.add(billTravlerInfoVo);
                }
                invoiceVo.setTravelerList(billTravelerItemList);
            }
        } else if ("E07".equals(invoiceVo.getSpecialType())) {
            DynamicObjectCollection vehicheVesselCollection = invoiceDO.getDynamicObjectCollection("vehichevesselships");
            if (CollectionUtils.isNotEmpty((Collection)vehicheVesselCollection)) {
                ArrayList<BillVehicheVesselShipVo> vehicheVesselShipVoList = new ArrayList<BillVehicheVesselShipVo>(vehicheVesselCollection.size());
                for (DynamicObject vehichVesselObject : vehicheVesselCollection) {
                    BillVehicheVesselShipVo billVehicheVesselShipVo = DynamicObjectUtil.dynamicObject2Bean(BillVehicheVesselShipVo.class, vehichVesselObject);
                    billVehicheVesselShipVo.setVehicleLateAmount(billVehicheVesselShipVo.getVehicleLateAmount().setScale(2, RoundingMode.HALF_UP));
                    billVehicheVesselShipVo.setVehicleVesselAmount(billVehicheVesselShipVo.getVehicleVesselAmount().setScale(2, RoundingMode.HALF_UP));
                    billVehicheVesselShipVo.setVehicleTotalAmount(billVehicheVesselShipVo.getVehicleTotalAmount().setScale(2, RoundingMode.HALF_UP));
                    vehicheVesselShipVoList.add(billVehicheVesselShipVo);
                }
                invoiceVo.setVehicheVesselShipList(vehicheVesselShipVoList);
            }
        } else if (StringUtils.isBlank((CharSequence)invoiceVo.getSpecialType()) || "00".equals(invoiceVo.getSpecialType())) {
            invoiceVo.setTravelerList(null);
            invoiceVo.setVehicheVesselShipList(null);
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceVo.getSpecialType())) {
            if (!"E09".equals(invoiceVo.getSpecialType())) {
                invoiceVo.setTravelerList(null);
            }
            if (!"E07".equals(invoiceVo.getSpecialType())) {
                invoiceVo.setVehicheVesselShipList(null);
            }
            invoiceVo.setSpecialType(invoiceVo.getSpecialType().replace("E", ""));
        }
    }

    private static void formatTravelDateMethod(BillTravlerInfoVo billTravlerInfoVo) {
        String travelDate = billTravlerInfoVo.getTravelDate();
        Date travel_date = DateUtils.stringToDate(travelDate);
        travelDate = DateUtils.format(travel_date);
        billTravlerInfoVo.setTravelDate(travelDate);
    }

    public static boolean isZero(BigDecimal sourceBigDecimal) {
        if (sourceBigDecimal == null) {
            return true;
        }
        return sourceBigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }
}

