/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;

public class ApiLogService {
    private static Log LOGGER = LogFactory.getLog(ApiLogService.class);
    private DynamicObject apiLog;
    private long startTime;

    public ApiLogService(String request, String requestUrl, String requestStr) {
        try {
            this.startTime = System.currentTimeMillis();
            this.apiLog = BusinessDataServiceHelper.newDynamicObject((String)"bdm_api_log");
            this.apiLog.set("createdate", (Object)new Date());
            this.apiLog.set("response", (Object)RequestContext.get().getTraceId());
            this.apiLog.set("request", (Object)request);
            this.apiLog.set("request_tag", (Object)requestStr);
            this.apiLog.set("requesturl", (Object)requestUrl.replaceAll("access_token=[0-9a-zA-Z]*&", ""));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveLog(String response) {
        try {
            ThreadPoolsHelper.addApiLogThreadPool.execute(() -> {
                this.apiLog.set("taketime", (Object)(System.currentTimeMillis() - this.startTime));
                this.apiLog.set("response_tag", (Object)response);
                ImcSaveServiceHelper.save(this.apiLog);
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

