/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.AwsFpyConstant;
import kd.imc.bdm.common.dto.aws.AwsConfigDTO;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.MD5;
import org.apache.commons.lang3.StringUtils;

public class AwsFpyService {
    private static Log LOGGER = LogFactory.getLog(AwsFpyService.class);
    private String baseUrl;
    private String proxy;

    private AwsFpyService(String baseUrl, String proxy) {
        this.baseUrl = baseUrl;
        this.proxy = proxy;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getProxy() {
        return this.proxy;
    }

    public static AwsFpyService newInstance() {
        Map<String, String> dimImcConfigFpyMap = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String url = ImcConfigUtil.getValue(dimImcConfigFpyMap, "url", "dim_imc_config_fpy_url");
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5230\u53d1\u7968\u4e91\u300b\u7cfb\u7edf\u7ba1\u7406\u300b\u53d1\u7968\u4e91\u6388\u6743\u914d\u7f6e,\u914d\u7f6e\u597d\u6388\u6743\u4fe1\u606f", (String)"AwsFpyService_0", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return new AwsFpyService(url, ImcConfigUtil.getValue(dimImcConfigFpyMap, "proxy", "dim_imc_config_fpy_url_proxy"));
    }

    public JSONObject postAppJson(String msgType, Long orgId, Map<String, Object> body, String inputClientId) {
        JSONObject result = new JSONObject();
        try {
            DynamicObject configResult = this.getAwsConfig(inputClientId);
            String token = this.getAccessToken(orgId, configResult);
            String url = this.getUrl(msgType, token);
            String req = AesUtil.encrypt(JSONObject.toJSONString(body), configResult.getString("encrypt_key"));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(MessageFormat.format("\u5f00\u59cb\u540c\u6b65aws\u9500\u9879\u6570\u636e,\u8bf7\u6c42\u5730\u5740{0},\u8bf7\u6c42\u53c2\u6570{1},\u8bf7\u6c42key{2},\u52a0\u5bc6\u540e\u5b57\u7b26\u4e32{3}", url, JSONObject.toJSONString(body), configResult.getString("encrypt_key"), req));
            }
            return this.postAppJson(url, req, "UTF-8");
        }
        catch (GeneralSecurityException e1) {
            LOGGER.error("\u8bf7\u6c42\u53d1\u7968\u4e91\u52a0\u5bc6\u5f02\u5e38", (Throwable)e1);
            result.put("description", (Object)ResManager.loadKDString((String)"AES\u52a0\u5bc6\u5931\u8d25", (String)"AwsFpyService_3", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u53d1\u7968\u4e91\u5f02\u5e38", (Throwable)e);
            result.put("description", (Object)e.getMessage());
        }
        result.put("errcode", (Object)"0001");
        return result;
    }

    public JSONObject postAppJson(String url, String body, String charset) {
        try {
            String jsostrnRet = HttpUtil.doPostJson(url, this.proxy, null, body);
            return JSONObject.parseObject((String)jsostrnRet);
        }
        catch (Exception e) {
            LOGGER.error("postAppJson-Exception:", (Throwable)e);
            return null;
        }
    }

    public JSONObject postAppJson(String url, String body) throws IOException {
        String str = HttpUtil.doPostJson(url, this.proxy, null, body);
        try {
            return JSONObject.parseObject((String)str);
        }
        catch (Exception e) {
            LOGGER.error("postAppJson-Exception:" + str, (Throwable)e);
            return null;
        }
    }

    public JSONObject getAppJson(String msgType, String taxNo, Map<String, String> param) throws IOException {
        AwsConfigDTO awsConfig = AwsFpyService.getAwsConfigByTaxNo(taxNo);
        String accessToken = this.getAccessToken(awsConfig.getClientId(), awsConfig.getClientSecret());
        String url = this.getUrl(msgType, accessToken);
        return this.getAppJson(url, param);
    }

    public JSONObject getAppJson(String url, Map<String, String> param) {
        String str = HttpUtil.doGet(url, param);
        try {
            return JSONObject.parseObject((String)str);
        }
        catch (Exception e) {
            LOGGER.error("getAppJson-Exception:" + str, (Throwable)e);
            return null;
        }
    }

    public String getAccessToken(Long orgId, DynamicObject configResult) throws IOException {
        String key = "bdm_aws_fpy_token:" + orgId;
        String token = CacheHelper.get(key);
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        String clientId = configResult.getString("client_id");
        String clientSecret = configResult.getString("client_secret");
        String encrypt_key = configResult.getString("encrypt_key");
        LOGGER.info("\u83b7\u53d6\u53d1\u7968\u4e91\u914d\u7f6e\uff1aclientId=" + clientId + " clientSecret=" + clientSecret + " encrypt_key=" + encrypt_key);
        String access_token = this.getAccessToken(clientId, clientSecret);
        if (StringUtils.isNotEmpty((CharSequence)access_token)) {
            CacheHelper.put(key, access_token, 1800);
        }
        return access_token;
    }

    public String getAccessToken(String clientId, String clientSecret) throws IOException {
        JSONObject jsonObject = new JSONObject();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex(clientId + clientSecret + timestamp);
        String url = this.baseUrl + "/base/oauth/token";
        jsonObject.put("sign", (Object)sign);
        jsonObject.put("timestamp", (Object)timestamp);
        jsonObject.put("client_id", (Object)clientId);
        LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token clientId:" + clientId + ", clientSecret: " + clientSecret);
        LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token:" + url + " param:" + jsonObject.toJSONString());
        JSONObject resultObj = UnitTestHelper.isUnitTest() ? new JSONObject() : this.postAppJson(url, jsonObject.toJSONString());
        LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token\u8fd4\u56de:" + resultObj.toJSONString());
        if ("0000".equals(resultObj.get((Object)"errcode"))) {
            return resultObj.getString("access_token");
        }
        LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token\u5931\u8d25:" + resultObj);
        throw new KDBizException(resultObj.getString("description"));
    }

    public DynamicObject getAwsConfig(String inputClientId) {
        if (StringUtils.isBlank((CharSequence)inputClientId)) {
            LOGGER.error("dim_imc_config_fpy_clientId\u914d\u7f6e\u4e3a\u7a7a");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s_clientId\u914d\u7f6e\u4e3a\u7a7a", (String)"AwsFpyService_14", (String)"imc-bdm-common", (Object[])new Object[0]), "dim_imc_config_fpy"));
        }
        DynamicObject configResult = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"client_id,client_secret,encrypt_key", (QFilter[])new QFilter("client_id", "=", (Object)inputClientId).toArray());
        if (configResult == null || StringUtils.isBlank((CharSequence)configResult.getString("client_id")) || StringUtils.isBlank((CharSequence)configResult.getString("client_secret")) || StringUtils.isBlank((CharSequence)configResult.getString("encrypt_key"))) {
            LOGGER.error("\u5f53\u524d\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4e91\u914d\u7f6e\u6709\u8bef\uff0cclientid\u4e3a%s\uff0c\u65e0\u6cd5\u540c\u6b65\uff0c\u8bf7\u524d\u5f80\u7cfb\u7edf\u670d\u52a1\u4e91-\u300b\u57fa\u7840\u8d44\u6599-\u300b\u8d22\u52a1\u6570\u636e-\u300b\u53d1\u7968\u4e91\u914d\u7f6e\u4e2d\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"AwsFpyService_12", (String)"imc-bdm-common", (Object[])new Object[0]), inputClientId));
        }
        return configResult;
    }

    public String getUrl(String type, String token) {
        return this.baseUrl + AwsFpyConstant.getUrl(type) + "?access_token=" + token + "&encry_type=GCM";
    }

    public static AwsConfigDTO getAwsConfigByTaxNo(Object taxNo) {
        AwsConfigDTO awsConfig;
        QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("taxregnum", "=", taxNo);
        DynamicObject configResult = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{enableQFilter});
        Map<String, String> awsConfigMap = ImcConfigUtil.getValue("dim_imc_config_fpy");
        if (configResult == null || StringUtils.isBlank((CharSequence)configResult.getString("client_id")) || StringUtils.isBlank((CharSequence)configResult.getString("client_secret")) || StringUtils.isBlank((CharSequence)configResult.getString("encrypt_key"))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u672a\u6210\u7cfb\u7edf\u4e91\u4e2d\u83b7\u53d6\u5230clientid\uff0c\u4ece\u5168\u5c40\u914d\u7f6e\u4e2d\u83b7\u53d6");
            }
            awsConfig = new AwsConfigDTO();
            awsConfig.setClientId(ImcConfigUtil.getValue(awsConfigMap, "clientid", "dim_imc_config_fpy_clientid"));
            awsConfig.setClientSecret(ImcConfigUtil.getValue(awsConfigMap, "clientsecret", "dim_imc_config_fpy_clientsecret"));
            awsConfig.setEncryptKey(ImcConfigUtil.getValue(awsConfigMap, "encryptkey", "dim_imc_config_fpy_encryptkey"));
        } else {
            awsConfig = DynamicObjectUtil.dynamicObject2Bean(AwsConfigDTO.class, configResult);
        }
        awsConfig.setUrl(ImcConfigUtil.getValue(awsConfigMap, "url", "dim_imc_config_fpy_url"));
        awsConfig.setProxyUrl(awsConfigMap.get("dim_imc_config_fpy_url_proxy"));
        return awsConfig;
    }

    public static String replaceUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        Map<String, String> config = ImcConfigUtil.getValue("replace_url_config");
        if (!CollectionUtils.isEmpty(config) && StringUtils.isNotBlank((CharSequence)config.get("beReplaced")) && StringUtils.isNotBlank((CharSequence)config.get("replaceTo"))) {
            url = url.replaceAll(config.get("beReplaced"), config.get("replaceTo"));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u66ff\u6362\u540e\u7684\u5730\u5740\u4e3a%s", url));
            }
            return url;
        }
        Map<String, String> map = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String awsUrl = ImcConfigUtil.getValue(map, "url", "dim_imc_config_fpy_url");
        if (StringUtils.isNotBlank((CharSequence)awsUrl)) {
            if (awsUrl.endsWith("/")) {
                awsUrl = awsUrl.substring(0, awsUrl.length() - 1);
            }
            url = url.replaceAll("https://api.piaozone.com", awsUrl);
            url = url.replaceAll("https://api-sit.piaozone.com/test", awsUrl);
            url = url.replaceAll("https://api-dev.piaozone.com/test", awsUrl);
            return url;
        }
        return url;
    }
}

