/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.GoodsInfoDTO;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgRequest;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.message.send.MessageSendService;
import kd.imc.bdm.common.message.util.IsmcToken;
import kd.imc.bdm.common.model.CompanyInfo;
import kd.imc.bdm.common.model.GoodsInfo;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class OpenInvoiceService {
    private static Log LOGGER = LogFactory.getLog(OpenInvoiceService.class);
    public static final String AWS_ACCESS_TOKEN = "accessToken_aws_";

    public List<CompanyInfo> queryCompany(String name) {
        ArrayList<CompanyInfo> listCompany = new ArrayList<CompanyInfo>();
        MsgRequest request = new MsgRequest();
        request.setMsgType("ExternalApi");
        request.setMsgId(UUID.next());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", name);
        request.setReqData(map);
        MsgResponse msgResponse = MessageSendService.send(request);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u62ac\u5934\u67e5\u8be2\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)msgResponse));
        }
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            JSONArray jsonArray = JSONArray.parseArray((String)msgResponse.getRespData());
            for (Object o : jsonArray) {
                JSONObject jsonObject = (JSONObject)o;
                CompanyInfo info = new CompanyInfo();
                String tel = jsonObject.getString("tel");
                String address = jsonObject.getString("address");
                info.setTaxNo(jsonObject.getString("creditCode"));
                info.setName(jsonObject.getString("name"));
                info.setPhone(null == tel ? "" : tel);
                info.setAddress(null == address ? "" : address);
                listCompany.add(info);
            }
        }
        return listCompany;
    }

    public List<GoodsInfo> queryGoodsInfoByFpy(String goodsName) {
        String response;
        ArrayList<GoodsInfo> list = new ArrayList<GoodsInfo>(8);
        if (StringUtils.isEmpty((CharSequence)goodsName)) {
            return list;
        }
        String accessToken = OpenInvoiceService.getAccessToken();
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            return list;
        }
        StringBuilder urlBuilder = new StringBuilder(AwsFpyService.newInstance().getBaseUrl());
        urlBuilder.append("/ai/knowledge/match/goodName");
        urlBuilder.append('?').append("access_token=").append(accessToken);
        JSONObject requestJson = new JSONObject();
        requestJson.put("name", (Object)goodsName);
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("client-platform", "common");
        LOGGER.info("\u667a\u80fd\u8d4b\u7801\u8bf7\u6c42\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        try {
            response = HttpUtil.doPostJson(urlBuilder.toString(), headers, requestJson.toJSONString(), 5000, 5000);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u667a\u80fd\u8d4b\u7801\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u8bc6\u522b\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5...", (Throwable)e);
            return list;
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            LOGGER.error("\u8bf7\u6c42\u667a\u80fd\u8d4b\u7801\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u8bc6\u522b\u63a5\u53e3\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5...response\u8fd4\u56de\u4e3a\u7a7a");
            return list;
        }
        LOGGER.info("url\u4e3a\uff1a{}, \u8fd4\u56de\u7684response\u4fe1\u606f\u4e3a\uff1a{}", (Object)urlBuilder.toString(), (Object)response);
        JSONObject resultJson = JSONObject.parseObject((String)response);
        if (!ErrorType.SUCCESS.getCode().equals(resultJson.getString("errcode"))) {
            LOGGER.error("\u8bf7\u6c42\u667a\u80fd\u8d4b\u7801\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u8bc6\u522b\u63a5\u53e3\u9519\u8bef\uff0c\u8fd4\u56de\u5f02\u5e38\u9519\u8bef\u7801\uff1a{}", (Object)response);
            OpenInvoiceService.clearCache(resultJson);
            return list;
        }
        if (!response.contains("data")) {
            return list;
        }
        List dataList = JSONArray.parseArray((String)resultJson.getString("data"), GoodsInfoDTO.class);
        if (dataList == null || dataList.isEmpty()) {
            return list;
        }
        dataList.forEach(entity -> {
            GoodsInfo info = new GoodsInfo();
            info.setGoodsCode(entity.getGoodsCode());
            info.setGoodsName(entity.getGoodsName());
            info.setShortName(entity.getGoodsSimpleName());
            info.setGoodsDesc("");
            info.setGoodsKey(entity.getGoodsSimpleCode());
            info.setAvailableState(entity.getAvailableState());
            info.setZzstsgl(entity.getVatException());
            info.setVersionNum("");
            info.setTaxRate(entity.getTaxRate());
            list.add(info);
        });
        LOGGER.info("\u667a\u80fd\u8d4b\u7801\u683c\u5f0f\u5316\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(list));
        return list;
    }

    private static void clearCache(JSONObject jsonObject) {
        String errCode = jsonObject.getString("errcode");
        String description = jsonObject.getString("description");
        if ("1999".equals(errCode) && ResManager.loadKDString((String)"token\u5df2\u7ecf\u5931\u6548", (String)"OpenInvoiceService_7", (String)"imc-bdm-common", (Object[])new Object[0]).equals(description)) {
            CacheHelper.remove(AWS_ACCESS_TOKEN);
        }
    }

    public static String getAccessToken() {
        String accessTokenCache = CacheHelper.get(AWS_ACCESS_TOKEN);
        if (StringUtils.isNotBlank((CharSequence)accessTokenCache)) {
            return accessTokenCache;
        }
        Map<String, String> map = ImcConfigUtil.getValue("dim_imc_config_fpy");
        String clientId = ImcConfigUtil.getValue(map, "clientid", "dim_imc_config_fpy_clientid");
        String clientsecret = ImcConfigUtil.getValue(map, "clientsecret", "dim_imc_config_fpy_clientsecret");
        AwsFpyService awsFpyService = AwsFpyService.newInstance();
        String accessToken = null;
        try {
            accessToken = awsFpyService.getAccessToken(clientId, clientsecret);
            CacheHelper.put(AWS_ACCESS_TOKEN, accessToken, 86400);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6aws\u7684token\u5931\u8d25\u4e86...", (Throwable)e);
        }
        return accessToken;
    }

    public static BigDecimal stringToTaxRate(String taxRate) {
        if (StringUtils.isEmpty((CharSequence)taxRate)) {
            return null;
        }
        if (taxRate.indexOf(37) > 0) {
            return new BigDecimal(taxRate.replace("%", "")).divide(new BigDecimal(100), 2, 4);
        }
        return new BigDecimal(taxRate);
    }

    public static Map<String, String> getConfig() {
        String str = CacheHelper.get("dim_sync_config");
        if (StringUtils.isEmpty((CharSequence)str)) {
            MsgRequest msgRequest = new MsgRequest();
            msgRequest.setMsgId(UUID.randomUUID());
            msgRequest.setMsgType("ImcGetParam");
            msgRequest.setReqData("request");
            MsgResponse response = MessageSendService.send(msgRequest);
            if ("0000".equals(response.getErrorCode())) {
                String respData = response.getRespData();
                CacheHelper.put("dim_sync_config", respData, 14400);
                return (Map)SerializationUtils.fromJsonString((String)respData, Map.class);
            }
            throw new KDBizException(response.getErrorMsg());
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    public List<GoodsInfo> queryGoodsInfoByName(String s, IsmcToken ismcToken, String ismcUrl) {
        return null;
    }
}

