/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.service;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.SendMsgEmailService;

public class PushFailMsgEmailService {
    private static final Log LOGGER = LogFactory.getLog(PushFailMsgEmailService.class);
    private static final String SUCCESS_CODE = "0000";
    private static final String FORM_ID = "bdm_fail_push_sms_email";
    private static final String CODE_NO = "invoicecode,invoiceno";
    private static final String INVOICE_ID = "invoiceid";
    private static final String TYPE = "type";
    public static final String TYPE_EMIAL = "email";
    public static final String TYPE_SMS = "sms";
    private static final String SEND_OBJ = "sendobj";
    private static final String SEND_TIMES = "sendtimes";
    private static final int SEND_TIMES_INIT = 0;
    private static final int SEND_TIMES_MAX = 10;
    private static final String STATUS = "status";
    private static final String STATUS_FINISH = "2";
    private static final String STATUS_SUCCESS = "1";
    private static final String STATUS_FAIL = "0";
    public static final String CREATE_TIME = "createtime";
    private static final String LAST_TIME = "lasttime";
    private static final String SELECT_PROPERTIES = "invoiceid,type,sendobj,sendtimes,createtime,lasttime,status";
    private static final int DATA_LIMIT = 500;

    public static void saveFailMsgEmail(MsgResponse response, DynamicObject invoice, String sendObject, String type) {
        try {
            DynamicObject invoiceObj = PushFailMsgEmailService.savePreCheck(response, invoice, sendObject, type);
            if (invoiceObj == null) {
                return;
            }
            Date nowDate = new Date();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)FORM_ID);
            dynamicObject.set(INVOICE_ID, invoiceObj.getPkValue());
            dynamicObject.set("invoicecode", invoiceObj.get("invoicecode"));
            dynamicObject.set("invoiceno", invoiceObj.get("invoiceno"));
            dynamicObject.set(TYPE, (Object)type);
            dynamicObject.set(SEND_OBJ, (Object)sendObject);
            dynamicObject.set(SEND_TIMES, (Object)0);
            dynamicObject.set(STATUS, (Object)STATUS_FAIL);
            dynamicObject.set(CREATE_TIME, (Object)nowDate);
            dynamicObject.set(LAST_TIME, (Object)nowDate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u77ed\u4fe1\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\u7684\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private static DynamicObject savePreCheck(MsgResponse response, DynamicObject invoice, String sendObject, String type) {
        if (response == null) {
            return null;
        }
        String errorCode = response.getErrorCode();
        if (SUCCESS_CODE.equals(errorCode)) {
            return null;
        }
        QFilter qFilter = new QFilter(INVOICE_ID, "=", invoice.getPkValue()).and(new QFilter(TYPE, "=", (Object)type)).and(new QFilter(SEND_OBJ, "=", (Object)sendObject));
        DynamicObject failPushSmsEmailObj = BusinessDataServiceHelper.loadSingle((String)FORM_ID, (String)"id", (QFilter[])qFilter.toArray());
        if (failPushSmsEmailObj != null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice", (String)CODE_NO);
    }

    public static DynamicObject[] getNeedPushRecordArray(Object createTime) {
        QFilter qFilter = new QFilter(STATUS, "=", (Object)STATUS_FAIL).and(new QFilter(SEND_TIMES, "<", (Object)10));
        if (createTime != null) {
            qFilter.and(new QFilter(CREATE_TIME, ">", createTime));
        }
        return BusinessDataServiceHelper.load((String)FORM_ID, (String)SELECT_PROPERTIES, (QFilter[])qFilter.toArray(), (String)LAST_TIME, (int)500);
    }

    public static void rePushMsgEmail(DynamicObject record) {
        String errorCode;
        String type = record.getString(TYPE);
        String sendObj = record.getString(SEND_OBJ);
        String status = record.getString(STATUS);
        int times = record.getInt(SEND_TIMES);
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)record.get(INVOICE_ID), (String)"sim_vatinvoice");
        MsgResponse msgResponse = null;
        if (TYPE_SMS.equals(type)) {
            msgResponse = SendMsgEmailService.sendOneSms(invoice, sendObj);
        } else if (TYPE_EMIAL.equals(type)) {
            if (!RegexUtil.isEmail(sendObj)) {
                LOGGER.info(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceValidHelper_2", (String)"imc-bdm-common", (Object[])new Object[0]));
            } else {
                msgResponse = SendMsgEmailService.emailOneDefaultOrBySelf(invoice, sendObj);
            }
        }
        if (msgResponse != null && SUCCESS_CODE.equals(errorCode = msgResponse.getErrorCode())) {
            status = STATUS_SUCCESS;
        }
        if (STATUS_FAIL.equals(status) && ++times >= 10) {
            status = STATUS_FINISH;
        }
        record.set(SEND_TIMES, (Object)times);
        record.set(STATUS, (Object)status);
        record.set(LAST_TIME, (Object)new Date());
        SaveServiceHelper.update((DynamicObject)record);
        PushFailMsgEmailService.updateInvoicePushStatus(invoice);
    }

    public static void updateInvoicePushStatus(DynamicObject invoice) {
        QFilter qFilter = new QFilter(INVOICE_ID, "=", invoice.getPkValue());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)FORM_ID, (String)STATUS, (QFilter[])qFilter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            int successNum = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                String status = dynamicObject.getString(STATUS);
                if (!STATUS_SUCCESS.equals(status)) continue;
                ++successNum;
            }
            PushStatusEnum pushStatusEnum = successNum == 0 ? PushStatusEnum.failed : (successNum == dynamicObjects.length ? PushStatusEnum.success : PushStatusEnum.part_success);
            invoice.set("pushstatus", (Object)pushStatusEnum.getCode());
            SaveServiceHelper.update((DynamicObject)invoice);
        }
    }

    public static void clearMoreDataByMonth(int month) {
        Date date = DateUtils.addMonth(new Date(), -month);
        QFilter qFilter = new QFilter(CREATE_TIME, "<", (Object)date);
        int delete = DeleteServiceHelper.delete((String)FORM_ID, (QFilter[])qFilter.toArray());
        if (delete > 0) {
            LOGGER.info("\u5220\u9664\u3010{}\u3011\u7684\u6570\u636e\u77ed\u4fe1\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\u7684\u8bb0\u5f55\u6570\u3010{}\u3011", (Object)DateUtils.format(date, "yyyy-MM-dd HH:mm:ss"), (Object)delete);
        }
    }
}

