/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.util.Base64Util;

public class AesUtil {
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String DEFAULT_ALGORITHM = "AES";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static String encrypt(String content, String key) throws Exception {
        byte[] iv = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(iv);
        byte[] contentBytes = content.getBytes(DEFAULT_CHARSET);
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        GCMParameterSpec params = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)AesUtil.getSecretKey(key), params);
        byte[] encryptData = cipher.doFinal(contentBytes);
        assert (encryptData.length == contentBytes.length + 16);
        byte[] message = new byte[12 + contentBytes.length + 16];
        System.arraycopy(iv, 0, message, 0, 12);
        System.arraycopy(encryptData, 0, message, 12, encryptData.length);
        return Base64Util.encode(message);
    }

    public static String decrypt(String content, String key) throws Exception {
        byte[] byteEncrypt = Base64Util.decode(content, DEFAULT_CHARSET);
        if (byteEncrypt.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, byteEncrypt, 0, 12);
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        cipher.init(2, (Key)AesUtil.getSecretKey(key), params);
        byte[] byteDecrypt = cipher.doFinal(byteEncrypt, 12, byteEncrypt.length - 12);
        return new String(byteDecrypt, DEFAULT_CHARSET);
    }

    private static SecretKeySpec getSecretKey(String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator kg = KeyGenerator.getInstance(DEFAULT_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(key.getBytes(DEFAULT_CHARSET));
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), DEFAULT_ALGORITHM);
    }

    public static String getData(DynamicObject businessSystem, int opt, String data) throws Exception {
        if (null == businessSystem || StringUtils.isEmpty((CharSequence)data)) {
            return "";
        }
        if (opt == 0) {
            if ("0".equals(businessSystem.getString("encryption_type"))) {
                return AesUtil.encrypt(data, businessSystem.getString("aes_pwds"));
            }
            return Base64Util.encode(data, DEFAULT_CHARSET);
        }
        if ("0".equals(businessSystem.getString("encryption_type"))) {
            return AesUtil.decrypt(data, businessSystem.getString("aes_pwds"));
        }
        return Base64Util.decodeToString(data, DEFAULT_CHARSET);
    }
}

