/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Base64Util {
    private static final Log log = LogFactory.getLog(Base64Util.class);
    public static final String DEFAULT_CODE = "UTF-8";

    public static String encode(byte[] contentBytes) {
        if (null == contentBytes || contentBytes.length == 0) {
            return "";
        }
        try {
            return Base64.getEncoder().encodeToString(contentBytes);
        }
        catch (Exception e) {
            log.error("base64\u52a0\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String encode(String content, String code) {
        if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)code)) {
            return "";
        }
        try {
            return Base64.getEncoder().encodeToString(content.getBytes(code));
        }
        catch (UnsupportedEncodingException e) {
            log.error("base64\u52a0\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String decodeToString(String content, String code) {
        if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)code)) {
            return "";
        }
        try {
            return new String(Base64.getDecoder().decode(content), code);
        }
        catch (Exception e) {
            log.error("base64\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static byte[] decode(String content, String code) {
        if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        try {
            return Base64.getDecoder().decode(content.getBytes(code));
        }
        catch (UnsupportedEncodingException e) {
            log.error("base64\u89e3\u5bc6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

