/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;

public class BeanUtil {
    private static final Log LOG = LogFactory.getLog(BeanUtil.class);

    public static <T> T dynamicObject2SimpleBean(DynamicObject dynamicObject, Class<T> clazz) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        Iterator iterator = collect.iterator();
        while (iterator.hasNext()) {
            try {
                Field[] declaredFields;
                T t = clazz.newInstance();
                for (Field declaredField : declaredFields = clazz.getDeclaredFields()) {
                    if (!collect.containsKey((Object)declaredField.getName())) continue;
                    ReflectionUtils.makeAccessible((Field)declaredField);
                    if ("taxrate".equals(declaredField.getName())) {
                        String rateStr = dynamicObject.getString(declaredField.getName());
                        if (StringUtils.isBlank((String)rateStr)) {
                            declaredField.set(t, null);
                            continue;
                        }
                        if (rateStr.startsWith("0.00")) {
                            rateStr = "0.00";
                        }
                        declaredField.set(t, new BigDecimal(rateStr));
                        continue;
                    }
                    if ("id".equals(declaredField.getName()) || "seq".equals(declaredField.getName())) {
                        declaredField.set(t, String.valueOf(dynamicObject.get(declaredField.getName())));
                        continue;
                    }
                    declaredField.set(t, dynamicObject.get(declaredField.getName()));
                }
                return t;
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

