/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.constant.ParamConfigConstant;
import kd.imc.bdm.common.constant.systemsetting.CallBackTypeEnum;
import kd.imc.bdm.common.dto.CallBackProcessVo;
import kd.imc.bdm.common.dto.CallbackLogVo;
import kd.imc.bdm.common.dto.InvoiceMatchVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.helper.callback.CallBackLogHelper;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.invoicecallback.IInvoiceCallBackService;
import kd.imc.bdm.common.invoicecallback.InvoiceCallBackFactory;
import kd.imc.bdm.common.invoicecallback.impl.CqomsCallBackServiceImpl;
import kd.imc.bdm.common.invoicecallback.impl.InvoiceEVehicleCallBackServiceImpl;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.CallbackMcloudUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MqPublishUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class CallbackHelperUtil {
    private static final Log LOGGER = LogFactory.getLog(CallbackHelperUtil.class);
    public static final String BUSINESS_SYSTEM_CONFIG = "invsm_app_access_config";
    public static final int MQRETRYTIMES = 5;
    public static final int MAXRETRYTIMES = 10;
    public static final String SYSTEM_SOURCE_FI = "KINGDEE_FI";
    public static final String SYSTEM_SOURCE_YNZY = "YNZY_TOBACCO";
    public static final String SYSTEM_SOURCE_ARFI = "AR_FINARBILL";
    public static final String SYSTEM_SOURCE_ARFI_CN = "\u8d22\u52a1\u5e94\u6536\u5355";
    public static final String SYSTEM_ZAN_GU_BILL = "AR_BUSBILL";
    public static final String SYSTEM_SOURCE_OCPOS_ORDER = "OCPOS_SALEORDER";
    public static final String SYSTEM_SOURCE_OCPOS_ORDER_RETURN = "OCPOS_SALEORDER_RETURN";
    public static final String SYSTEM_SOURCE_CQOMS = "CQOMS";
    public static final String SYSTEM_SOURCE_PMGT = "PMGT_BILL";
    public static final String SYSTEM_SOURCE_REPC = "REPC_BILL";
    public static final String BGD_COLLECT = "BGD_COLLECT";

    public static boolean isSystemSourceFi(String systemsource) {
        boolean result = false;
        if (StringUtils.equalsIgnoreCase((CharSequence)systemsource, (CharSequence)SYSTEM_SOURCE_FI) || StringUtils.equalsIgnoreCase((CharSequence)systemsource, (CharSequence)SYSTEM_SOURCE_YNZY) || StringUtils.equalsIgnoreCase((CharSequence)systemsource, (CharSequence)SYSTEM_SOURCE_ARFI) || StringUtils.equalsIgnoreCase((CharSequence)systemsource, (CharSequence)SYSTEM_ZAN_GU_BILL) || StringUtils.equalsIgnoreCase((CharSequence)systemsource, (CharSequence)SYSTEM_SOURCE_ARFI_CN)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CallbackResponseVo callbackHandler(String callbackMessage, int callbackSource) {
        DLock lock;
        CallbackResponseVo responseVo;
        block25: {
            boolean getLock;
            CallbackLogVo callbackLog;
            block23: {
                CallbackResponseVo callbackResponseVo;
                block24: {
                    block21: {
                        CallbackResponseVo callbackResponseVo2;
                        block22: {
                            responseVo = null;
                            callbackLog = null;
                            lock = null;
                            getLock = false;
                            callbackLog = CallbackHelperUtil.checkCallBackCommon(callbackMessage, callbackSource);
                            boolean isBillCallBack = CallBackLogTypeEnum.bill.getValue().equals(callbackLog.getCallbackType()) || CallBackLogTypeEnum.allCallback.getValue().equals(callbackLog.getCallbackType());
                            String lockKey = isBillCallBack ? callbackLog.getCallbackBillNo() : callbackLog.getInvoiceCode() + callbackLog.getInvoiceNo();
                            lock = DLock.create((String)(lockKey + '_' + "invoice_callback"));
                            if (lock.tryLock()) break block21;
                            callbackResponseVo2 = CallbackResponseVo.valueOfError(String.format(ResManager.loadKDString((String)"%1$s[%2$s]\u6b63\u5728\u8fdb\u884c\u56de\u8c03", (String)"CallbackHelperUtil_44", (String)"imc-bdm-common", (Object[])new Object[0]), isBillCallBack ? ResManager.loadKDString((String)"\u5355\u636e", (String)"CallbackHelperUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u7968", (String)"CallbackHelperUtil_3", (String)"imc-bdm-common", (Object[])new Object[0]), lockKey));
                            if (null == callbackLog || responseVo == null) break block22;
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info(String.format("\u53d1\u7968\u56de\u8c03 \u56de\u8c03\u7ed3\u679cResponseVo\u662f:%s\uff0c:%s\uff0cCallbackLog\u662f:%s", callbackLog.getBusinessFid(), JSON.toJSONString((Object)responseVo), JSON.toJSONString((Object)callbackLog)));
                            }
                            if (getLock) {
                                CallbackHelperUtil.updateCallbackResult(callbackLog, responseVo);
                            }
                        }
                        if (lock == null) return callbackResponseVo2;
                        lock.unlock();
                        return callbackResponseVo2;
                    }
                    getLock = true;
                    boolean isAlreadyCallBack = CallbackHelperUtil.getCallBackStatus(callbackLog, callbackSource);
                    if (!isAlreadyCallBack) break block23;
                    getLock = false;
                    callbackResponseVo = null;
                    if (null == callbackLog || responseVo == null) break block24;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("\u53d1\u7968\u56de\u8c03 \u56de\u8c03\u7ed3\u679cResponseVo\u662f:%s\uff0c:%s\uff0cCallbackLog\u662f:%s", callbackLog.getBusinessFid(), JSON.toJSONString((Object)responseVo), JSON.toJSONString((Object)callbackLog)));
                    }
                    if (getLock) {
                        CallbackHelperUtil.updateCallbackResult(callbackLog, responseVo);
                    }
                }
                if (lock == null) return callbackResponseVo;
                lock.unlock();
                return callbackResponseVo;
            }
            try {
                List<IInvoiceCallBackService> services = InvoiceCallBackFactory.getService();
                for (int i = services.size() - 1; i >= 0; --i) {
                    IInvoiceCallBackService callBackService = services.get(i);
                    if (!callBackService.support(callbackLog)) continue;
                    if (callBackService.getClass() == InvoiceEVehicleCallBackServiceImpl.class) {
                        responseVo = callBackService.callBack(callbackLog, null);
                        break;
                    }
                    DynamicObject invoice = callBackService.getInvoiceForCallBack(callbackLog);
                    responseVo = callBackService.callBack(callbackLog, invoice);
                    break;
                }
                if (null == callbackLog || responseVo == null) break block25;
            }
            catch (Exception e) {
                block26: {
                    try {
                        if (e instanceof MsgException) {
                            MsgException msgException = (MsgException)e;
                            responseVo = new CallbackResponseVo(msgException.getErrorCode(), msgException.getErrorMsg(), "");
                        } else {
                            responseVo = new CallbackResponseVo(ApiErrCodeEnum.ERROR.getCode(), e.getMessage(), "");
                        }
                        LOGGER.error(String.format("\u56de\u8c03\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edf\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a:[%s]", responseVo.getMessage()), (Throwable)e);
                        if (null == callbackLog || responseVo == null) break block26;
                    }
                    catch (Throwable throwable) {
                        if (null != callbackLog && responseVo != null) {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info(String.format("\u53d1\u7968\u56de\u8c03 \u56de\u8c03\u7ed3\u679cResponseVo\u662f:%s\uff0c:%s\uff0cCallbackLog\u662f:%s", callbackLog.getBusinessFid(), JSON.toJSONString((Object)responseVo), JSON.toJSONString((Object)callbackLog)));
                            }
                            if (getLock) {
                                CallbackHelperUtil.updateCallbackResult(callbackLog, responseVo);
                            }
                        }
                        if (lock == null) throw throwable;
                        lock.unlock();
                        throw throwable;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("\u53d1\u7968\u56de\u8c03 \u56de\u8c03\u7ed3\u679cResponseVo\u662f:%s\uff0c:%s\uff0cCallbackLog\u662f:%s", callbackLog.getBusinessFid(), JSON.toJSONString((Object)responseVo), JSON.toJSONString((Object)callbackLog)));
                    }
                    if (getLock) {
                        CallbackHelperUtil.updateCallbackResult(callbackLog, responseVo);
                    }
                }
                if (lock == null) return responseVo;
                lock.unlock();
                return responseVo;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u53d1\u7968\u56de\u8c03 \u56de\u8c03\u7ed3\u679cResponseVo\u662f:%s\uff0c:%s\uff0cCallbackLog\u662f:%s", callbackLog.getBusinessFid(), JSON.toJSONString((Object)responseVo), JSON.toJSONString((Object)callbackLog)));
            }
            if (getLock) {
                CallbackHelperUtil.updateCallbackResult(callbackLog, responseVo);
            }
        }
        if (lock == null) return responseVo;
        lock.unlock();
        return responseVo;
    }

    private static boolean getCallBackStatus(CallbackLogVo callbackLog, int callbackSource) {
        if (2 == callbackSource) {
            return false;
        }
        if (null == callbackLog.getId()) {
            return false;
        }
        Long logId = callbackLog.getId();
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"invsm_callback_log");
        if (null != log) {
            return "0".equals(log.getString("callback_status"));
        }
        return false;
    }

    private static CallbackLogVo checkCallBackCommon(String callbackMessage, int callbackSource) {
        int retryTimes;
        if (StringUtils.isEmpty((CharSequence)callbackMessage)) {
            throw new MsgException(ApiErrCodeEnum.OK.getCode(), ResManager.loadKDString((String)"\u6d88\u606f\u4e3a\u7a7a\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"CallbackHelperUtil_5", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        CallbackLogVo callbackLog = (CallbackLogVo)JSON.parseObject((String)callbackMessage, CallbackLogVo.class);
        if (null == callbackLog) {
            throw new MsgException(ApiErrCodeEnum.OK.getCode(), ResManager.loadKDString((String)"\u6d88\u606f\u4e3a\u7a7a\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"CallbackHelperUtil_5", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        String mqretryObj = ImcConfigUtil.getValue("sim_invoice_callback_config", "mqretry_times");
        int n = retryTimes = StringUtils.isEmpty((CharSequence)mqretryObj) ? 5 : Integer.parseInt(mqretryObj);
        if (callbackSource == 0 && callbackLog.getRetryTimes() > retryTimes) {
            throw new MsgException(ApiErrCodeEnum.OK.getCode(), ResManager.loadKDString((String)"\u961f\u5217\u91cd\u8bd5\u8d85\u6b21\u6570\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"CallbackHelperUtil_6", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (callbackSource != 2 && callbackLog.getRetryTimes() > 10) {
            throw new MsgException(ApiErrCodeEnum.OK.getCode(), ResManager.loadKDString((String)"\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"CallbackHelperUtil_7", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        OpenApiCallbackInterfaceCodeEnum callbackApi = OpenApiCallbackInterfaceCodeEnum.getInterfaceByCode(callbackLog.getBusinessType());
        if (null == callbackApi) {
            throw new MsgException(ApiErrCodeEnum.OK.getCode(), ResManager.loadKDString((String)"\u65e0\u6b64\u56de\u8c03\u7c7b\u578b\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"CallbackHelperUtil_8", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)callbackLog.getBusinessSystemCode())) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u65e0\u4e1a\u52a1\u7cfb\u7edf\uff0c\u7ed3\u675f\u4efb\u52a1", (String)"CallbackHelperUtil_9", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        return callbackLog;
    }

    public static DynamicObject getBusinessSystemByCode(String businessSystemCode) {
        if (StringUtils.isEmpty((CharSequence)businessSystemCode)) {
            return null;
        }
        QFilter filter = new QFilter("code", "=", (Object)businessSystemCode);
        return BusinessDataServiceHelper.loadSingle((String)BUSINESS_SYSTEM_CONFIG, (String)"code,name,encryption_type,aes_pwds,is_valid,callback_url,callback_url_two,callback_url_thr", (QFilter[])filter.toArray());
    }

    public static CallbackResponseVo checkBusinessSystemValid(DynamicObject businessSystem) {
        String aesPwds;
        if (null == businessSystem) {
            return new CallbackResponseVo(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u65e0\u6b64\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801", (String)"CallbackHelperUtil_10", (String)"imc-bdm-common", (Object[])new Object[0]), "");
        }
        if (!"1".equals(businessSystem.getString("is_valid"))) {
            return new CallbackResponseVo(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5bf9\u63a5\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]\u65e0\u6548", (String)"CallbackHelperUtil_11", (String)"imc-bdm-common", (Object[])new Object[0]), businessSystem.getString("code")), "");
        }
        if ("0".equals(businessSystem.getString("encryption_type")) && (StringUtils.isEmpty((CharSequence)(aesPwds = businessSystem.getString("aes_pwds"))) || aesPwds.length() != 16)) {
            return new CallbackResponseVo(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u52a0\u5bc6\u79d8\u94a5\u672a\u8bbe\u7f6e\u6216\u8bbe\u7f6e\u4e0d\u6b63\u786e[16\u4f4d\u957f\u5ea6]", (String)"CallbackHelperUtil_12", (String)"imc-bdm-common", (Object[])new Object[0]), "");
        }
        return new CallbackResponseVo(ApiErrCodeEnum.OK.getCode(), "", "");
    }

    public static void updateCallbackResult(CallbackLogVo callbackLogVo, CallbackResponseVo responseVo) {
        if (null == callbackLogVo.getId()) {
            return;
        }
        DynamicObject callbackLog = BusinessDataServiceHelper.loadSingle((Object)callbackLogVo.getId(), (String)"invsm_callback_log");
        if (null != callbackLog) {
            String message = responseVo.getMessage();
            callbackLog.set("callback_result", (Object)responseVo.getCode());
            callbackLog.set("callback_message", (Object)(null != message ? (message.length() > 180 ? message.substring(0, 180) : message) : ""));
            callbackLog.set("retry_times", (Object)(callbackLog.getInt("retry_times") + 1));
            callbackLog.set("callback_content", (Object)RequestContext.get().getTraceId());
            callbackLog.set("callback_content_tag", (Object)callbackLogVo.getCallbackContent());
            callbackLog.set("update_time", (Object)new Date());
            if ("0".equals(responseVo.getCode())) {
                callbackLog.set("callback_status", (Object)"0");
                callbackLog.set("callback_message", (Object)"");
            } else {
                callbackLog.set("callback_status", (Object)"1");
            }
            ImcSaveServiceHelper.save(callbackLog);
        }
    }

    public static void sendErrorCallbackMessage(String errorMsg, DynamicObject invoiceDynamicObject, String businessType) {
        if ("7".equals(invoiceDynamicObject.getString("buyertype"))) {
            QFilter qFilter = new QFilter("invoiceid", "=", invoiceDynamicObject.getPkValue());
            DynamicObject scanDynamicObject = BusinessDataServiceHelper.loadSingle((String)"sim_scan_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma("sim_scan_invoice"), (QFilter[])qFilter.toArray());
            if (scanDynamicObject != null) {
                scanDynamicObject.set("status", (Object)"0");
            }
        }
        IssuePolicyHelper.deleteUseAmountLog(invoiceDynamicObject);
        if (!"sim_vatinvoice".equals(invoiceDynamicObject.getDynamicObjectType().getName())) {
            return;
        }
        if ("0".equals(ImcConfigUtil.getValue(CacheKeyEnum.SIM_ERROR_CALLBACK))) {
            return;
        }
        boolean isForceErrorCallBack = "1".equals(ImcConfigUtil.getValue(CacheKeyEnum.SIM_ERROR_FORCE_CALLBACK.getConfigType(), CacheKeyEnum.SIM_ERROR_FORCE_CALLBACK.getConfigKey()));
        if (!isForceErrorCallBack && (CallbackHelperUtil.isAutoIssue(DynamicObjectUtil.getDynamicObjectLongValue(invoiceDynamicObject.get("orgid")), invoiceDynamicObject.getString("orderno"), errorMsg) || CallbackHelperUtil.isAllOrgAutoIssue(invoiceDynamicObject, errorMsg))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5df2\u7ecf\u5339\u914d\u5230\u81ea\u52a8\u91cd\u5f00\uff0c\u4e0d\u6267\u884c\u5931\u8d25\u56de\u8c03\uff0c\u6d41\u6c34\u53f7\u662f[%s]", invoiceDynamicObject.getString("orderno")));
            }
            return;
        }
        invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.failed.getCode());
        String systemSource = invoiceDynamicObject.getString("systemsource");
        if (StringUtils.isBlank((CharSequence)systemSource) || CallbackHelperUtil.isSystemSourceFi(systemSource)) {
            try {
                if (CallbackHelperUtil.isSystemSourceFi(systemSource)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("\u5e94\u6536\u5355\u4e0b\u63a8\u5f00\u7968\u6267\u884c\u5f00\u7968\u5931\u8d25\u540e\u64cd\u4f5c\u5f00\u59cb\uff0c\u6d41\u6c34\u53f7%s", invoiceDynamicObject.getString("orderno")));
                    }
                    DynamicObject invoiceWait = BusinessDataServiceHelper.loadSingle((Object)invoiceDynamicObject.getPkValue(), (String)"sim_invoice_wait");
                    OperationServiceHelper.executeOperate((String)"afterissuefail", (String)"sim_invoice_wait", (DynamicObject[])new DynamicObject[]{invoiceWait}, null);
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u6267\u884c\u5f00\u7968\u5931\u8d25\u540e\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u6c34\u53f7%s", invoiceDynamicObject.getString("orderno")), (Throwable)e);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38", (String)"CallbackHelperUtil_48", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        errorMsg = GBKUtils.cutGBKString(errorMsg, 200);
        LOGGER.info(String.format("sendErrorCallbackMessage %s %s", systemSource, errorMsg));
        Map<String, String> botpErrorCallBackConfig = ImcConfigUtil.getValue("botp_bill_need_error_callback");
        invoiceDynamicObject.set("result", (Object)errorMsg);
        ImcSaveServiceHelper.update((DynamicObject)invoiceDynamicObject);
        if (SYSTEM_SOURCE_CQOMS.equals(systemSource)) {
            new CqomsCallBackServiceImpl().errorCallBack(businessType, invoiceDynamicObject, errorMsg);
            return;
        }
        if (ParamConfigConstant.ErrorCallBack.YES.equals(botpErrorCallBackConfig.get(systemSource))) {
            CallbackHelperUtil.sendCallBackMsgBOTP(invoiceDynamicObject, systemSource, businessType, false);
        }
        if ("BILL_CENTER".equals(invoiceDynamicObject.getString("systemsource"))) {
            LOGGER.info(String.format("\u5f00\u7968\u5931\u8d25\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f%s", invoiceDynamicObject.getString("orderno")));
            DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callback", (Object[])new Object[]{invoiceDynamicObject.getPkValue()});
            return;
        }
        try {
            List<Object> callBackUrlList = new ArrayList<String>(4);
            if ("XKQJ".equals(systemSource)) {
                callBackUrlList.add("XKQJ");
            } else {
                callBackUrlList = CallbackHelperUtil.getCallBackUrlList(invoiceDynamicObject.getString("systemsource"));
            }
            if (callBackUrlList == null || callBackUrlList.isEmpty()) {
                return;
            }
            for (String string : callBackUrlList) {
                if (systemSource.startsWith("3std1")) {
                    SendCallBackHelper.invoiceAllEndCallback(invoiceDynamicObject, businessType, string, errorMsg);
                    continue;
                }
                SendCallBackHelper.normalExecuteErrorCallBack(errorMsg, invoiceDynamicObject, businessType, systemSource, string);
            }
        }
        catch (Exception e) {
            LOGGER.info("sendErrorCallbackMessage response error" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCallbackMessage(DynamicObject invoiceDynamicObject, String systemSource, String businessType) {
        if (null == invoiceDynamicObject) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u56de\u8c03");
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceDynamicObject.getString("wxid")) || "12".equals(invoiceDynamicObject.getString("buyertype"))) {
            CallbackHelperUtil.writebackGiftReceipt(invoiceDynamicObject);
            CallbackMcloudUtil.dealInvoice2Mcloud(invoiceDynamicObject);
        }
        if (StringUtils.isEmpty((CharSequence)systemSource) || StringUtils.isEmpty((CharSequence)businessType)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u7cfb\u7edf\u6765\u6e90\u4e3a\u7a7a\uff0c\u4e0d\u56de\u8c03");
            }
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("CallbackHelperUtil sendCallbackMessage invoiceDynamicObject:%s ,systemSource:%s, businessType:%s", SerializationUtils.toJsonString((Object)invoiceDynamicObject), systemSource, businessType));
        }
        if (BotpHelper.isBotpSystemSource(systemSource) || BotpHelper.getSystemConfigVo(systemSource).isAutoBotpSystem()) {
            CallbackHelperUtil.sendCallBackMsgBOTP(invoiceDynamicObject, systemSource, businessType);
            return;
        }
        if (CallbackHelperUtil.isFromArIssueBill(systemSource)) {
            InvoiceMatchVo matchVo = RelationHelper.getInvoiceMatchVo(invoiceDynamicObject);
            String batchBelong = matchVo.isFromRedMatchBill() ? matchVo.getRedBills().get(0).getString("billno") : invoiceDynamicObject.getString("batchbelong");
            String lockKey = batchBelong + '_' + DynamicObjectUtil.getDynamicObjectLongValue(invoiceDynamicObject.get("orgid")) + '_' + "ar_invoice_callback";
            DLock dLock = DLock.create((String)lockKey, (String)(lockKey + "lock"));
            dLock.lock();
            try {
                if (matchVo.isFromRedMatchBill()) {
                    boolean isAllIssued = CallbackHelperUtil.isMatchBillAllInv(matchVo, invoiceDynamicObject);
                    if (!isAllIssued && businessType.equals(OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode())) {
                        LOGGER.info("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u6ca1\u6709\u5168\u90e8\u5f00\u7968\u6210\u529f");
                        return;
                    }
                } else if (!CallbackHelperUtil.isAllInv(invoiceDynamicObject) && businessType.equals(OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode())) {
                    LOGGER.info("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u6ca1\u6709\u5168\u90e8\u5f00\u7968\u6210\u529f");
                    return;
                }
                CallBackProcessVo vo = new CallBackProcessVo(invoiceDynamicObject, systemSource, businessType, "\u5e94\u6536\u5f00\u7968\u5355");
                if (matchVo.isFromRedMatchBill()) {
                    vo.setBatchNoFromRedMatchBill(matchVo.getRedBills().get(0).getString("billno"));
                    vo.setBillPkFromRedMatchBill(matchVo.getRedBills().get(0).getLong("id"));
                }
                CallbackHelperUtil.pushCallBackLogToMQ(vo);
            }
            finally {
                dLock.unlock();
            }
            return;
        }
        DynamicObject callBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)"url", (QFilter[])new QFilter("business_system_code", "=", (Object)systemSource).toArray());
        if (callBackConfig != null) {
            CallbackHelperUtil.pushCallBackLogToMQ(new CallBackProcessVo(invoiceDynamicObject, systemSource, businessType, ResManager.loadKDString((String)"EAS\u63a8\u5355", (String)"CallbackHelperUtil_20", (String)"imc-bdm-common", (Object[])new Object[0])));
            return;
        }
        List<Object> urlList = new ArrayList<String>(4);
        if ("XKQJ".equals(systemSource)) {
            urlList.add("\u661f\u7a7a\u65d7\u8230\u7248");
        } else {
            urlList = CallbackHelperUtil.getCallBackUrlList(systemSource);
        }
        if (urlList == null) {
            return;
        }
        for (String string : urlList) {
            LOGGER.info("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u5f00\u59cb\u53d1\u9001->" + invoiceDynamicObject.getString("invoiceno"));
            if (systemSource.startsWith("3std1")) {
                SendCallBackHelper.invoiceAllEndCallback(invoiceDynamicObject, businessType, string, null);
                continue;
            }
            CallbackHelperUtil.pushCallBackLogToMQ(new CallBackProcessVo(invoiceDynamicObject, systemSource, businessType, string));
        }
    }

    private static boolean isMatchBillAllInv(InvoiceMatchVo matchVo, DynamicObject invoice) {
        String invoiceType;
        Set<Long> billPks = matchVo.getRedBills().stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set<Long> invPks = RelationHelper.getRedMatchBlueTBillIds(billPks);
        String issueType = invoice.getString("issuetype");
        if (InvoiceUtils.isRedConfirmInvoice(issueType, invoiceType = invoice.getString("invoicetype"))) {
            QFilter filter = new QFilter("id", "in", invPks).and("number", "!=", (Object)invoice.getString("infocode")).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"id", (QFilter[])filter.toArray());
            return invPks.size() == redConfirms.length + 1;
        }
        if (InvoiceUtils.isRedInfoInvoice(issueType, invoiceType)) {
            QFilter invFilter = new QFilter("id", "in", invPks).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue(invoice.getDynamicObject("orgid"))).and("status", "=", (Object)"4").and("orderno", "!=", (Object)invoice.getString("orderno"));
            DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id", (QFilter[])invFilter.toArray());
            return invPks.size() == redInfos.length + 1;
        }
        QFilter filter = new QFilter("id", "in", invPks).and("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode()).and("orderno", "!=", (Object)invoice.getString("orderno"));
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id", (QFilter[])filter.toArray());
        return invPks.size() == invoices.length + 1;
    }

    private static void writebackGiftReceipt(DynamicObject invoice) {
        if (!"12".equals(invoice.getString("buyertype"))) {
            return;
        }
        DynamicObject giftReceipt = BusinessDataServiceHelper.loadSingle((String)"sim_gift_receipt", (String)"", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
        if (giftReceipt == null) {
            return;
        }
        giftReceipt = BusinessDataServiceHelper.loadSingle((Object)giftReceipt.getPkValue(), (String)"sim_gift_receipt");
        giftReceipt.set("invoicecode", (Object)invoice.getString("invoicecode"));
        giftReceipt.set("invoiceno", (Object)invoice.getString("invoiceno"));
        ImcSaveServiceHelper.save(giftReceipt);
        String source = giftReceipt.getString("source");
        if (!"billcenter".equals(source)) {
            return;
        }
        long billcenterId = giftReceipt.getLong("billcenterid");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sim_isomerism_bill_data", (String)"", (QFilter[])new QFilter("id", "=", (Object)billcenterId).toArray());
        if (bill == null) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\uff0c\u65e0\u6cd5\u751f\u6210\u5c0f\u7968\u7801\u3002");
            return;
        }
        bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"sim_isomerism_bill_data");
        bill.set("giftstatus", (Object)"2");
        DynamicObjectCollection billInvoices = bill.getDynamicObjectCollection("invoice");
        for (DynamicObject billInvoice : billInvoices) {
            if (!invoice.getString("invoicecode").equals(billInvoice.getString("invoicecode")) || !invoice.getString("invoiceno").equals(billInvoice.getString("invoiceno"))) continue;
            return;
        }
        DynamicObject billInvoice = billInvoices.addNew();
        billInvoice.set("invoicecode", (Object)invoice.getString("invoicecode"));
        billInvoice.set("invoiceno", (Object)invoice.getString("invoiceno"));
        billInvoice.set("issuetime", (Object)invoice.getDate("issuetime"));
        billInvoice.set("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount"));
        billInvoice.set("totaltax", (Object)invoice.getBigDecimal("totaltax"));
        billInvoice.set("totalamount", (Object)invoice.getBigDecimal("totalamount"));
        ImcSaveServiceHelper.save(bill);
        DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callback", (Object[])new Object[]{invoice.getPkValue()});
    }

    public static boolean isFromArIssueBill(String systemSource) {
        return SYSTEM_SOURCE_FI.equals(systemSource) || SYSTEM_SOURCE_YNZY.equals(systemSource);
    }

    public static List<String> getCallBackUrlList(String systemSource) {
        DynamicObject accessConfigObject = CallbackHelperUtil.getAccessConfig(systemSource);
        return CallbackHelperUtil.getCallBackUrlList(accessConfigObject);
    }

    public static List<String> getEasSystemSource() {
        DynamicObject[] easSystems = BusinessDataServiceHelper.load((String)"invsm_callback_config", (String)PropertieUtil.getAllPropertiesSplitByComma("invsm_callback_config"), null);
        return Arrays.stream(easSystems).map(x -> x.getString("business_system_code")).collect(Collectors.toList());
    }

    public static String postEas(DynamicObject callBackConfig, String dataStr, String systemSource) {
        String loginResp;
        String baseUrl = callBackConfig.getString("url");
        String url = baseUrl + callBackConfig.getString("loginurl") + "?authPattern=BaseDB&isEncodePwd=0&dcName=" + callBackConfig.getString("tenantid") + "&language=" + callBackConfig.getString("language") + "&user=" + callBackConfig.getString("user") + "&password=" + callBackConfig.getString("appsecuret");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u8bf7\u6c42EAS login url\uff1a" + url);
        }
        if (StringUtils.isBlank((CharSequence)(loginResp = UnitTestHelper.isUnitTest() ? "id" : HttpClientUtils.get((String)url, null, (int)60000, (int)60000)))) {
            LOGGER.info("\u8bf7\u6c42EAS\u767b\u5f55\u8fd4\u56de\u4e3a\u7a7a");
            return loginResp;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u8bf7\u6c42EAS login response\uff1a" + loginResp);
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)loginResp);
            if (0 == jsonObject.getInteger("errCode")) {
                JSONObject tokenJSON = JSON.parseObject((String)jsonObject.getString("data"));
                String apiUrl = baseUrl + callBackConfig.getString("apiurl") + "?token=" + tokenJSON.getString("token");
                try {
                    LOGGER.info("\u8bf7\u6c42EAS api request url:\n" + apiUrl);
                    LOGGER.info("\u8bf7\u6c42EAS api request data:\n" + dataStr);
                    int callBackTimeOut = SendCallBackHelper.getCallBackTimeOut();
                    String returnDataStr = HttpUtil.doPostJson(apiUrl, null, dataStr, callBackTimeOut, callBackTimeOut);
                    LOGGER.info("\u8bf7\u6c42EAS api response:" + returnDataStr);
                    return returnDataStr;
                }
                catch (Exception e) {
                    LOGGER.error("\u8bf7\u6c42EAS sendApi data Exception ", (Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56de\u8c03\u4e1a\u52a1\u7f16\u7801[%1$s]\u5bf9\u5e94\u7684EAS\u7cfb\u7edf\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"CallbackHelperUtil_46", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource, e.getMessage()));
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u6743\u767b\u5f55\u4e1a\u52a1\u7f16\u7801[%1$s]\u5bf9\u5e94\u7684EAS\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"CallbackHelperUtil_47", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource, jsonObject.getString("errMsg")));
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u6743\u767b\u5f55\u4e1a\u52a1\u7f16\u7801[%1$s]\u5bf9\u5e94\u7684EAS\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"CallbackHelperUtil_47", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource, e.getMessage()));
        }
    }

    public static void checkInvsmCallBackConfig(DynamicObject object) {
        String systemSource = object.getString("business_system_code");
        String baseUrl = object.getString("url");
        String tenantId = object.getString("tenantid");
        String user = object.getString("user");
        String appSecuret = object.getString("appsecuret");
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u521d\u59cb\u5316\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]\u5bf9\u5e94\u7684EAS\u56de\u8c03\u914d\u7f6eurl\u53c2\u6570", (String)"CallbackHelperUtil_31", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource));
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u521d\u59cb\u5316\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]\u5bf9\u5e94\u7684EAS\u56de\u8c03\u914d\u7f6etenantId\u53c2\u6570", (String)"CallbackHelperUtil_32", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource));
        }
        if (StringUtils.isEmpty((CharSequence)user)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u521d\u59cb\u5316\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]\u5bf9\u5e94\u7684EAS\u56de\u8c03\u914d\u7f6euser\u53c2\u6570", (String)"CallbackHelperUtil_33", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource));
        }
        if (StringUtils.isEmpty((CharSequence)appSecuret)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u521d\u59cb\u5316\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[%s]\u5bf9\u5e94\u7684EAS\u56de\u8c03\u914d\u7f6eappSecuret\u53c2\u6570", (String)"CallbackHelperUtil_34", (String)"imc-bdm-common", (Object[])new Object[0]), systemSource));
        }
    }

    private static List<String> getCallBackUrlList(DynamicObject accessConfigObject) {
        if (null == accessConfigObject) {
            return null;
        }
        LOGGER.info(String.format("CallbackHelperUtil sendCallbackMessage conObj:%s", SerializationUtils.toJsonString((Object)accessConfigObject)));
        ArrayList<String> urlList = new ArrayList<String>(3);
        String callbackUrl1 = accessConfigObject.getString("callback_url");
        String callbackUrl2 = accessConfigObject.getString("callback_url_two");
        String callbackUrl3 = accessConfigObject.getString("callback_url_thr");
        if (StringUtils.isNotBlank((CharSequence)callbackUrl1)) {
            urlList.add(callbackUrl1);
        }
        if (StringUtils.isNotBlank((CharSequence)callbackUrl2)) {
            urlList.add(callbackUrl2);
        }
        if (StringUtils.isNotBlank((CharSequence)callbackUrl3)) {
            urlList.add(callbackUrl3);
        }
        return urlList;
    }

    public static DynamicObject getAccessConfig(String systemSource) {
        QFilter filter = new QFilter("code", "=", (Object)systemSource).and("is_valid", "!=", (Object)"0");
        String selFields = PropertieUtil.getAllPropertiesSplitByComma(BUSINESS_SYSTEM_CONFIG, true);
        DynamicObject conObj = BusinessDataServiceHelper.loadSingle((String)BUSINESS_SYSTEM_CONFIG, (String)selFields, (QFilter[])filter.toArray());
        if (null == conObj) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801%s\u672a\u627e\u5230\u7b2c\u4e09\u65b9\u63a5\u5165\u914d\u7f6e", systemSource));
            }
            return null;
        }
        return conObj;
    }

    public static DynamicObject pushCallBackLogToMQ(CallBackProcessVo processVo) {
        DynamicObject callbackDynamic = CallBackLogHelper.addCallbackLog(processVo);
        DynamicObject invoiceDynamicObject = processVo.getInvoice();
        if (null == callbackDynamic) {
            LOGGER.info("\u53d1\u7968\u53f7\uff1a" + invoiceDynamicObject.getString("invoiceno") + "\u751f\u6210\u56de\u8c03\u4fe1\u606f\u8bb0\u5f55\u5931\u8d25\uff0c\u4e0d\u56de\u8c03");
            return null;
        }
        CallbackLogVo callbackLogVo = DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, callbackDynamic);
        MqPublishUtils.publish("imc", "imc.sim.api_queue", JSON.toJSONString((Object)callbackLogVo));
        LOGGER.info("\u53d1\u7968\u56de\u8c03 " + invoiceDynamicObject.getString("invoiceno") + "\u56de\u8c03\u6d88\u606f\u53d1\u9001\u6210\u529f");
        return callbackDynamic;
    }

    public static boolean isAllInv(DynamicObject invObj) {
        boolean isRedInfo = invObj.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && InvoiceUtils.isSpecialInvoice(invObj.getString("invoicetype"));
        QFilter filter = new QFilter("tbillid", "=", (Object)invObj.getLong("id"));
        DynamicObject[] relationObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])filter.toArray());
        if (relationObjs.length == 0) {
            DynamicObject obj;
            if (IssueType.BLUE_INVOICE.getTypeCode().equals(invObj.getString("issuetype"))) {
                return false;
            }
            if (isRedInfo) {
                obj = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)"", (QFilter[])new QFilter("orderno", "=", (Object)invObj.getString("orderno")).toArray());
            } else {
                QFilter qFilter = new QFilter("invoicecode", "=", (Object)invObj.getString("originalinvoicecode")).and("invoiceno", "=", (Object)invObj.getString("originalinvoiceno"));
                obj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilter.toArray());
            }
            if (obj == null) {
                return false;
            }
            filter = new QFilter("tbillid", "=", obj.getPkValue());
            relationObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])filter.toArray());
            if (relationObjs.length == 0) {
                return false;
            }
        }
        ArrayList billIdList = new ArrayList(relationObjs.length);
        Arrays.stream(relationObjs).forEach(b -> billIdList.add(b.getLong("sbillid")));
        if (billIdList.isEmpty()) {
            return false;
        }
        QFilter rFilter = new QFilter("sbillid", "in", billIdList);
        DynamicObject[] rInvObjs = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])rFilter.toArray());
        if (null == rInvObjs || rInvObjs.length <= 0) {
            return false;
        }
        List invIdList = Stream.of(rInvObjs).map(o -> o.getLong("tbillid")).distinct().collect(Collectors.toList());
        if (invIdList.isEmpty()) {
            return false;
        }
        if (!isRedInfo) {
            QFilter invFilter = new QFilter("id", "in", invIdList).and("issuestatus", "=", (Object)"0");
            DynamicObject[] invObjs = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"id", (QFilter[])invFilter.toArray());
            if (null == invObjs || invObjs.length <= 0) {
                return false;
            }
            return invObjs.length == invIdList.size();
        }
        QFilter invFilter = new QFilter("id", "in", invIdList).and("status", "=", (Object)"4").and("orderno", "!=", (Object)invObj.getString("orderno"));
        DynamicObject[] invObjs = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"id", (QFilter[])invFilter.toArray());
        return invIdList.size() == invObjs.length + 1;
    }

    private static boolean sendCallBackMsgBOTP(DynamicObject object, String businessSystemCode, String businessType) {
        return CallbackHelperUtil.sendCallBackMsgBOTP(object, businessSystemCode, businessType, true);
    }

    public static boolean sendCallBackMsgBOTP(DynamicObject object, String businessSystemCode, String businessType, boolean isSuccess) {
        try {
            CallBackProcessVo process = new CallBackProcessVo(object, businessSystemCode, businessType, "");
            DynamicObject callbackDynamic = CallBackLogHelper.addCallbackLog(process, isSuccess);
            if (null == callbackDynamic) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("\u53d1\u7968\u53f7\uff1a" + object.getString("invoiceno") + "\u751f\u6210\u56de\u8c03\u4fe1\u606f\u5931\u8d25\uff0c\u4e0d\u56de\u8c03");
                }
                return false;
            }
            CallbackLogVo callbackLogVo = DynamicObjectUtil.dynamicObject2Bean(CallbackLogVo.class, callbackDynamic);
            MqPublishUtils.publish("imc", "imc.sim.api_queue", JSON.toJSONString((Object)callbackLogVo));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("sendCallBackMsg:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String convertInvoiceType(String imcInvoiceType) {
        if (StringUtils.isBlank((CharSequence)imcInvoiceType)) {
            return "";
        }
        String baseCodeByInvoiceTypeCode = InvoiceType.getBaseCodeByInvoiceTypeCode(imcInvoiceType);
        return baseCodeByInvoiceTypeCode == null ? "" : baseCodeByInvoiceTypeCode;
    }

    public static String convertInvStatus(Integer currStatus) {
        String invStatus = "0";
        if (currStatus == 0) {
            invStatus = "0";
        }
        if (currStatus == 3) {
            invStatus = "3";
        }
        if (currStatus == 6) {
            invStatus = "2";
        }
        return invStatus;
    }

    public static boolean isNeedCallBack(DynamicObject invoice) {
        String systemSource = invoice.getString("systemsource");
        return StringUtils.isNotEmpty((CharSequence)systemSource) && !"Kingdee_Excel".equals(systemSource) || "12".equals(invoice.getString("buyertype")) || "1".equals(ImcConfigUtil.getValue(CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO));
    }

    public static boolean isAutoIssue(long orgId, String orderNo, String result) {
        try {
            String[] failReasonCodeArr;
            DynamicObject issueConfig;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u5f00\u59cb\u5224\u65ad\u662f\u5426\u5931\u8d25\u81ea\u52a8\u91cd\u5f00\uff0c\u7ec4\u7ec7id\u662f[%s]\uff0c\u6d41\u6c34\u53f7\u662f[%s]\uff0c\u5931\u8d25\u539f\u56e0\u662f[%s]", orgId, orderNo, result));
            }
            if ((issueConfig = QueryServiceHelper.queryOne((String)"sim_auto_issue_config", (String)"reason", (QFilter[])new QFilter("useorg", "=", (Object)orgId).toArray())) == null) {
                return false;
            }
            String fail = GBKUtils.cutGBKString(result, 200);
            String failReasonCodes = issueConfig.getString("reason");
            Map<String, String> simAutoIssueConfig = ImcConfigUtil.getValue("sim_auto_issue_config");
            for (String failReasonCode : failReasonCodeArr = failReasonCodes.split(",")) {
                Pattern bankNameCompile;
                Matcher matcher;
                String failReason = simAutoIssueConfig.get(failReasonCode);
                if (StringUtils.isBlank((CharSequence)failReason)) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u5f00\u59cb\u5224\u65ad\u662f\u5426\u5931\u8d25\u81ea\u52a8\u91cd\u5f00\uff0c\u5931\u8d25\u539f\u56e0\u6b63\u5219\u662f[%s]", failReason));
                }
                if (!(matcher = (bankNameCompile = Pattern.compile('^' + failReason + '$')).matcher(fail)).find()) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u5339\u914d\u5931\u8d25\u81ea\u52a8\u91cd\u5f00\u6210\u529f\uff0c\u7ec4\u7ec7id\u662f[%s]\uff0c\u6d41\u6c34\u53f7\u662f[%s]\uff0c\u5931\u8d25\u539f\u56e0\u662f[%s]", orgId, orderNo, result));
                }
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u91cd\u5f00\u5931\u8d25\uff0c\u7ec4\u7ec7id\u662f[%s]\uff0c\u6d41\u6c34\u53f7\u662f[%s]\uff0c\u5931\u8d25\u539f\u56e0\u662f[%s]", orgId, orderNo, result));
        }
        return false;
    }

    public static boolean isIssuedCallBack(DynamicObject invoiceDynamicObject, String systemSourceCallbackType) {
        return InvoiceUtils.isPaperInvoice(invoiceDynamicObject.getString("invoicetype")) || !CallBackTypeEnum.AFTER_PDF.getCode().equals(systemSourceCallbackType);
    }

    public static boolean isAllOrgAutoIssue(DynamicObject invoice, String errorMsg) {
        try {
            String configValue = ImcConfigUtil.getValue(CacheKeyEnum.SIM_ALL_AUTO_ISSUE_CONFIG.getConfigType(), CacheKeyEnum.SIM_ALL_AUTO_ISSUE_CONFIG.getConfigKey());
            if (StringUtils.isBlank((CharSequence)configValue)) {
                return false;
            }
            JSONObject configJson = JSONObject.parseObject((String)configValue);
            JSONArray all = configJson.getJSONArray("all");
            if (null == all) {
                return false;
            }
            Map<String, String> issueConfigMap = ImcConfigUtil.getValue("sim_auto_issue_config");
            for (Object o : all) {
                String[] reasons;
                JSONObject json = (JSONObject)o;
                if (StringUtils.isNotBlank((CharSequence)json.getString("salertaxno")) && !json.getString("salertaxno").equals(invoice.getString("salertaxno"))) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)json.getString("buyertaxno")) && !json.getString("buyertaxno").equals(invoice.getString("buyertaxno"))) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)json.getString("issuesource")) && !json.getString("issuesource").equals(invoice.getString("issuesource"))) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)json.getString("buyertype")) && !json.getString("buyertype").equals(invoice.getString("buyertype"))) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)json.getString("invoicetype")) && !json.getString("invoicetype").equals(invoice.getString("invoicetype"))) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)json.getString("systemsource")) && !json.getString("systemsource").equals(invoice.getString("systemsource"))) {
                    return false;
                }
                String autoissuereason = json.getString("autoissuereason");
                for (String reasonKey : reasons = autoissuereason.split(",")) {
                    String reasonValue = issueConfigMap.get(reasonKey);
                    if (StringUtils.isBlank((CharSequence)reasonValue) || !errorMsg.contains(reasonValue)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("autoConfigError", (Throwable)e);
        }
        return false;
    }

    public static void sendVehicleCallbackMessage(DynamicObject invoice, String systemSource, String businessType) {
        DynamicObject callBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)"url", (QFilter[])new QFilter("business_system_code", "=", (Object)systemSource).toArray());
        if (callBackConfig != null) {
            CallbackHelperUtil.pushCallBackLogToMQ(new CallBackProcessVo(invoice, systemSource, businessType, ResManager.loadKDString((String)"EAS\u63a8\u5355", (String)"CallbackHelperUtil_20", (String)"imc-bdm-common", (Object[])new Object[0])));
            return;
        }
        List<Object> urlList = new ArrayList<String>(4);
        if ("XKQJ".equals(systemSource)) {
            urlList.add("\u661f\u7a7a\u65d7\u8230\u7248");
        } else {
            urlList = CallbackHelperUtil.getCallBackUrlList(systemSource);
        }
        if (null == urlList || urlList.size() == 0) {
            return;
        }
        for (String string : urlList) {
            LOGGER.info("\u53d1\u7968\u63a5\u53e3\u56de\u8c03 \u5f00\u59cb\u53d1\u9001->" + invoice.getString("invoiceno"));
            CallbackHelperUtil.pushCallBackLogToMQ(new CallBackProcessVo(invoice, systemSource, businessType, string));
        }
    }

    public static void sendVehicleErrorCallback(DynamicObject invoice) {
        if ("0".equals(ImcConfigUtil.getValue(CacheKeyEnum.SIM_ERROR_CALLBACK))) {
            return;
        }
        String systemSource = invoice.getString("systemsource");
        String errorMsg = invoice.getString("result");
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38", (String)"CallbackHelperUtil_48", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        errorMsg = GBKUtils.cutGBKString(errorMsg, 200);
        LOGGER.info(String.format("sendErrorCallbackMessage %s %s", systemSource, errorMsg));
        try {
            List<Object> callBackUrlList = new ArrayList<String>(4);
            if ("XKQJ".equals(systemSource)) {
                callBackUrlList.add("XKQJ");
            } else {
                callBackUrlList = CallbackHelperUtil.getCallBackUrlList(invoice.getString("systemsource"));
            }
            if (callBackUrlList == null || callBackUrlList.isEmpty()) {
                return;
            }
            String businessType = OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode();
            for (String string : callBackUrlList) {
                SendCallBackHelper.normalExecuteErrorCallBack(errorMsg, invoice, businessType, systemSource, string);
            }
        }
        catch (Exception e) {
            LOGGER.info("sendErrorCallbackMessage response error" + e.getMessage());
        }
    }
}

