/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.ShowTipsConstant;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.ViewUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquipmentUtil {
    private static final Log logger = LogFactory.getLog(EquipmentUtil.class);

    public static Map<String, String> getBindDevList(DynamicObject orgDynamicObject, String invoiceType) {
        DynamicObject[] equipmentDynamicObjectsByOrg;
        HashMap<String, String> devMap = new HashMap<String, String>();
        for (DynamicObject equipment : equipmentDynamicObjectsByOrg = EquipmentUtil.getEquipmentDynamicObjectsByOrg(orgDynamicObject, true)) {
            if (!"1".equals(equipment.getString("authstatus"))) continue;
            String jqbh = equipment.getString("equipmentno");
            String equipmentnoAndName = equipment.getString("equipmentname") + " | " + jqbh;
            if (invoiceType != null) {
                String[] split;
                for (String s : split = equipment.getString("invoicetypes").split(",")) {
                    if (!invoiceType.equals(s)) continue;
                    devMap.put(equipmentnoAndName, jqbh);
                }
                continue;
            }
            devMap.put(equipmentnoAndName, jqbh);
        }
        return devMap;
    }

    public static void checkEquipment(BaseInvoice invoice, String taxNo) {
        DynamicObject equipment;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("checkEquipment_devNo_%s_taxNo_%s", invoice.getJqbh(), taxNo));
        }
        if ((equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo(invoice.getJqbh(), taxNo)) == null) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7%1$s\u4e0d\u5b58\u5728\u8bbe\u5907\u7f16\u53f7%2$s", (String)"EquipmentUtil_5", (String)"imc-bdm-common", (Object[])new Object[0]), taxNo, invoice.getJqbh()));
        }
        if ("0".equals(equipment.getString("authstatus"))) {
            throw new MsgException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u8fd8\u672a\u6388\u6743", (String)"EquipmentUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]), invoice.getJqbh()));
        }
        if ("8".equals(equipment.getString("equipmenttype")) && kd.bos.util.StringUtils.isBlank((String)invoice.getTerminalno()) && InvoiceUtils.isPaperInvoice(invoice.getInvoicetype())) {
            throw new MsgException(ResManager.loadKDString((String)"\u767e\u671b\u670d\u52a1\u5668\u5f00\u7968\u7c7b\u578b\uff0c\u7ec8\u7aef\u53f7\u5fc5\u586b", (String)"EquipmentUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        invoice.setIssuesource(equipment.getString("equipmenttype"));
    }

    public static void bindDevNoByOrgNotDefault(AbstractFormPlugin formPlugin, long orgId, String propertyName, String choosedJqbh) {
        DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject(orgId);
        Map<String, String> bindDevMap = EquipmentUtil.getBindDevList(orgDynamicObject, null);
        ViewUtil.setDropDownViewData(formPlugin, propertyName, bindDevMap);
    }

    public static void initEquipmentAndTerminal(AbstractFormPlugin formPlugin, long orgId, String taxno, String jqbhPropertyName, String terminalPropertyName, boolean isInitLoad) {
        SaleInfo saleInfo;
        boolean devNoEnable;
        String jqbh = (String)formPlugin.getView().getModel().getValue(jqbhPropertyName);
        String terminalNo = (String)formPlugin.getView().getModel().getValue("terminalno");
        if (isInitLoad && kd.bos.util.StringUtils.isEmpty((String)jqbh) && (devNoEnable = EquipmentHelper.isEnable((saleInfo = TaxUtils.getSaleInfoByOrg(orgId)).getSaleTaxNo(), saleInfo.getDefaultDev()))) {
            jqbh = saleInfo.getDefaultDev();
            terminalNo = saleInfo.getDefaultTerminal();
        }
        EquipmentUtil.bindDevNoByOrgNotDefault(formPlugin, orgId, jqbhPropertyName, jqbh);
        EquipmentUtil.showTerminalNo(formPlugin, jqbh, taxno, terminalPropertyName, isInitLoad);
        formPlugin.getView().getModel().setValue(jqbhPropertyName, (Object)jqbh);
        formPlugin.getView().getModel().setValue("terminalno", (Object)terminalNo);
    }

    public static void showTerminalNo(AbstractFormPlugin formPlugin, String defaultEquipment, String taxNo, String pagePropertyName, boolean isInitLoad) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)defaultEquipment)) {
            DynamicObject[] equipmentSelectArr = EquipmentUtil.getEquipmentListByDevNo(defaultEquipment, taxNo);
            if (equipmentSelectArr != null && equipmentSelectArr.length > 0) {
                if ("8".equals(equipmentSelectArr[0].getString("equipmenttype"))) {
                    HashMap<String, String> terminalMap = new HashMap<String, String>(4);
                    for (DynamicObject object : equipmentSelectArr) {
                        terminalMap.put(object.getString("terminalno"), object.getString("terminalno"));
                    }
                    ViewUtil.setDropDownViewData(formPlugin, pagePropertyName, terminalMap);
                    if (equipmentSelectArr.length == 1) {
                        formPlugin.getView().getModel().setValue(pagePropertyName, (Object)equipmentSelectArr[0].getString("terminalno"));
                    } else if (isInitLoad) {
                        formPlugin.getView().getModel().setValue(pagePropertyName, formPlugin.getView().getModel().getValue(pagePropertyName));
                    } else {
                        formPlugin.getView().getModel().setValue(pagePropertyName, (Object)"");
                    }
                    formPlugin.getView().setVisible(Boolean.TRUE, new String[]{pagePropertyName});
                } else {
                    formPlugin.getView().setVisible(Boolean.FALSE, new String[]{pagePropertyName});
                }
            }
        } else {
            formPlugin.getView().getModel().setValue(pagePropertyName, (Object)"");
            formPlugin.getView().setVisible(Boolean.FALSE, new String[]{pagePropertyName});
        }
    }

    public static void showOrgEditTerminalNo(AbstractFormPlugin formPlugin, String defaultEquipment, String taxno, String pagePropertyName, DynamicObject org, boolean isInitLoad) {
        if (!kd.bos.util.StringUtils.isEmpty((String)defaultEquipment)) {
            DynamicObject[] equipmentSelectArr = EquipmentUtil.getEquipmentListByDevNo(defaultEquipment, taxno);
            if (equipmentSelectArr != null && equipmentSelectArr.length > 0) {
                if ("8".equals(equipmentSelectArr[0].getString("equipmenttype"))) {
                    HashMap<String, String> terminalMap = new HashMap<String, String>(4);
                    for (DynamicObject object : equipmentSelectArr) {
                        if ("1".equals(org.getString("enterprisemainorg"))) {
                            terminalMap.put(object.getString("terminalno"), object.getString("terminalno"));
                            continue;
                        }
                        if (!org.getString("devlist_tag").contains(String.valueOf(object.getPkValue()))) continue;
                        terminalMap.put(object.getString("terminalno"), object.getString("terminalno"));
                    }
                    ViewUtil.setDropDownViewData(formPlugin, pagePropertyName, terminalMap);
                    if (equipmentSelectArr.length == 1) {
                        formPlugin.getView().getModel().setValue(pagePropertyName, (Object)equipmentSelectArr[0].getString("terminalno"));
                    } else if (isInitLoad) {
                        formPlugin.getView().getModel().setValue(pagePropertyName, formPlugin.getView().getModel().getValue(pagePropertyName));
                    } else {
                        formPlugin.getView().getModel().setValue(pagePropertyName, (Object)"");
                    }
                    formPlugin.getView().setVisible(Boolean.TRUE, new String[]{pagePropertyName});
                } else {
                    formPlugin.getView().getModel().setValue(pagePropertyName, (Object)"");
                    formPlugin.getView().setVisible(Boolean.FALSE, new String[]{pagePropertyName});
                }
            }
        } else {
            formPlugin.getView().getModel().setValue(pagePropertyName, (Object)"");
            formPlugin.getView().setVisible(Boolean.FALSE, new String[]{pagePropertyName});
        }
    }

    public static void bindDevNoByOrg(AbstractFormPlugin formPlugin, String propertyName, Long orgId, String invoiceType) {
        try {
            DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject(orgId);
            Map<String, String> bindDevMap = EquipmentUtil.getBindDevList(orgDynamicObject, invoiceType);
            ViewUtil.setDropDownViewData(formPlugin, propertyName, bindDevMap);
            String defaultDev = orgDynamicObject.getString("defaultdev");
            if (!kd.bos.util.StringUtils.isEmpty((String)defaultDev) && !bindDevMap.isEmpty()) {
                for (Map.Entry<String, String> entry : bindDevMap.entrySet()) {
                    if (entry.getValue().equals(defaultDev)) {
                        formPlugin.getView().getModel().setValue(propertyName, (Object)entry.getValue());
                    }
                    if (!StringUtils.isBlank((CharSequence)defaultDev)) continue;
                    defaultDev = entry.getValue();
                    formPlugin.getView().getModel().setValue(propertyName, (Object)entry.getValue());
                }
            } else {
                formPlugin.getView().getModel().setValue(propertyName, null);
            }
        }
        catch (KDBizException e) {
            logger.error((Object)"bindDevNoFailed", (Throwable)e);
        }
    }

    public static void bindDefaultDev(AbstractFormPlugin formPlugin, String propertyName, Long orgId, String defaultDev) {
        block6: {
            try {
                DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject(orgId);
                Map<String, String> bindDevMap = EquipmentUtil.getBindDevList(orgDynamicObject, null);
                ViewUtil.setDropDownViewData(formPlugin, propertyName, bindDevMap);
                if (!kd.bos.util.StringUtils.isEmpty((String)defaultDev) && !bindDevMap.isEmpty()) {
                    for (Map.Entry<String, String> entry : bindDevMap.entrySet()) {
                        if (!entry.getValue().equals(defaultDev)) continue;
                        formPlugin.getView().getModel().setValue(propertyName, (Object)defaultDev);
                    }
                } else {
                    if (bindDevMap.size() == 1) {
                        formPlugin.getView().getModel().setValue(propertyName, bindDevMap.values().toArray()[0]);
                        return;
                    }
                    formPlugin.getView().getModel().setValue(propertyName, null);
                }
            }
            catch (KDBizException e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error((Object)"bindDevNoFailed", (Throwable)e);
            }
        }
    }

    public static DynamicObject getDefaultDev(Long orgId) {
        DynamicObject orgObj = TaxUtils.getOrgDynamicObject(orgId);
        return EquipmentUtil.getDefaultEquipmentByOrgDynamicObject(orgObj);
    }

    public static DynamicObject getDefaultEquipmentByOrgDynamicObject(DynamicObject orgObj) {
        String orgDefaultDevNo = orgObj.getString("defaultdev");
        if (!kd.bos.util.StringUtils.isEmpty((String)orgDefaultDevNo)) {
            return BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_tax_equipment"), (QFilter[])new QFilter("equipmentno", "=", (Object)orgDefaultDevNo).and(EquipmentHelper.getEnableFilter()).toArray());
        }
        return EquipmentUtil.randomGetEquipmentByOrg(orgObj);
    }

    public static DynamicObject randomGetEquipmentByOrg(DynamicObject orgObj) {
        DynamicObject[] objs = EquipmentUtil.getEquipmentDynamicObjectsByOrg(orgObj);
        if (objs.length > 0) {
            for (DynamicObject obj : objs) {
                if (!"1".equals(obj.getString("authstatus"))) continue;
                return obj;
            }
        }
        return null;
    }

    public static String getDefaultDevNoByOrg(Long orgId) {
        DynamicObject defaultDev = EquipmentUtil.getDefaultDev(orgId);
        return defaultDev == null ? "" : defaultDev.getString("equipmentno");
    }

    public static DynamicObject getCommonEquipment(String devNo, String taxNo, String terminalNo) {
        String equipmentType;
        DynamicObject[] equipmentArr = EquipmentUtil.getEquipmentListByDevNo(devNo, taxNo);
        DynamicObject equipment = null;
        if (equipmentArr != null && equipmentArr.length > 0 && "8".equals(equipmentType = (equipment = equipmentArr[0]).getString("equipmenttype"))) {
            equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNoAndTerminalNo(devNo, taxNo, terminalNo);
        }
        return equipment;
    }

    public static DynamicObject getEquipmentDynamicObjectByDevNo(String devNo, String taxNo) {
        QFilter qFilter = new QFilter("equipmentno", "=", (Object)devNo);
        qFilter.and("epinfo.number", "=", (Object)taxNo);
        return BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_tax_equipment", true), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] getEquipmentListByDevNo(String devNo, String taxNo) {
        QFilter qFilter = new QFilter("equipmentno", "=", (Object)devNo);
        qFilter.and("epinfo.number", "=", (Object)taxNo);
        return BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)String.join((CharSequence)",", "id", "equipmenttype", "equipmentno", "equipmentname", "equipmentpwd", "conntype", "defaultequipment", "authstatus", "permissionid", "terminalno"), (QFilter[])qFilter.toArray());
    }

    public static List<String> getTerminanMapListByDevNo(String devNo, String taxNo) {
        DynamicObject[] equipmentArr = EquipmentUtil.getEquipmentListByDevNo(devNo, taxNo);
        return Stream.of(equipmentArr).map(e -> e.getString("terminalno")).collect(Collectors.toList());
    }

    public static DynamicObject getEquipmentDynamicObjectByDevNoAndTerminalNo(String devNo, String taxNo, String terminalNo) {
        QFilter equipFilter = new QFilter("equipmentno", "=", (Object)devNo);
        equipFilter.and("epinfo.number", "=", (Object)taxNo);
        equipFilter.and("terminalno", "=", (Object)terminalNo);
        return BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)String.join((CharSequence)",", "id", "equipmenttype", "equipmentno", "equipmentname", "equipmentpwd", "conntype", "defaultequipment", "authstatus", "permissionid", "terminalno"), (QFilter[])equipFilter.toArray());
    }

    public static DynamicObject[] getEquipmentDynamicObjectsByOrg(DynamicObject orgDynamicObject) {
        return EquipmentUtil.getEquipmentDynamicObjectsByOrg(orgDynamicObject, true);
    }

    public static DynamicObject[] getEquipmentDynamicObjectsByOrg(DynamicObject orgDynamicObject, boolean isExcludeDisable) {
        String devList = orgDynamicObject.getString("devlist_tag");
        logger.info((Object)("getEquipmentDynamicObjectsByOrg: " + devList));
        List<String> asList = Arrays.asList(devList.split(","));
        if (kd.bos.util.StringUtils.isEmpty((String)asList.get(0))) {
            return new DynamicObject[0];
        }
        QFilter equipFilter = new QFilter("id", "in", (Object)asList.stream().filter(kd.bos.util.StringUtils::isNotEmpty).map(Long::parseLong).toArray());
        if (isExcludeDisable) {
            equipFilter = equipFilter.and(EquipmentHelper.getEnableFilter());
        }
        return BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"id,equipmenttype,equipmentno,equipmentname,equipmentpwd,conntype,defaultequipment,authstatus,permissionid,invoicetypes,payee,reviewer,drawer,fjh,terminalno", (QFilter[])equipFilter.toArray());
    }

    public static DynamicObject getRandomActiveEquipmentByOrgDynamicObject(DynamicObject orgObj) {
        DynamicObject[] objs = EquipmentUtil.getActiveEquipmentDynamicObjectsByOrg(orgObj, null);
        if (objs.length > 0) {
            int random = BigDecimalUtil.transDecimal(RandomString.nextString(4, true, true)).intValue();
            int idx = random % objs.length;
            return objs[idx];
        }
        return null;
    }

    public static DynamicObject getRandomActiveEquipmentByOrgDynamicObject(DynamicObject orgObj, String equipmenttype) {
        return EquipmentUtil.getRandomActiveEquipmentByOrgDynamicObject(orgObj, equipmenttype, null);
    }

    public static DynamicObject getRandomActiveEquipmentByOrgDynamicObject(DynamicObject orgObj, String equipmenttype, String invocieType) {
        DynamicObject[] objs = EquipmentUtil.getActiveEquipmentDynamicObjectsByOrg(orgObj, equipmenttype);
        if (objs.length > 0) {
            DynamicObject obj;
            if (invocieType != null && (obj = EquipmentUtil.getRandomActiveEquipmentByStock(objs, invocieType)) != null) {
                return obj;
            }
            int random = BigDecimalUtil.transDecimal(RandomString.nextString(4, true, true)).intValue();
            int idx = random % objs.length;
            return objs[idx];
        }
        return null;
    }

    private static DynamicObject getRandomActiveEquipmentByStock(DynamicObject[] objs, String invoiceType) {
        ArrayList<String> eqNoList = new ArrayList<String>(objs.length);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(objs.length);
        for (DynamicObject obj : objs) {
            eqNoList.add(obj.getString("equipmentno"));
            map.put(obj.getString("equipmentno"), obj);
        }
        QFilter filter = new QFilter("equipmentno", "in", eqNoList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_stock_manage", (String)"einvoicestock,equipmenttype,especialinvoicestock,invoicestock,specialinvoicestock,equipmentno", (QFilter[])filter.toArray(), (String)"id");
        String field = null;
        if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "invoicestock";
        } else if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "specialinvoicestock";
        } else if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "einvoicestock";
        } else if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
            field = "especialinvoicestock";
        }
        if (field == null) {
            return null;
        }
        int total = 0;
        for (DynamicObject obj : collect) {
            total += obj.getInt(field);
        }
        if (total <= 0) {
            return null;
        }
        int random = BigDecimalUtil.transDecimal(RandomString.nextString(8, true, true)).intValue();
        int idx = random % total;
        total = 0;
        for (DynamicObject obj : collect) {
            if ((total += obj.getInt(field)) < idx) continue;
            return (DynamicObject)map.get(obj.getString("equipmentno"));
        }
        return null;
    }

    public static DynamicObject[] getActiveEquipmentDynamicObjectsByOrg(DynamicObject orgDynamicObject, String equipmenttype) {
        String devList = orgDynamicObject.getString("devlist_tag");
        logger.info((Object)("getEquipmentDynamicObjectsByOrg: " + devList));
        List<String> asList = Arrays.asList(devList.split(","));
        if (kd.bos.util.StringUtils.isEmpty((String)asList.get(0))) {
            return new DynamicObject[0];
        }
        QFilter equipFilter = new QFilter("id", "in", (Object)asList.stream().filter(kd.bos.util.StringUtils::isNotEmpty).map(Long::parseLong).toArray());
        equipFilter = equipFilter.and(EquipmentHelper.getEnableFilter());
        if (!kd.bos.util.StringUtils.isEmpty((String)equipmenttype) && !"ALL".equals(equipmenttype)) {
            equipFilter = equipFilter.and("equipmenttype", "in", Arrays.asList(equipmenttype.split(",")));
        }
        equipFilter = equipFilter.and("authstatus", "=", (Object)"1");
        return BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"id,equipmenttype,equipmentno,equipmentname,equipmentpwd,conntype,defaultequipment,authstatus,permissionid,invoicetypes,payee,reviewer,drawer,fjh,terminalno", (QFilter[])equipFilter.toArray());
    }

    public static DynamicObject[] getEquipmentByOrgId(Long orgId) {
        DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObject(orgId);
        return EquipmentUtil.getEquipmentDynamicObjectsByOrg(orgDynamicObject);
    }

    public static DynamicObject getEquipmentDynamicObject(Long orgId, Object jqbh) {
        DynamicObject devDynamicObject;
        if (jqbh == null || kd.bos.util.StringUtils.isEmpty((String)jqbh.toString())) {
            devDynamicObject = EquipmentUtil.getDefaultDev(orgId);
        } else {
            QFilter equipFilter = new QFilter("equipmentno", "=", jqbh).and(EquipmentHelper.getEnableFilter());
            devDynamicObject = BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)PropertieUtil.getAllPropertiesSplitByComma("bdm_tax_equipment"), (QFilter[])equipFilter.toArray());
        }
        if (null == devDynamicObject) {
            throw new KDBizException(ShowTipsConstant.getENTERPRISE_UNBIND_DEVICE());
        }
        return devDynamicObject;
    }

    public static DynamicObject getDevByCode(Long orgId, String jqbh) {
        if (kd.bos.util.StringUtils.isBlank((String)jqbh)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a", (String)"EquipmentUtil_3", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        DynamicObject orgInfoObj = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org");
        QFilter jqbhFilter = new QFilter("equipmentno", "=", (Object)jqbh);
        QFilter epinfoFilter = new QFilter("epinfo", "=", orgInfoObj.get("epinfo.id"));
        DynamicObject devObjPk = BusinessDataServiceHelper.loadSingle((String)"bdm_tax_equipment", (String)"id", (QFilter[])new QFilter[]{jqbhFilter, epinfoFilter});
        if (null == devObjPk) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907%s\u4e0d\u5b58\u5728", (String)"EquipmentUtil_4", (String)"imc-bdm-common", (Object[])new Object[0]), jqbh));
        }
        return BusinessDataServiceHelper.loadSingle((Object)devObjPk.getPkValue(), (String)"bdm_tax_equipment");
    }
}

