/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GBKUtils {
    private static final Log LOGGER = LogFactory.getLog(GBKUtils.class);

    public static Integer getGBKLength(String content) {
        if (null == content || content.length() == 0) {
            return 0;
        }
        try {
            byte[] bs = content.getBytes("GBK");
            ByteBuffer buf = ByteBuffer.wrap(bs);
            return buf.capacity();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            return 0;
        }
    }

    public static int length(String value) {
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static void checkChinese(String value, String propertyName) {
        if (!GBKUtils.isChinese(value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\"%s\"\u53ea\u80fd\u5305\u542b\u4e2d\u6587", (String)"GBKUtils_1", (String)"imc-bdm-common", (Object[])new Object[0]), propertyName));
        }
    }

    public static boolean isChinese(String content) {
        boolean isChinese = true;
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < content.length(); ++i) {
            String temp = content.substring(i, i + 1);
            if (temp.matches(chinese)) continue;
            isChinese = false;
            break;
        }
        return isChinese;
    }

    public static boolean checkValidGbk(String content) {
        return true;
    }

    public static void CheckGBKLength(String content, String propertyName, int maxLength) {
        int gbkLength = GBKUtils.getGBKLength(content);
        if (gbkLength > maxLength) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%d\u4e2a\u5b57\u8282,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"GBKUtils_2", (String)"imc-bdm-common", (Object[])new Object[0]), propertyName, maxLength));
        }
    }

    public static void checkLength(String content, String propertyName, Integer maxLength) {
        int gbkLength = GBKUtils.length(content);
        if (gbkLength > maxLength) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%d\u4e2a\u5b57\u8282,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"GBKUtils_2", (String)"imc-bdm-common", (Object[])new Object[0]), propertyName, maxLength));
        }
    }

    public static String cutGBKString(String str, int len) {
        String cutStr;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        try {
            byte[] b = str.getBytes("GBK");
            if (b.length < len) {
                return str;
            }
            int count = 0;
            for (int i = len - 1; i >= 0 && b[i] < 0; --i) {
                ++count;
            }
            cutStr = count % 2 == 0 ? new String(b, 0, len, "GBK") : new String(b, 0, len - 1, "GBK");
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            return str;
        }
        return cutStr;
    }

    public static Integer getImageLength(String content) {
        if (null == content || content.length() == 0) {
            return 0;
        }
        int calLen = 0;
        int length = content.length();
        ArrayList list = new ArrayList();
        Collections.addAll(list, Character.valueOf('m'), Character.valueOf('w'));
        ArrayList list2 = new ArrayList();
        Collections.addAll(list2, Character.valueOf('M'), Character.valueOf('W'));
        for (int i = 0; i < length; ++i) {
            char str = content.charAt(i);
            if (str > '\u0100') {
                calLen += 20;
                continue;
            }
            if (list2.contains(Character.valueOf(str))) {
                calLen += 20;
                continue;
            }
            if (str >= 'A' && str <= 'Z') {
                calLen += 15;
                continue;
            }
            if (list.contains(Character.valueOf(str))) {
                calLen += 15;
                continue;
            }
            calLen += 10;
        }
        return calLen;
    }
}

