/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;

public class PropertieUtil {
    public static String getAllPropertiesSplitByComma(String entityName) {
        return PropertieUtil.getAllPropertiesSplitByComma(entityName, false);
    }

    public static String getAllPropertiesSplitByComma(String entityName, boolean isContainItemsAll) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection ls = type.getProperties();
        if (ls == null || ls.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IDataEntityProperty property : ls) {
            String name = property.getName();
            if (property instanceof DynamicLocaleProperty) continue;
            if (!(property instanceof EntryProp)) {
                sb.append(name).append(',');
                continue;
            }
            if (!isContainItemsAll) continue;
            EntryProp prop = (EntryProp)property;
            for (IDataEntityProperty itemProperty : prop.getItemType().getProperties()) {
                sb.append(name).append('.').append(itemProperty.getName()).append(',');
            }
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static List<String> addFieldKey(String entityName) {
        return PropertieUtil.addFieldKey(entityName, false);
    }

    public static List<String> addFieldKey(String entityName, boolean isContainItemsAll) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection ls = type.getProperties();
        ArrayList<String> fieldKeys = new ArrayList<String>(ls.size());
        for (IDataEntityProperty property : ls) {
            String name = property.getName();
            if (property instanceof DynamicLocaleProperty) continue;
            if (!(property instanceof EntryProp)) {
                fieldKeys.add(name);
                continue;
            }
            if (!isContainItemsAll) continue;
            EntryProp prop = (EntryProp)property;
            for (IDataEntityProperty itemProperty : prop.getItemType().getProperties()) {
                fieldKeys.add(name + '.' + itemProperty.getName());
            }
        }
        return fieldKeys;
    }
}

