/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.util.regex.Pattern;

public class RegexUtil {
    public static final String REGEX_FLOAT = "^(-?\\d+)(\\.\\d+)?$";
    public static final String REGEX_INTEGER = "^-?\\d+$";
    public static final String REGEX_INTEGER_ZERO = "^-?\\d+(\\.[0]+)?$";
    public static final String REGEX_FLOAT_LARGE_ZERO = "^\\d+(\\.\\d+)?$";
    public static final String REGEX_INTEGER_LARGE_ZERO = "^\\d+$";
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{5,20}$";
    public static final String REGEX_PASS_WO = "^[a-zA-Z0-9]{6,20}$";
    public static final String REGEX_MOBILE = "^(1[0-9])\\d{9}$";
    public static final String REGEX_EMAIL = "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$";
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5],{0,}$";
    public static final String REGEX_ID_CARD = "(^\\d{17}([0-9]|X|x)$)|(^\\d{15}$)";
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
    public static final String REGEX_IP_ADDR = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
    public static final String REGEX_FPDM = "^(\\d{10}|\\d{12})$";
    public static final String REGEX_ETC_FPDM = "^\\d{12}$";
    public static final String REGEX_PAPER_FPDM = "^\\d{10}$";
    public static final String REGEX_FPHM = "^\\d{8}$";
    public static final String REGEX_QDFPHM = "^\\d{20}$";
    public static final String REGEX_ALL_E_FPHM = "^\\d{20}$";
    public static final String REGEX_NUMBER = "^[0-9]*$";
    public static final String REGEX_NSRSBH = "^[a-zA-Z0-9]{8}$|^[a-zA-Z0-9]{15}$|^[a-zA-Z0-9]{17}$|^[a-zA-Z0-9]{18}$|^[a-zA-Z0-9]{20}$";
    public static final String REGEX_NSRSBH_BUYER = "^[a-zA-Z0-9]{1,20}$";
    public static final String REGEX_RED_INFO_CODE = "^\\d{16}$";
    public static final String PLATE_NO_REGEX = "([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c]{1}(([A-HJ-Z]{1}[A-HJ-NP-Z0-9]{5})|([A-HJ-Z]{1}(([DF]{1}[A-HJ-NP-Z0-9]{1}[0-9]{4})|([0-9]{5}[DF]{1})))|([A-HJ-Z]{1}[A-D0-9]{1}[0-9]{3}\u8b66)))|([0-9]{6}\u4f7f)|((([\u6caa\u7ca4\u5ddd\u4e91\u6842\u9102\u9655\u8499\u85cf\u9ed1\u8fbd\u6e1d]{1}A)|\u9c81B|\u95fdD|\u8499E|\u8499H)[0-9]{4}\u9886)|(WJ[\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u00b7\u2022]{1}[0-9]{4}[TDSHBXJ0-9]{1})|([VKHBSLJNGCE]{1}[A-DJ-PR-TVY]{1}[0-9]{5})";

    public static boolean isRedInfoCode(String infoCode) {
        return Pattern.matches(REGEX_RED_INFO_CODE, infoCode);
    }

    public static boolean isVehplate(String vehplate) {
        return Pattern.matches(PLATE_NO_REGEX, vehplate);
    }

    public static boolean isNsrsbh(String strNumber) {
        return RegexUtil.isNsrsbh(strNumber, false);
    }

    public static boolean isNsrsbh(String strNumber, boolean isBuyer) {
        if (isBuyer) {
            return Pattern.matches(REGEX_NSRSBH_BUYER, strNumber);
        }
        return Pattern.matches(REGEX_NSRSBH, strNumber);
    }

    public static boolean isNumber(String strNumber) {
        return Pattern.matches(REGEX_NUMBER, strNumber);
    }

    public static boolean isInvoiceCode(String invoiceCode) {
        return Pattern.matches(REGEX_FPDM, invoiceCode);
    }

    public static boolean isEtcInvoiceCode(String invoiceCode) {
        return Pattern.matches(REGEX_ETC_FPDM, invoiceCode);
    }

    public static boolean isPaperInvoiceCode(String invoiceCode) {
        return Pattern.matches(REGEX_PAPER_FPDM, invoiceCode);
    }

    public static boolean isInvoiceNo(String invoiceNo) {
        return Pattern.matches(REGEX_FPHM, invoiceNo);
    }

    public static boolean isAllElectricInvoiceNo(String invoiceNo) {
        return Pattern.matches("^\\d{20}$", invoiceNo);
    }

    public static boolean isAllEInvoiceNo(String invoiceNo) {
        return Pattern.matches("^\\d{20}$", invoiceNo);
    }

    public static boolean isFloatLargeZero(String floatNum) {
        return Pattern.matches(REGEX_FLOAT_LARGE_ZERO, floatNum);
    }

    public static boolean isInteger(String integer) {
        return Pattern.matches(REGEX_INTEGER, integer);
    }

    public static boolean isFloat(String floatNum) {
        return Pattern.matches(REGEX_FLOAT, floatNum);
    }

    public static boolean isIntegerLargeZero(String integer) {
        return Pattern.matches(REGEX_INTEGER_LARGE_ZERO, integer);
    }

    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    public static boolean isPassword(String password) {
        return Pattern.matches(REGEX_PASS_WO, password);
    }

    public static boolean isMobile(String mobile) {
        return Pattern.matches(REGEX_MOBILE, mobile);
    }

    public static boolean isEmail(String email) {
        return Pattern.matches(REGEX_EMAIL, email);
    }

    public static boolean isChinese(String chinese) {
        return Pattern.matches(REGEX_CHINESE, chinese);
    }

    public static boolean isIDCard(String idCard) {
        return Pattern.matches(REGEX_ID_CARD, idCard);
    }

    public static boolean isUrl(String url) {
        return Pattern.matches(REGEX_URL, url);
    }

    public static boolean isIPAddr(String ipAddr) {
        return Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }
}

