/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.dto.CallbackRequestVo;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.CallbackMcloudUtil;
import kd.imc.bdm.common.util.HttpUtil;

public class SendMsg2Erp {
    private static Log LOGGER = LogFactory.getLog(SendMsg2Erp.class);
    public static final String GET_ORDER = "GET.ORDER";
    public static final String ORDER_STATUS = "ORDER.STATUS";

    public static CallbackResponseVo send(String systemCode, String method, String data) {
        DynamicObject businessSystem = CallbackHelperUtil.getBusinessSystemByCode(systemCode);
        CallbackResponseVo callback = CallbackHelperUtil.checkBusinessSystemValid(businessSystem);
        if (!ApiErrCodeEnum.OK.getCode().equals(callback.getCode())) {
            return callback;
        }
        String url = businessSystem.getString("callback_url");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u626b\u7801\u5f00\u7968\u8bf7\u6c42\u5916\u90e8\u7cfb\u7edf\uff1aurl--\u300b%s\uff0c\u8bf7\u6c42\u65b9\u6cd5--\u300b%s,\u8bf7\u6c42\u53c2\u6570--\u300b%s", url, method, JSON.toJSONString((Object)data)));
        }
        CallbackRequestVo request = new CallbackRequestVo();
        request.setInterfaceCode(method);
        try {
            request.setData(AesUtil.getData(businessSystem, 0, data));
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff01" + e.getMessage());
            SendMsg2Erp.setMsg(callback, ApiErrCodeEnum.QR_SYSTEMERROR);
            return callback;
        }
        try {
            int callBackTimeOut = SendCallBackHelper.getCallBackTimeOut();
            data = HttpUtil.doPostJson(url, null, JSON.toJSONString((Object)request), callBackTimeOut, callBackTimeOut);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u626b\u7801\u5f00\u7968\u8bf7\u6c42\u5916\u90e8\u7cfb\u7edf\u8fd4\u56de\u6570\u636e\uff1a" + data);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u626b\u7801\u5f00\u7968\u8bf7\u6c42\u5916\u90e8\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            SendMsg2Erp.setMsg(callback, ApiErrCodeEnum.QR_GET_ORDER_ISNULL);
            return callback;
        }
        if (StringUtils.isEmpty((CharSequence)data)) {
            SendMsg2Erp.setMsg(callback, ApiErrCodeEnum.QR_GET_ORDER_ISNULL);
        } else {
            try {
                callback = (CallbackResponseVo)JSON.parseObject((String)data, CallbackResponseVo.class);
            }
            catch (Exception e) {
                SendMsg2Erp.setMsg(callback, ApiErrCodeEnum.QR_SYSTEMCODE_NOTFIND);
                return callback;
            }
        }
        return callback;
    }

    private static void setMsg(CallbackResponseVo callback, ApiErrCodeEnum apiEnum) {
        callback.setCode(apiEnum.getCode());
        callback.setMessage(apiEnum.getMsg());
    }

    public static void callBackMsg(String systemCode, String method, Object data) {
        CallbackMcloudUtil.dealInfo2ThirdSys(systemCode, JSON.toJSONString((Object)data), method, null);
    }
}

