/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.ComboEditUtil;

public class TaxRateUtil {
    private static final Set<String> eazy345 = new HashSet<String>(Arrays.asList("3%", "4%", "5%"));
    private static final Set<String> zore = new HashSet<String>(Collections.singletonList("0%"));
    private static final Set<String> eazy3 = new HashSet<String>(Collections.singletonList("3%"));
    private static final Set<String> eazy5 = new HashSet<String>(Collections.singletonList("5%"));
    private static final Set<String> eazy15 = new HashSet<String>(Collections.singletonList("1.5%"));
    private static final Set<String> all = new HashSet<String>(Arrays.asList("0%", "1%", "1.5%", "3%", "4%", "5%", "6%", "9%", "10%", "11%", "13%", "16%", "17%"));
    private static final String[] intTaxRate = new String[]{"0", "1", "1.5", "3", "4", "5", "6", "9", "10", "11", "13", "16", "17"};

    public static Set<String> setRate(String val) {
        HashSet<String> now = new HashSet<String>();
        switch (val) {
            case "\u7b80\u6613\u5f81\u6536": {
                now.addAll(eazy345);
                break;
            }
            case "\u514d\u7a0e": 
            case "\u4e0d\u5f81\u7a0e": {
                now.addAll(zore);
                break;
            }
            case "\u5148\u5f81\u540e\u9000": 
            case "100%\u5148\u5f81\u540e\u9000": 
            case "50%\u5148\u5f81\u540e\u9000": 
            case "\u8d85\u7a0e\u8d1f3%\u5373\u5f81\u5373\u9000": 
            case "\u8d85\u7a0e\u8d1f8%\u5373\u5f81\u5373\u9000": 
            case "\u8d85\u7a0e\u8d1f12%\u5373\u5f81\u5373\u9000": 
            case "\u5373\u5f81\u5373\u900030%": 
            case "\u5373\u5f81\u5373\u900050%": 
            case "\u5373\u5f81\u5373\u900070%": 
            case "\u5373\u5f81\u5373\u9000100%": 
            case "\u7a00\u571f\u4ea7\u54c1": {
                break;
            }
            case "\u63093%\u7b80\u6613\u5f81\u6536": {
                now.addAll(eazy3);
                break;
            }
            case "\u63095%\u7b80\u6613\u5f81\u6536": {
                now.addAll(eazy5);
                break;
            }
            case "\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81": {
                now.addAll(eazy15);
                break;
            }
            default: {
                now.addAll(all);
            }
        }
        return now;
    }

    public static String percent2Point(String percent) {
        String pointStr;
        try {
            pointStr = new BigDecimal(percent.substring(0, percent.length() - 1)).divide(new BigDecimal("100"), 8, 4).stripTrailingZeros().toPlainString();
        }
        catch (Exception e) {
            pointStr = "0";
        }
        return "0.1".equals(pointStr) ? "0.10" : pointStr;
    }

    public static String checkPrivilegeTypeByTaxCode(String taxCode, String privilegeType, String taxRate) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"er_taxclasscode", (String)"id, mergecode, taxrate, vatspecialmanagement", (QFilter[])new QFilter("sumitem", "=", (Object)"N").and("mergecode", "=", (Object)taxCode).toArray());
        if (obj == null) {
            return String.format(ResManager.loadKDString((String)"\u4f18\u60e0\u653f\u7b56\u4e0d\u5408\u6cd5!\u6b64\u7f16\u7801\u4e0b\u7684\u4f18\u60e0\u653f\u7b56\u4e0d\u5305\u542b%s", (String)"TaxRateUtil_13", (String)"imc-bdm-common", (Object[])new Object[0]), privilegeType);
        }
        return TaxRateUtil.checkPrivilegeType(obj.getString("vatspecialmanagement"), privilegeType, taxRate);
    }

    public static String checkPrivilegeType(String zzstsgl, String privilegeType, String taxRate) {
        taxRate = new BigDecimal(taxRate).stripTrailingZeros().toPlainString();
        if (("\u514d\u7a0e".equals(privilegeType) || "\u4e0d\u5f81\u7a0e".equals(privilegeType)) && !"0".equals(taxRate)) {
            return ResManager.loadKDString((String)"\u514d\u7a0e\u6216\u4e0d\u5f81\u7a0e\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"TaxRateUtil_14", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        if ("\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.05".equals(taxRate) && !"0.04".equals(taxRate) && !"0.03".equals(taxRate)) {
            return ResManager.loadKDString((String)"\u7b80\u6613\u5f81\u6536\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"TaxRateUtil_15", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        if ("\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81".equals(privilegeType) && !"0.015".equals(taxRate)) {
            return ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u5f81,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"TaxRateUtil_16", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        if ("\u63095%\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.05".equals(taxRate)) {
            return ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"TaxRateUtil_17", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        if ("\u63093%\u7b80\u6613\u5f81\u6536".equals(privilegeType) && !"0.03".equals(taxRate)) {
            return ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536,\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"TaxRateUtil_18", (String)"imc-bdm-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static void fillPrivilegeType(String zzstsgl, ComboEdit comboEdit) {
        Map<String, String> zzstsglMap = null;
        if (StringUtils.isNotEmpty((CharSequence)zzstsgl)) {
            String[] arr = zzstsgl.split("\u3001");
            zzstsglMap = Stream.of(arr).collect(Collectors.toMap(k -> k, v -> v, (v1, v2) -> v2));
        }
        ComboEditUtil.fillComboEdit(comboEdit, zzstsglMap, true);
    }

    public static String okTaxRate(String currTaxRate) {
        String rate = TaxRateUtil.realOkTaxRate(currTaxRate);
        if ("0.1".equals(rate)) {
            rate = rate + '0';
        }
        return rate;
    }

    private static String realOkTaxRate(String currTaxRate) {
        if (all.contains(currTaxRate)) {
            String tmpStr = currTaxRate.substring(0, currTaxRate.length() - 1);
            if ("0".equals(tmpStr)) {
                return "0";
            }
            return String.valueOf(Double.parseDouble(tmpStr) / 100.0);
        }
        if (Arrays.asList(intTaxRate).contains(currTaxRate)) {
            if ("0".equals(currTaxRate)) {
                return currTaxRate;
            }
            return String.valueOf(Double.parseDouble(currTaxRate) / 100.0);
        }
        return currTaxRate;
    }

    public static String convertTaxRate(String taxRate) {
        try {
            if (StringUtils.isBlank((CharSequence)taxRate)) {
                return null;
            }
            if (taxRate.contains("%")) {
                taxRate = TaxRateUtil.percent2Point(taxRate);
            } else if (!taxRate.startsWith("0.")) {
                taxRate = new BigDecimal(taxRate).divide(new BigDecimal(100), 8, 4).stripTrailingZeros().toPlainString();
            }
            if ("0.1".equals(taxRate)) {
                taxRate = taxRate + '0';
            }
        }
        catch (Exception e) {
            taxRate = "0";
        }
        return taxRate;
    }

    public static String convertPercentTaxRate(String taxRate) {
        try {
            if (StringUtils.isBlank((CharSequence)taxRate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\uff0c\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxRateUtil_12", (String)"imc-bdm-common", (Object[])new Object[0]));
            }
            if (taxRate.contains("%")) {
                return taxRate;
            }
            if (taxRate.startsWith("0.")) {
                taxRate = new BigDecimal(taxRate).multiply(new BigDecimal(100)).stripTrailingZeros().toPlainString().concat("%");
            }
        }
        catch (Exception e) {
            taxRate = "0";
        }
        return taxRate;
    }
}

