/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeUtils {
    private static Log logger = LogFactory.getLog(TreeUtils.class);
    public static final String DEFAULT_ROOT_ID = "-1";
    public static final String LEVEL = "level";

    public static void expandAll(TreeView treeView, TreeNode treeNode) {
        if (treeNode != null) {
            if (treeNode.getChildren() != null) {
                treeNode.setIsOpened(true);
                TreeUtils.expandChild(treeNode, 10);
            }
            treeView.deleteNode(treeNode.getId());
            treeView.addNode(treeNode);
        }
    }

    public static void expandChild(TreeNode treeNode, int expendLevel) {
        if (treeNode != null) {
            Map data = (Map)treeNode.getData();
            int currentLevel = 0;
            if (data != null) {
                currentLevel = Integer.parseInt(data.getOrDefault(LEVEL, "0"));
            }
            if (currentLevel < expendLevel) {
                treeNode.getChildren().forEach(t -> {
                    if (t.getChildren() != null) {
                        t.setIsOpened(true);
                        TreeUtils.expandChild(t, expendLevel);
                    }
                });
            }
        }
    }

    public static void putCache(IPageCache pageCache, String cacheName, Object cacheObj) {
        if (cacheObj != null) {
            pageCache.put(cacheName, SerializationUtils.toJsonString((Object)cacheObj));
        }
    }

    public static TreeNode getCache(IPageCache pageCache, String cacheName) {
        String cacheStr = pageCache.get(cacheName);
        if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)cacheStr, TreeNode.class);
        }
        return new TreeNode();
    }

    public static void removeCache(IPageCache pageCache, String cacheName) {
        pageCache.remove(cacheName);
    }

    public static void build(TreeView treeView, List<TreeNode> treeNodes, IPageCache pageCache, boolean expand) {
        HashMap nodeMap = Maps.newHashMapWithExpectedSize((int)10);
        ArrayList roots = Lists.newArrayListWithCapacity((int)100);
        List idList = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        for (TreeNode node : treeNodes) {
            if ("0".equals(node.getId())) continue;
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put(LEVEL, "1");
            if (StringUtils.isEmpty((CharSequence)node.getParentid()) || node.getParentid().equals("0")) {
                node.setParentid("");
                node.setData(data);
                roots.add(node);
            } else if (!idList.contains(node.getParentid())) {
                node.setParentid("");
                node.setData(data);
                roots.add(node);
            }
            if (nodeMap.containsKey(node.getParentid())) {
                ((List)nodeMap.get(node.getParentid())).add(node);
                continue;
            }
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            list.add(node);
            nodeMap.put(node.getParentid(), list);
        }
        for (TreeNode root : roots) {
            root.setLongNumber(root.getId());
            TreeUtils.findChildren(root, nodeMap);
            treeView.addNode(root);
            if (!expand) continue;
            TreeUtils.expandAll(treeView, root);
        }
        if (pageCache != null && !roots.isEmpty()) {
            if (roots.size() > 1) {
                TreeNode node = new TreeNode();
                node.setId(DEFAULT_ROOT_ID);
                node.setText("");
                node.setChildren((List)roots);
                TreeUtils.putCache(pageCache, treeView.getKey(), node);
            } else {
                TreeUtils.putCache(pageCache, treeView.getKey(), roots.get(0));
            }
        }
    }

    public static List<TreeNode> findRoot(List<TreeNode> treeNodes) {
        ArrayList<String> idList = new ArrayList<String>(8);
        for (TreeNode node : treeNodes) {
            idList.add(node.getId());
        }
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>(8);
        for (TreeNode node : treeNodes) {
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put(LEVEL, "1");
            if (StringUtils.isEmpty((CharSequence)node.getParentid())) {
                node.setParentid("");
                node.setData(data);
                trees.add(node);
                continue;
            }
            if (idList.contains(node.getParentid())) continue;
            node.setParentid("");
            node.setData(data);
            trees.add(node);
        }
        return trees;
    }

    public static void findChildren(TreeNode treeNode, Map<String, List<TreeNode>> nodeMap) {
        int parLevel = TreeUtils.getLevel(treeNode);
        List<TreeNode> nodes = nodeMap.get(treeNode.getId());
        if (!CollectionUtils.isEmpty(nodes)) {
            treeNode.setChildren(nodes);
            treeNode.getChildren().forEach(o -> {
                HashMap<String, String> data = (HashMap<String, String>)o.getData();
                if (data == null) {
                    data = new HashMap<String, String>(8);
                }
                data.put(LEVEL, String.valueOf(parLevel + 1));
                o.setData(data);
                o.setLongNumber(treeNode.getLongNumber() + "." + o.getId());
                TreeUtils.findChildren(o, nodeMap);
            });
        }
    }

    public static TreeNode findChildren(TreeNode treeNode, List<TreeNode> treeNodes) {
        int parLevel = TreeUtils.getLevel(treeNode);
        for (TreeNode it : treeNodes) {
            HashMap<String, String> data;
            if (!treeNode.getId().equals(it.getParentid())) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            if ((data = (HashMap<String, String>)it.getData()) == null) {
                data = new HashMap<String, String>(8);
            }
            data.put(LEVEL, String.valueOf(parLevel + 1));
            it.setData(data);
            it.setLongNumber(treeNode.getLongNumber() + "." + it.getId());
            TreeNode child = TreeUtils.findChildren(it, treeNodes);
            child.setParentid(treeNode.getId());
            treeNode.getChildren().add(child);
        }
        return treeNode;
    }

    private static int getLevel(TreeNode treeNode) {
        Map data = (Map)treeNode.getData();
        return Integer.parseInt(data.getOrDefault(LEVEL, "1"));
    }

    public static void checkChilds(TreeView treeView, TreeNode treeNode) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        TreeUtils.getChildNodes(list, treeNode);
        treeView.checkNodes(list);
    }

    public static void unCheckChilds(TreeView treeView, TreeNode treeNode) {
        ArrayList<String> list = new ArrayList<String>(8);
        TreeUtils.getChildIds(list, treeNode);
        treeView.uncheckNodes(list);
    }

    private static void getChildNodes(List<TreeNode> list, TreeNode treeNode) {
        List childs = treeNode.getChildren();
        if (childs != null && !childs.isEmpty()) {
            for (TreeNode node : childs) {
                try {
                    TreeNode node1 = TreeUtils.convert(TreeNode.class, node);
                    node1.setChildren(null);
                    list.add(node1);
                }
                catch (Exception e) {
                    logger.error((Object)"\u83b7\u53d6\u5b50\u8282\u70b9\u5931\u8d25", (Throwable)e);
                }
                TreeUtils.getChildNodes(list, node);
            }
        }
    }

    private static void getChildIds(List<String> list, TreeNode treeNode) {
        List childs = treeNode.getChildren();
        if (childs != null && !childs.isEmpty()) {
            for (TreeNode node : childs) {
                if (!list.contains(node.getId())) {
                    list.add(node.getId());
                }
                TreeUtils.getChildIds(list, node);
            }
        }
    }

    public static List<String> getNodeIdList(TreeNode treeNode) {
        ArrayList<String> list = new ArrayList<String>(8);
        if (treeNode != null) {
            if (!treeNode.getId().equals(DEFAULT_ROOT_ID)) {
                list.add(treeNode.getId());
            }
            TreeUtils.getChildIds(list, treeNode);
        }
        return list;
    }

    public static List<TreeNode> getNodeList(TreeNode treeNode) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        if (treeNode != null) {
            try {
                TreeNode node = TreeUtils.convert(TreeNode.class, treeNode);
                node.setChildren(null);
                list.add(node);
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u53d6\u8282\u70b9\u5931\u8d25", (Throwable)e);
            }
            TreeUtils.getChildNodes(list, treeNode);
        }
        return list;
    }

    public static TreeNode copyNode(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        TreeNode newNode = new TreeNode();
        newNode.setId(treeNode.getId());
        newNode.setParentid(treeNode.getParentid());
        newNode.setText(treeNode.getText());
        newNode.setIsOpened(treeNode.getIsOpened());
        newNode.setColor(treeNode.getColor());
        newNode.setLongNumber(treeNode.getLongNumber());
        Object data = treeNode.getData();
        if (data instanceof HashMap) {
            newNode.setData(data);
        }
        return newNode;
    }

    public static List<String> getChildIdList(TreeNode treeNode) {
        ArrayList<String> idList = new ArrayList<String>(8);
        if (treeNode != null && !CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode node : treeNode.getChildren()) {
                idList.addAll(TreeUtils.childList(node));
            }
        }
        return idList;
    }

    private static List<String> childList(TreeNode treeNode) {
        ArrayList<String> idList = new ArrayList<String>(8);
        if (treeNode != null) {
            idList.add(treeNode.getId());
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                for (TreeNode node : treeNode.getChildren()) {
                    idList.addAll(TreeUtils.childList(node));
                }
            }
        }
        return idList;
    }

    public static <T> T convert(Class<T> dstClazz, Object srcObj) throws InstantiationException, IllegalAccessException {
        Object value;
        String name;
        Field[] parFields;
        Object value2;
        Field[] srcParFields;
        Class<?> srcClazz = srcObj.getClass();
        T dstObject = dstClazz.newInstance();
        Field[] fields = dstClazz.getDeclaredFields();
        Field[] srcFields = srcClazz.getDeclaredFields();
        if (srcFields == null) {
            return dstObject;
        }
        HashMap<String, Object> srcFieldsMap = new HashMap<String, Object>(srcFields.length);
        for (Field field : srcParFields = srcClazz.getSuperclass().getDeclaredFields()) {
            ReflectionUtils.makeAccessible((Field)field);
            value2 = field.get(srcObj);
            srcFieldsMap.put(field.getName(), value2);
        }
        for (Field field : srcFields) {
            ReflectionUtils.makeAccessible((Field)field);
            value2 = field.get(srcObj);
            String name2 = field.getName();
            srcFieldsMap.put(name2, value2);
        }
        Class<T> parentClass = dstClazz.getSuperclass();
        for (Field field : parFields = parentClass.getDeclaredFields()) {
            name = field.getName();
            value = srcFieldsMap.get(name);
            if (value == null) continue;
            ReflectionUtils.makeAccessible((Field)field);
            field.set(dstObject, value);
        }
        for (Field field : fields) {
            name = field.getName();
            try {
                value = srcFieldsMap.get(name);
                if (value == null) {
                    throw new Exception();
                }
                ReflectionUtils.makeAccessible((Field)field);
                field.set(dstObject, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dstObject;
    }

    public static TreeNode getROOT() {
        TreeNode rootRight = new TreeNode();
        rootRight.setId(DEFAULT_ROOT_ID);
        rootRight.setText("\u6839\u7ec4\u7ec7");
        rootRight.setParentid("");
        return rootRight;
    }

    public static List<TreeNode> getTreeNodes(TreeNode rightSelectNode, List<TreeNode> treeNodeList, Map<String, String> parentIdMap) {
        for (TreeNode treeMode : treeNodeList) {
            treeMode.setParentid(parentIdMap.get(treeMode.getId()));
        }
        List<TreeNode> roots = TreeUtils.findRoot(treeNodeList);
        for (TreeNode root : roots) {
            root.setLongNumber(rightSelectNode.getLongNumber() + "." + rightSelectNode.getId());
            TreeUtils.findChildren(root, treeNodeList);
            root.setParentid(rightSelectNode.getId());
        }
        return roots;
    }
}

