/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ViewUtil {
    public static void openNormalConfirm(AbstractFormPlugin plugin, String showContent, String callBackKey) {
        ViewUtil.openConfirm(callBackKey, showContent, plugin, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ViewUtil_0", (String)"imc-bdm-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ViewUtil_1", (String)"imc-bdm-common", (Object[])new Object[0]), "");
    }

    public static void openConfirm(String callBackKey, String showContent, AbstractFormPlugin that, String cancekName, String okName) {
        ViewUtil.openConfirm(callBackKey, showContent, that, cancekName, okName, "");
    }

    public static void openConfirm(String callBackKey, String showContent, AbstractFormPlugin that, String cancekName, String okName, String showMsg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackKey, (IFormPlugin)that);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), cancekName);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), okName);
        that.getView().showConfirm(showContent, showMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public static void openConfirmOK(String callBackKey, String showContent, AbstractFormPlugin that, String okName) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackKey, (IFormPlugin)that);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), okName);
        that.getView().showConfirm(showContent, "", MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public static void openDialog(AbstractFormPlugin plugin, Map<String, Object> customParams, String formId, String callBackKey) {
        ViewUtil.openDialog(plugin, null, customParams, formId, callBackKey);
    }

    public static void openDialog(AbstractFormPlugin plugin, String titleName, Map<String, Object> customParams, String formId, String callBackKey) {
        ViewUtil.openDialog(plugin, titleName, customParams, formId, callBackKey, true);
    }

    public static void openDialog(AbstractFormPlugin plugin, String titleName, Map<String, Object> customParams, String formId, String callBackKey, boolean isShowTitle) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (!StringUtils.isEmpty((CharSequence)titleName)) {
            formShowParameter.setCaption(titleName);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, callBackKey);
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        formShowParameter.setShowTitle(isShowTitle);
        plugin.getView().showForm(formShowParameter);
    }

    public static void openMainNewTabPage(AbstractFormPlugin plugin, String pageId, Map<String, Object> customParams, String formId, String callBackKey) {
        ViewUtil.openMainNewTabPage(plugin, pageId, customParams, formId, callBackKey, null, null);
    }

    public static void openMainNewTabPage(AbstractFormPlugin plugin, String pageId, Map<String, Object> customParams, String formId, String callBackKey, String caption) {
        ViewUtil.openMainNewTabPage(plugin, pageId, customParams, formId, callBackKey, caption, null);
    }

    public static void openMainNewTabPage(AbstractFormPlugin plugin, String pageId, Map<String, Object> customParams, String formId, String callBackKey, String caption, OperationStatus operationStatus) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            formShowParameter.setPageId(pageId);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        if (operationStatus != null) {
            formShowParameter.setStatus(operationStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            formShowParameter.setCaption(caption);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, callBackKey);
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        plugin.getView().showForm(formShowParameter);
    }

    public static void openTrackListPage(AbstractFormPlugin plugin, String formId, Collection<Object> pkValus) {
        ViewUtil.openTrackListPage(plugin, formId, pkValus, null);
    }

    public static void openTrackListPage(AbstractFormPlugin plugin, String formId, Collection<Object> pkValus, String capiton) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)2, (boolean)false);
        LinkQueryPkIdCollection link = new LinkQueryPkIdCollection();
        for (Object pk : pkValus) {
            link.addLinkQueryPkId(pk);
        }
        if (StringUtils.isNotBlank((CharSequence)capiton)) {
            parameter.setCaption(capiton);
        }
        parameter.setLinkQueryPkIdCollection(link);
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey) {
        ViewUtil.openListPage(plugin, qFilter, formId, callBackKey, true);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, String caption) {
        ViewUtil.openListPage(plugin, qFilter, formId, callBackKey, true, false, null, null, caption);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, boolean lookUp) {
        ViewUtil.openListPage(plugin, qFilter, formId, callBackKey, lookUp, false, null, null, null);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, boolean lookUp, boolean isMultiSelect, Object[] pkIds) {
        ViewUtil.openListPage(plugin, qFilter, formId, callBackKey, lookUp, isMultiSelect, pkIds, null, null);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, boolean lookUp, boolean isMultiSelect, Object[] pkIds, Map<String, Object> customParams, String caption) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        parameter.setLookUp(lookUp);
        if (pkIds != null && pkIds.length > 0) {
            parameter.setSelectedRows(pkIds);
        }
        if (qFilter != null) {
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(qFilter);
        }
        if (customParams != null) {
            parameter.setCustomParams(customParams);
        }
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            parameter.setShowTitle(true);
            parameter.setCaption(caption);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackKey));
        }
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void openListPageByMainPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, ShowType showType) {
        ViewUtil.openListPageByMainPage(plugin, qFilter, null, formId, callBackKey, showType);
    }

    public static void openListPageByMainPage(AbstractFormPlugin plugin, QFilter qFilter, Map<String, Object> customParams, String formId, String callBackKey, ShowType showType) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)2, (boolean)false);
        if (qFilter != null) {
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(qFilter);
        }
        if (customParams != null) {
            parameter.setCustomParams(customParams);
        }
        if (StringUtils.isNotBlank((Object)showType)) {
            parameter.getOpenStyle().setShowType(showType);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackKey));
        }
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void bindDataToHtml(AbstractFormPlugin plugin, Map<String, Object> data, String key) {
        ViewUtil.bindDataToHtml(plugin, data, key, plugin.getView().getPageId());
    }

    public static void bindDataToHtml(AbstractFormPlugin plugin, Map<String, Object> data, String key, String pageId) {
        data.put("time", System.currentTimeMillis());
        data.put("pageId", pageId);
        CustomControl control = (CustomControl)plugin.getControl(key);
        if (control != null) {
            control.setData(data);
        }
    }

    public static void setDropDownViewData(AbstractFormPlugin formPlugin, String controlId, Map<String, String> itemMap) {
        ComboEdit comboEdit = (ComboEdit)formPlugin.getControl(controlId);
        ArrayList items = Lists.newArrayListWithCapacity((int)itemMap.size());
        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            ComboItem comboItem = new ComboItem(new LocaleString(key), value);
            items.add(comboItem);
        }
        formPlugin.getView().setEnable(Boolean.TRUE, new String[]{controlId});
        comboEdit.setComboItems((List)items);
    }

    public static void setEntryRowEnable(IFormView view, String key, boolean b, int index) {
        Control te = view.getControl(key);
        if (te instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)te;
            textEdit.setEnable(key, b, index);
        } else if (te instanceof ComboEdit) {
            ((ComboEdit)te).setEnable(key, b, index);
        }
    }

    public static void setLabelViewData(IFormView view, String key, String content) {
        Label label = (Label)view.getControl(key);
        label.setText(content);
    }

    public static void setAllViewDisable(IFormView view, boolean enable, String formId) {
        DynamicObject invoiceDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formId);
        IDataEntityType entityType = invoiceDynamicObject.getDataEntityType();
        DataEntityPropertyCollection collect = entityType.getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            view.setEnable(Boolean.valueOf(enable), new String[]{field});
        }
    }

    public static void showComboEditAll(IFormView view, String comboEditName, boolean setDefault, String defaultValue) {
        ViewUtil.showComboEditByKey(view, comboEditName, null, setDefault, defaultValue);
    }

    public static void showComboEditByKey(IFormView view, String comboEditName, Set<String> visibleKey, boolean setDefault, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)comboEditName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a7\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"ViewUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]));
        }
        ComboEdit comboEdit = (ComboEdit)view.getControl(comboEditName);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        ArrayList items = Lists.newArrayList();
        List comboItems = property.getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            if (!CollectionUtils.isEmpty(visibleKey) && visibleKey.contains(value)) {
                ViewUtil.addItem(items, comboItem);
                continue;
            }
            if (!CollectionUtils.isEmpty(visibleKey)) continue;
            ViewUtil.addItem(items, comboItem);
        }
        comboEdit.setComboItems((List)items);
        if (setDefault) {
            view.getModel().setValue(comboEditName, (Object)defaultValue);
        }
    }

    private static void addItem(List<ComboItem> items, ValueMapItem comboItem) {
        ComboItem item = new ComboItem();
        item.setCaption(comboItem.getName());
        item.setValue(comboItem.getValue());
        item.setItemVisible(true);
        items.add(item);
    }
}

