/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.alleinvoice;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleLoginRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleLoginResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleTaxPlatformResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.PropertieUtil;

public class TaxPlatformLoginPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TaxPlatformLoginPlugin.class);

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String loginWebUrls = (String)formShowParameter.getCustomParam("loginWebUrls");
        try {
            int index = loginWebUrls.indexOf(63) + 1;
            StringBuilder loginUrlSb = new StringBuilder(loginWebUrls.substring(0, index));
            HashMap<String, String> splitMap = new HashMap<String, String>(Splitter.on((char)'&').withKeyValueSeparator('=').split((CharSequence)loginWebUrls.substring(index)));
            String loginType = (String)formShowParameter.getCustomParam("loginType");
            if (StringUtils.isBlank((CharSequence)loginType)) {
                loginType = this.getLoginType(formShowParameter);
            }
            splitMap.put("loginType", "0".equals(loginType) ? "" : "1");
            splitMap.put("showSuccess", "false");
            loginUrlSb.append(Joiner.on((char)'&').useForNull("").withKeyValueSeparator('=').join(splitMap));
            loginWebUrls = loginUrlSb.toString();
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u66ff\u6362\u540e\u7684\u6570\u7535\u767b\u5f55url\u4e3a[%s]", loginWebUrls));
            }
        }
        catch (Exception ex) {
            logger.error("\u89e3\u6790\u6570\u7535\u767b\u5f55url\u5931\u8d25", (Object)e);
        }
        IFrame iFrame = (IFrame)this.getControl("iframeap");
        iFrame.setSrc(loginWebUrls);
    }

    private String getLoginType(FormShowParameter formShowParameter) {
        String taxNo = (String)formShowParameter.getCustomParam("taxNo");
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u5f00\u59cb\u83b7\u53d6logintype\uff0c\u7a0e\u53f7\u4e3a[%s]", taxNo));
        }
        QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((String)"bdm_einvoice_account", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_einvoice_account", (boolean)true), (QFilter[])qFilter.toArray());
        if (accountObj == null) {
            return "";
        }
        DynamicObjectCollection items = accountObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return "";
        }
        Stream<DynamicObject> itemStream = items.stream().filter(item -> "1".equals(item.getString("isenable")));
        String account = (String)formShowParameter.getCustomParam("account");
        AtomicReference<String> loginType = new AtomicReference<String>("");
        if (StringUtils.isNotBlank((CharSequence)account)) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u4f20\u5165\u8d26\u53f7\uff0c\u83b7\u53d6\u8d26\u53f7\u7684\u767b\u5f55\u9014\u5f84\uff0c\u7a0e\u53f7\u4e3a[%s]\uff0c\u8d26\u53f7\u4e3a[%s]", taxNo, account));
            }
            itemStream.filter(item -> account.equals(item.getString("account"))).findFirst().ifPresent(item -> loginType.set(item.getString("logintype")));
        } else {
            String operationType = (String)formShowParameter.getCustomParam("operationType");
            boolean isOutput = !"2".equals(operationType);
            itemStream.filter(item -> "1".equals(item.getString("isdefault"))).filter(item -> isOutput ? AllEleAuthHelper.isOutputAccount((String)item.getString("defaultbusiness"), (String)item.getString("accounttype")) : AllEleAuthHelper.isInputAccount((String)item.getString("defaultbusiness"), (String)item.getString("accounttype"))).findFirst().ifPresent(item -> loginType.set(item.getString("logintype")));
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u672a\u4f20\u5165\u8d26\u53f7\uff0c\u83b7\u53d6\u9ed8\u8ba4\u767b\u5f55\u9014\u5f84\uff0c\u7a0e\u53f7\u4e3a[%s]\uff0c\u64cd\u4f5c\u4e3a[%s]", taxNo, operationType));
            }
        }
        return loginType.get();
    }

    public void afterBindData(EventObject e) {
        this.getView().addClientCallBack("closeView", Integer.valueOf(300000));
        this.getView().addClientCallBack("loginCheck", Integer.valueOf(10000));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String taxNo = (String)this.getView().getFormShowParameter().getCustomParam("taxNo");
        switch (e.getName()) {
            case "closeView": {
                this.getView().close();
                break;
            }
            case "loginCheck": {
                String loginResponse = CacheHelper.get((String)this.getView().getPageId());
                if (StringUtils.isBlank((CharSequence)loginResponse)) {
                    this.login(taxNo);
                    return;
                }
                if ("wait".equals(loginResponse)) {
                    this.getView().addClientCallBack("loginCheck", Integer.valueOf(1000));
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u767b\u5f55\u6210\u529f", (String)"TaxPlatformLoginPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                AllEleLoginResponseDTO response = (AllEleLoginResponseDTO)SerializationUtils.fromJsonString((String)loginResponse, AllEleLoginResponseDTO.class);
                this.getView().returnDataToParent((Object)new AllEleTaxPlatformResponseDTO(response, this.getView().getFormShowParameter().getCustomParams()));
                this.getView().close();
            }
        }
    }

    private void login(String taxNo) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String longLinkName = (String)formShowParameter.getCustomParam("longLinkName");
        Boolean checkAuth = !"0".equals(formShowParameter.getCustomParam("checkAuth"));
        String operationType = (String)formShowParameter.getCustomParam("operationType");
        String account = (String)formShowParameter.getCustomParam("account");
        RequestContext requestContext = RequestContext.get();
        String cacheKey = this.getView().getPageId();
        ThreadPoolsHelper.taxPlatformLoginCaThreadPool.execute(() -> {
            RequestContext.set((RequestContext)requestContext);
            try (DLock pageLock = DLock.create((String)cacheKey);){
                if (!pageLock.tryLock()) {
                    return;
                }
                String cacheStr = CacheHelper.get((String)cacheKey);
                if (StringUtils.isBlank((CharSequence)cacheStr)) {
                    CacheHelper.put((String)cacheKey, (String)"wait", (int)600);
                } else if (!"wait".equals(cacheStr)) {
                    return;
                }
                AllEleLoginRequestDTO eleIssue = new AllEleLoginRequestDTO();
                eleIssue.setRequest_path(AllEleInterfaceTypeEnum.GET_LOGIN_STATUS.getRequestPath());
                eleIssue.setLongLinkName(longLinkName);
                eleIssue.setAccount(account);
                eleIssue.setCheckAuth(checkAuth);
                if (StringUtils.isBlank((CharSequence)operationType)) {
                    eleIssue.setOperationType("1");
                } else {
                    eleIssue.setOperationType("2".equals(operationType) ? operationType : "1");
                }
                AllEleResponseDTO allEleLoginResponseDTO = AllEleServiceHelper.eleLogin((String)taxNo, (AllEleLoginRequestDTO)eleIssue);
                if (allEleLoginResponseDTO.getSuccess().booleanValue() && ((AllEleLoginResponseDTO)allEleLoginResponseDTO.getData()).getEtaxAccountType() != -1) {
                    CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString((Object)allEleLoginResponseDTO.getData()), (int)600);
                } else {
                    CacheHelper.remove((String)cacheKey);
                }
            }
        });
        this.getView().addClientCallBack("loginCheck", Integer.valueOf(1000));
    }
}

