/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.archive;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.util.DateUtils;

public class BillArchiveAutoTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BillArchiveAutoTask.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        logger.info("\u5b9a\u65f6\u5f52\u6863\u5f00\u59cb");
        try (DLock lock = DLock.create((String)"BillArchiveAutoTask", (String)"BillArchiveAutoTask");){
            if (lock.tryLock()) {
                List<Long> configList = this.getConfigId();
                for (Long id : configList) {
                    this.doBusiness(id);
                }
            }
        }
        logger.info("\u5b9a\u65f6\u5f52\u6863\u7ed3\u675f");
    }

    private void doBusiness(Long pk) {
        try {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_bill_archive_config");
            Date startDate = DateUtils.trunc((Date)obj.getDate("last_date"));
            if (startDate == null) {
                return;
            }
            String filterStr = obj.getString("filter_tag");
            String dateField = obj.getString("date_field");
            String sentity = obj.getDynamicObject("sentity").getString("number");
            String tentity = obj.getDynamicObject("tentity").getString("number");
            int deadlineDay = obj.getInt("deadline_day");
            int pageSize = obj.getInt("page_size");
            if (StringUtils.isEmpty((CharSequence)filterStr)) {
                logger.info("\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a{},{}", (Object)sentity, (Object)tentity);
                return;
            }
            if (!BillArchiveHelper.compare((String)sentity, (String)tentity)) {
                logger.info("\u5b9a\u65f6\u5f52\u6863,\u5355\u636e\u7ed3\u6784\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5f52\u6863{},{}", (Object)sentity, (Object)tentity);
                return;
            }
            long start = System.currentTimeMillis();
            logger.info("\u5b9a\u65f6\u5f52\u6863,\u5f00\u59cb{},{}", (Object)sentity, (Object)tentity);
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            FilterBuilder builder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)sentity), filterCondition);
            builder.buildFilter();
            QFilter qFilter = builder.getQFilter();
            Date maxDate = DateUtils.addDay((Date)new Date(), (int)(0 - deadlineDay));
            Date endDate = null;
            while (startDate.compareTo(maxDate) <= 0) {
                endDate = DateUtils.addDay((Date)startDate, (int)1);
                QFilter dateFilter = new QFilter(dateField, ">=", (Object)startDate);
                int result = this.archive(pk, qFilter, dateFilter = dateFilter.and(new QFilter(dateField, "<", (Object)endDate)), sentity, tentity, dateField, pageSize);
                if (result < -10) break;
                logger.info("\u5b9a\u65f6\u5f52\u6863,\u5904\u7406\u7ed3\u675f{},{},{},{}", new Object[]{sentity, tentity, DateUtils.format((Date)startDate), result});
                this.updateDate(pk, startDate);
                startDate = endDate;
            }
            logger.info("\u5b9a\u65f6\u5f52\u6863,\u7ed3\u675f{},{},{}", new Object[]{sentity, tentity, System.currentTimeMillis() - start});
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u5f52\u6863\u5931\u8d25", (Throwable)e);
        }
    }

    private void updateDate(Long pk, Date date) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_bill_archive_config");
                obj.set("last_date", (Object)date);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            catch (Throwable e) {
                h.markRollback();
            }
        }
    }

    private int archive(Long configId, QFilter qFilter, QFilter dateFilter, String sentity, String tentity, String orderBy, int top) {
        int count = 0;
        while (true) {
            if (!this.isContinue(configId)) {
                logger.info("\u5b9a\u65f6\u5f52\u6863,\u914d\u7f6e\u72b6\u6001\u88ab\u4fee\u6539,\u4e3b\u52a8\u505c\u6b62{},{},\u5df2\u7ecf\u5904\u7406{}", new Object[]{sentity, tentity, count});
                return -100;
            }
            List<Long> list = this.queryList(qFilter, dateFilter, sentity, orderBy, top);
            if (list.isEmpty()) {
                return count;
            }
            count += BillArchiveHelper.archive((String)sentity, (String)tentity, list);
        }
    }

    private boolean isContinue(Long configId) {
        QFilter qFilter = new QFilter("id", "=", (Object)configId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_bill_archive_config", (String)"status", (QFilter[])qFilter.toArray());
        return obj != null && "1".equals(obj.getString("status"));
    }

    private List<Long> queryList(QFilter qFilter, QFilter dateFilter, String entity, String orderBy, int top) {
        DynamicObjectCollection collect = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{dateFilter, qFilter}, (String)orderBy, (int)top);
        ArrayList<Long> list = new ArrayList<Long>(collect.size());
        for (DynamicObject obj : collect) {
            list.add(obj.getLong("id"));
        }
        return list;
    }

    private List<Long> getConfigId() {
        QFilter filter = new QFilter("status", "=", (Object)"1");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_bill_archive_config", (String)"id", (QFilter[])filter.toArray());
        ArrayList<Long> list = new ArrayList<Long>(8);
        for (DynamicObject obj : collect) {
            list.add(obj.getLong("id"));
        }
        return list;
    }
}

