/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.formplugin.archive.BillArchiveAutoTask;
import org.apache.commons.lang3.StringUtils;

public class BillArchiveConfigPlugin
extends AbstractFormPlugin {
    private String skey = "sentity";
    private String tkey = "tentity";
    private String bakEntity = "bak_entity";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        String filter = (String)this.getModel().getValue("filter_tag");
        this.loadFilterGrid(this.getEntityKey(this.skey), filter);
    }

    public void beforeBindData(EventObject e) {
        this.loadFilterGrid(this.getEntityKey(this.skey), null);
        this.loadcombo(this.skey);
        this.loadcombo(this.tkey);
        this.loadcombo(this.bakEntity);
    }

    public void afterBindData(EventObject e) {
        String filter = (String)this.getModel().getValue("filter_tag");
        this.loadFilterGrid(this.getEntityKey(this.skey), filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty proterty = e.getProperty();
        if (this.skey.equals(proterty.getName())) {
            this.loadFilterGrid(this.getEntityKey(this.skey), null);
        }
        if (this.skey.equals(proterty.getName()) || this.tkey.equals(proterty.getName()) || this.bakEntity.equals(proterty.getName())) {
            this.loadcombo(proterty.getName());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)((FormOperate)args.getSource()).getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            String filterStr = SchemeHelper.getFilterStr((FilterGrid)filterGrid);
            this.getModel().setValue("filter_tag", (Object)filterStr);
            if (StringUtils.isEmpty((CharSequence)filterStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillArchiveConfigPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                String sentry = this.getEntityKey(this.skey);
                String tentry = this.getEntityKey(this.tkey);
                String bakentity = this.getEntityKey(this.bakEntity);
                MainEntityType sEntityType = EntityMetadataCache.getDataEntityType((String)sentry);
                MainEntityType tEntityType = EntityMetadataCache.getDataEntityType((String)tentry);
                if (!sEntityType.getDBRouteKey().equals(tEntityType.getDBRouteKey())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u59cb\u5355\u636e\u548c\u5386\u53f2\u5355\u636e\u5fc5\u987b\u5728\u76f8\u540c\u5206\u5e93", (String)"BillArchiveConfigPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!"taxc".equals(sEntityType.getDBRouteKey())) {
                    String bak_sentity = (String)this.getModel().getValue("bak_sentity");
                    String bak_tentity = (String)this.getModel().getValue("bak_tentity");
                    String bak_data = (String)this.getModel().getValue("bak_data");
                    if (StringUtils.isEmpty((CharSequence)bakentity) || StringUtils.isEmpty((CharSequence)bak_sentity) || StringUtils.isEmpty((CharSequence)bak_tentity) || StringUtils.isEmpty((CharSequence)bak_data)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5907\u4efd\u5355\u636e\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillArchiveConfigPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
                if (!BillArchiveHelper.compare((String)sentry, (String)tentry)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e24\u4e2a\u5355\u636e\u5b57\u6bb5\u4e0d\u4e00\u81f4,\u4e0d\u80fd\u4fdd\u5b58", (String)"BillArchiveConfigPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("test".equals(evt.getItemKey())) {
            BillArchiveAutoTask task = new BillArchiveAutoTask();
            task.execute(RequestContext.get(), null);
        }
    }

    private void loadFilterGrid(String entity, String filterValue) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        filterGrid.setEntityNumber(entity);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        filterCondition.getFilterRow().clear();
        if (filterValue == null) {
            filterGrid.SetValue(Collections.EMPTY_LIST);
        } else if (StringUtils.isNotBlank((CharSequence)filterValue)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterValue, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.getView().updateView("filtergridap");
    }

    private String getEntityKey(String tkey) {
        DynamicObject obj = (DynamicObject)this.getModel().getValue(tkey);
        if (obj != null) {
            String entity = obj.getString("number");
            return entity;
        }
        return null;
    }

    private void loadcombo(String property) {
        String billFormId = this.getEntityKey(property);
        if (StringUtils.isEmpty((CharSequence)billFormId)) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        MainEntityType sEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        DataEntityPropertyCollection properties = sEntityType.getProperties();
        for (IDataEntityProperty dataproperty : properties) {
            LocaleString name;
            if (dataproperty instanceof EntryProp || (name = dataproperty.getDisplayName()) == null) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(dataproperty.getName());
            comboItem.setCaption(name);
            comboItems.add(comboItem);
        }
        if (this.skey.equals(property)) {
            this.setComboItems(comboItems, "date_field");
            this.setComboItems(comboItems, "billno_field");
            this.setComboItems(comboItems, "taxno_field");
            this.setComboItems(comboItems, "org_field");
        }
        if (this.tkey.equals(property)) {
            this.setComboItems(comboItems, "org_field");
            this.setComboItems(comboItems, "month_field");
            this.setComboItems(comboItems, "taxno_field");
        }
        if (this.bakEntity.equals(property)) {
            this.setComboItems(comboItems, "bak_sentity");
            this.setComboItems(comboItems, "bak_tentity");
            this.setComboItems(comboItems, "bak_data");
            this.setComboItems(comboItems, "bak_billno");
            this.setComboItems(comboItems, "bak_batch");
            this.setComboItems(comboItems, "bak_pk");
        }
    }

    private void setComboItems(List<ComboItem> comboItems, String controlKey) {
        String defaultval = (String)this.getModel().getValue(controlKey);
        ComboEdit control = (ComboEdit)this.getControl(controlKey);
        control.setComboItems(comboItems);
        if (!StringUtils.isEmpty((CharSequence)defaultval)) {
            this.getModel().setValue(controlKey, (Object)defaultval);
        }
    }
}

