/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.archive;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;

public class BillArchiveListPlugin
extends AbstractListPlugin {
    private static final String OPERATE_ARCHIVE = "archive";
    private static final String OPERATE_REVOKE = "revoke";
    private static final String OPERATE_QUERY = "query";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        ListSelectedRowCollection collection = this.getSelectedRows();
        Object[] obj = collection.getPrimaryKeyValues();
        String operKey = e.getOperateKey();
        if (OPERATE_ARCHIVE.equals(operKey) || OPERATE_REVOKE.equals(operKey)) {
            DynamicObject config = this.getConfig(operKey);
            if (config == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u5148\u68c0\u67e5\u914d\u7f6e", (String)"BillArchiveListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
            ArrayList<Long> list = new ArrayList<Long>(obj.length);
            for (Object pk : obj) {
                list.add(BigDecimalUtil.transDecimal((Object)pk).longValue());
            }
            int count = 0;
            count = OPERATE_ARCHIVE.equals(operKey) ? BillArchiveHelper.archive((String)config.getString("sentity"), (String)config.getString("tentity"), list) : BillArchiveHelper.revoke((String)config.getString("sentity"), (String)config.getString("tentity"), list);
            if (count > 0) {
                BillList billlist = (BillList)this.getControl("billlistap");
                billlist.refresh();
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs event) {
        String monthField;
        DynamicObject obj = this.getConfig(OPERATE_REVOKE);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        if (obj != null && !StringUtils.isEmpty((Object)(monthField = obj.getString("month_field")))) {
            List listCommonFilterColumns = event.getCommonFilterColumns();
            CommonFilterColumn dataMonthFilter = null;
            for (FilterColumn column : listCommonFilterColumns) {
                if (!monthField.equals(column.getFieldName())) continue;
                dataMonthFilter = (CommonFilterColumn)column;
            }
            QFilter filter1 = new QFilter("tentity", "=", (Object)((ListView)this.getView()).getBillFormId());
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_bill_archive_month", (String)"data_month", (QFilter[])filter1.toArray(), (String)"data_month", (int)100);
            String defVal = null;
            for (int i = collect.size() - 1; i >= 0; --i) {
                String month = ((DynamicObject)collect.get(i)).getString("data_month");
                if (defVal == null) {
                    defVal = month;
                }
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(month);
                comboItem.setCaption(new LocaleString(month));
                comboItems.add(comboItem);
            }
            if (!comboItems.isEmpty()) {
                if (dataMonthFilter == null) {
                    dataMonthFilter = new CommonFilterColumn();
                    dataMonthFilter.setFieldName(monthField);
                    dataMonthFilter.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u6708\u4efd", (String)"BillArchiveListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0])));
                    dataMonthFilter.setComboItems(comboItems);
                    dataMonthFilter.setDefaultValues(new Object[]{defVal});
                    listCommonFilterColumns.add(0, dataMonthFilter);
                } else {
                    dataMonthFilter.setComboItems(comboItems);
                    dataMonthFilter.setDefaultValues(new Object[]{defVal});
                }
            }
        }
    }

    private DynamicObject getConfig(String type) {
        String numberField = "tentity";
        if (OPERATE_ARCHIVE.equals(type)) {
            numberField = "sentity";
        }
        QFilter filter = new QFilter(numberField, "=", (Object)((ListView)this.getView()).getBillFormId());
        if (!OPERATE_QUERY.equals(type)) {
            filter = filter.and(new QFilter("status", "=", (Object)"1"));
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_bill_archive_config", (String)"sentity,tentity,date_field,month_field", (QFilter[])filter.toArray());
        return obj;
    }
}

