/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.archive;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.StringUtils;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.MetadataUtil;

public class BillArchivePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void itemClick(ItemClickEvent evt) {
        if ("archive".equals(evt.getItemKey()) || "revoke".equals(evt.getItemKey())) {
            this.operate(evt.getItemKey());
        }
    }

    private void operate(String type) {
        String sentityKey = (String)this.getModel().getValue("sentity_key");
        String tentityKey = (String)this.getModel().getValue("tentity_key");
        if (!MetadataUtil.exists((String)sentityKey).booleanValue()) {
            String tipMsg = ResManager.loadKDString((String)"\u539f\u5355\u636e\u9519\u8bef", (String)"BillArchivePlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg, Integer.valueOf(5000));
            return;
        }
        if (!MetadataUtil.exists((String)tentityKey).booleanValue()) {
            String tipMsg = ResManager.loadKDString((String)"\u5f52\u6863\u5355\u636e\u9519\u8bef", (String)"BillArchivePlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg, Integer.valueOf(5000));
            return;
        }
        List<Long> pkList = this.getPks();
        if (pkList.isEmpty()) {
            String tipMsg = ResManager.loadKDString((String)"\u5f52\u6863\u6570\u636e\u4e3a\u7a7a", (String)"BillArchivePlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg, Integer.valueOf(5000));
            return;
        }
        if ("archive".equals(type)) {
            BillArchiveHelper.archive((String)sentityKey, (String)tentityKey, pkList);
        } else if ("revoke".equals(type)) {
            BillArchiveHelper.revoke((String)sentityKey, (String)tentityKey, pkList);
        }
    }

    private List<Long> getPks() {
        ArrayList<Long> list = new ArrayList<Long>();
        String billid = (String)this.getModel().getValue("billid");
        if (!StringUtils.isEmpty((Object)billid)) {
            String[] array = null;
            array = billid.indexOf(10) != -1 ? billid.split("\n") : billid.split(",");
            for (String str : array) {
                list.add(BigDecimalUtil.transDecimal((Object)str).longValue());
            }
        }
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("sentity_key".equals(e.getProperty().getName())) {
            String tentity_key = BillArchiveHelper.getArchiveEnetity((String)((String)this.getModel().getValue("sentity_key")));
            if (!StringUtils.isEmpty((Object)tentity_key)) {
                this.getModel().setValue("tentity_key", (Object)tentity_key);
            } else {
                String tipMsg = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5f52\u6863\u5355\u636e", (String)"BillArchivePlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipMsg, Integer.valueOf(5000));
            }
        }
    }
}

