/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.customsconfig;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.lang3.StringUtils;

public class CustomsRemarkModelPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String remarkId = (String)customParams.get("remarkId");
        List selectKeys = (List)customParams.get("selectKeys");
        List selectNames = (List)customParams.get("selectNames");
        String setSelectedMap = (String)customParams.get("setSelectedMap");
        HashMap<String, DynamicObject> remarkMap = new HashMap<String, DynamicObject>(selectKeys.size());
        if (StringUtils.isNotEmpty((CharSequence)remarkId)) {
            QFilter filter = new QFilter("remarkid", "=", (Object)Long.valueOf(remarkId));
            DynamicObject[] remarkArray = BusinessDataServiceHelper.load((String)"bdm_customs_select_remark", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_customs_select_remark", (boolean)false), (QFilter[])filter.toArray());
            if (remarkArray.length > 0) {
                for (DynamicObject remarkObj : remarkArray) {
                    remarkMap.put(remarkObj.getString("selectkey"), remarkObj);
                }
            }
        }
        this.getView().getModel().batchCreateNewEntryRow(ENTRYENTITY, selectKeys.size());
        for (int i = 0; i < selectKeys.size(); ++i) {
            String selectKey = (String)selectKeys.get(i);
            this.getModel().setValue("selectkey", (Object)selectKey, i);
            if (StringUtils.isBlank((CharSequence)setSelectedMap)) {
                this.getModel().setValue("selectname", selectNames.get(i), i);
                DynamicObject remarkObj = (DynamicObject)remarkMap.get(selectKey);
                String selectalias = remarkObj == null ? (String)selectNames.get(i) : remarkObj.getString("selectalias");
                this.getModel().setValue("selectalias", (Object)selectalias, i);
                String selected = remarkObj == null ? "" : remarkObj.getString("selected");
                this.getModel().setValue("selected", (Object)selected, i);
                continue;
            }
            JSONObject json = JSONObject.parseObject((String)setSelectedMap);
            JSONObject configJson = json.getJSONObject(selectKey);
            if (null == configJson) continue;
            this.getModel().setValue("selectname", configJson.get((Object)"selectname"), i);
            this.getModel().setValue("selectalias", configJson.get((Object)"selectalias"), i);
            this.getModel().setValue("selected", configJson.get((Object)"selected"), i);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String clickKey;
        Control control = (Control)evt.getSource();
        switch (clickKey = control.getKey()) {
            case "btnok": {
                this.confirmRemarkInfo();
            }
        }
    }

    private void confirmRemarkInfo() {
        HashMap map = new HashMap(4);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            HashMap<String, String> singleMap = new HashMap<String, String>(4);
            String selected = object.getString("selected");
            singleMap.put("selectkey", object.getString("selectkey"));
            singleMap.put("selectname", object.getString("selectname"));
            singleMap.put("selectalias", object.getString("selectalias"));
            singleMap.put("selected", selected);
            map.put(object.getString("selectkey"), singleMap);
        }
        Map currentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        currentCustomParams.put("setSelectedMap", map);
        this.getView().returnDataToParent((Object)currentCustomParams);
        this.getView().close();
    }
}

