/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.customsms;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.bo.SmsSettingParamBO;
import kd.imc.bdm.common.enums.SmsBillStatusEnum;
import kd.imc.bdm.common.helper.SmsSettingHelper;
import org.apache.commons.collections.CollectionUtils;

public class SmsSettingListPlugin
extends AbstractListPlugin {
    private static final String SUBMIT_AUDIT = "submit_audit";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{SUBMIT_AUDIT});
    }

    public void beforeBindData(EventObject e) {
        QFilter filter = new QFilter("billstatus", "=", (Object)SmsBillStatusEnum.AUDITTING.getStatusText());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bdm_sms_setting", (String)"id,billstatus,dxqmid,dxqm_status,dxnrid,dxnr_status,failreason", (QFilter[])filter.toArray());
        if (null == dynamicObjects || 0 == dynamicObjects.length) {
            return;
        }
        SmsSettingParamBO smsSettingParam = SmsSettingHelper.getSmsSettingParam();
        List dxqmIds = Arrays.stream(dynamicObjects).filter(a -> StringUtils.isNotEmpty((CharSequence)a.getString("dxqmid"))).map(a -> a.getString("dxqmid")).collect(Collectors.toList());
        List dxnrIds = Arrays.stream(dynamicObjects).filter(a -> StringUtils.isNotEmpty((CharSequence)a.getString("dxnrid"))).map(a -> a.getString("dxnrid")).collect(Collectors.toList());
        Map smsSignatureMap = SmsSettingHelper.querySmsAuditResult((SmsSettingParamBO)smsSettingParam, (String)smsSettingParam.getSmsSignatureApproveGets(), (String)"sid", dxqmIds);
        Map smsModuleMap = SmsSettingHelper.querySmsAuditResult((SmsSettingParamBO)smsSettingParam, (String)smsSettingParam.getSmsModuleApproveGets(), (String)"smscode", dxnrIds);
        this.updateSmsSettingListStatus(dynamicObjects, smsSignatureMap, smsModuleMap);
    }

    private void updateSmsSettingListStatus(DynamicObject[] dynamicObjects, Map<String, JSONObject> smsSignatureMap, Map<String, JSONObject> smsModuleMap) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            SmsSettingHelper.updateSmsSettingStatus(smsSignatureMap, smsModuleMap, (DynamicObject)dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void itemClick(ItemClickEvent evt) {
        if (SUBMIT_AUDIT.equals(evt.getItemKey())) {
            DynamicObject[] loadSettings;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (this.checkSmsSettingList(selectedRows)) {
                return;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            for (DynamicObject loadSetting : loadSettings = BusinessDataServiceHelper.load((String)"bdm_sms_setting", (String)"id,formworkcontent,applyreason,billstatus,dxqmid,dxqm_status,dxnrid,dxnr_status", (QFilter[])idFilter.toArray())) {
                try {
                    SmsSettingHelper.submitAndAudit((DynamicObject)loadSetting);
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38:%s", (String)"SmsSettingListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f", (String)"SmsSettingListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private boolean checkSmsSettingList(ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u77ed\u4fe1\u914d\u7f6e", (String)"SmsSettingListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        List collect = selectedRows.stream().filter(a -> SmsBillStatusEnum.AUDIT_SUCCESS.getStatusText().equals(a.getBillStatus())).collect(Collectors.toList());
        if (0 < collect.size()) {
            StringBuilder errorMsg = new StringBuilder();
            for (ListSelectedRow listSelectedRow : collect) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7:%1$s,\u5ba1\u6838\u72b6\u6001\u662f:%2$s%3$s", (String)"SmsSettingListPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), listSelectedRow.getBillNo(), SmsBillStatusEnum.getDescription((String)listSelectedRow.getBillStatus()), System.lineSeparator()));
            }
            errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u7ee7\u7eed\u63d0\u4ea4\u5ba1\u6279!", (String)"SmsSettingListPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.getView().showMessage(errorMsg.toString());
            return true;
        }
        return SmsSettingHelper.checkSubmitAuditSize((AbstractFormPlugin)this, (Integer)selectedRows.size());
    }
}

