/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.customsms;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.bo.SmsSettingParamBO;
import kd.imc.bdm.common.constant.SmsSettingConstant;
import kd.imc.bdm.common.enums.SmsBillStatusEnum;
import kd.imc.bdm.common.helper.SmsSettingHelper;

public class SmsSettingPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SmsSettingPlugin.class);
    private static final String TBMAIN = "tbmain";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TBMAIN});
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        filterGrid.setEntityNumber("sim_vatinvoice");
        this.updateSignatureAndModuleStatus();
        this.setVisible();
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        FilterCondition filterCondition = null;
        String s = this.getModel().getDataEntity().getString("filtertag");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": {
                if (!this.save()) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_edit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit_audit"});
                this.getView().setStatus(OperationStatus.VIEW);
                break;
            }
            case "submit_audit": {
                this.submitAudit();
                break;
            }
            case "bar_edit": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit_audit"});
                this.getView().setStatus(OperationStatus.EDIT);
                break;
            }
        }
    }

    private void setVisible() {
        long id = this.getModel().getDataEntity().getLong("id");
        if (0L != id) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setStatus(OperationStatus.VIEW);
            String billStatus = this.getModel().getDataEntity().getString("billstatus");
            if (!SmsSettingConstant.BILL_STATUS_CAN_SUBMIT.contains(billStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit_audit"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_edit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit_audit"});
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    private void updateSignatureAndModuleStatus() {
        Long id = this.getModel().getDataEntity().getLong("id");
        if (Long.valueOf(0L).equals(id)) {
            return;
        }
        SmsSettingParamBO smsSettingParam = SmsSettingHelper.getSmsSettingParam();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map signatureMap = SmsSettingHelper.getAuditResult((DynamicObject)dataEntity, (SmsSettingParamBO)smsSettingParam, (String)"dxqmid", (String)smsSettingParam.getSmsSignatureApproveGets(), (String)"sid");
        Map moduleMap = SmsSettingHelper.getAuditResult((DynamicObject)dataEntity, (SmsSettingParamBO)smsSettingParam, (String)"dxnrid", (String)smsSettingParam.getSmsModuleApproveGets(), (String)"smscode");
        SmsSettingHelper.updateSmsSettingStatus((Map)signatureMap, (Map)moduleMap, (DynamicObject)dataEntity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save() {
        String lockKey = "smsSetting-" + RequestContext.get().getOrgId();
        try (DLock lock = DLock.create((String)lockKey);){
            if (!lock.tryLock(10000L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"SmsSettingPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (this.checkFormworkContent() || this.checkNameAndPriority() || this.checkBillNo()) {
                boolean bl2 = false;
                return bl2;
            }
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            this.getModel().setValue("filtertag", (Object)SerializationUtils.toJsonString((Object)filterCondition));
            OperationResult operationResult = this.getView().invokeOperation("save");
            boolean bl = operationResult.isSuccess();
            return bl;
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
            return false;
        }
        catch (Exception e) {
            LOGGER.error("smsSettingSaveError:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u77ed\u4fe1\u8bbe\u7f6e\u5931\u8d25\uff0c%s", (String)"SmsSettingPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return false;
    }

    private boolean checkBillNo() {
        QFilter filter = new QFilter("billno", "=", (Object)this.getModel().getDataEntity().getString("billno"));
        DynamicObjectCollection smsSettingList = QueryServiceHelper.query((String)"bdm_sms_setting", (String)"id", (QFilter[])new QFilter[]{filter});
        if (smsSettingList.size() > 1 || smsSettingList.size() == 1 && !((DynamicObject)smsSettingList.get(0)).get("id").equals(this.getModel().getDataEntity().get("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\"\u7f16\u53f7\"\uff0c\u8bf7\u52ff\u63d0\u4ea4", (String)"SmsSettingPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return true;
        }
        return false;
    }

    private boolean checkNameAndPriority() {
        QFilter filter = new QFilter("name", "=", (Object)this.getModel().getDataEntity().getString("name"));
        filter.and(new QFilter("priority", "=", (Object)this.getModel().getDataEntity().getString("priority")));
        DynamicObjectCollection smsSettingList = QueryServiceHelper.query((String)"bdm_sms_setting", (String)"id", (QFilter[])new QFilter[]{filter});
        if (smsSettingList.size() > 1 || smsSettingList.size() == 1 && !((DynamicObject)smsSettingList.get(0)).get("id").equals(this.getModel().getDataEntity().get("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\"\u65b9\u6848\u540d\u79f0\"\u548c\"\u4f18\u5148\u7ea7\"\uff0c\u8bf7\u52ff\u63d0\u4ea4", (String)"SmsSettingPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return true;
        }
        return false;
    }

    private boolean checkFormworkContent() {
        String formworkContent = this.getModel().getDataEntity().getString("formworkcontent");
        if (StringUtils.isEmpty((CharSequence)formworkContent)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u6a21\u677f\u5185\u5bb9\"", (String)"SmsSettingPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return true;
        }
        QFilter filter = new QFilter("formworkcontent", "=", (Object)this.getModel().getDataEntity().getString("formworkcontent"));
        DynamicObjectCollection smsSettingList = QueryServiceHelper.query((String)"bdm_sms_setting", (String)"id", (QFilter[])new QFilter[]{filter});
        if (smsSettingList.size() > 1 || smsSettingList.size() == 1 && !((DynamicObject)smsSettingList.get(0)).get("id").equals(this.getModel().getDataEntity().get("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\"\u6a21\u677f\u5185\u5bb9\"\uff0c\u8bf7\u52ff\u63d0\u4ea4", (String)"SmsSettingPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return true;
        }
        return false;
    }

    private void submitAudit() {
        if (SmsSettingHelper.checkSubmitAuditSize((AbstractFormPlugin)this, (Integer)1)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String billStatus = dataEntity.getString("billstatus");
        if (SmsBillStatusEnum.submitAudit((String)billStatus)) {
            boolean visible;
            try {
                SmsSettingHelper.submitAndAudit((DynamicObject)dataEntity);
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f", (String)"SmsSettingPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                visible = true;
            }
            catch (Exception e) {
                try {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6838\u5f02\u5e38:%s", (String)"SmsSettingPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
                catch (Throwable throwable) {
                    boolean visible2 = true;
                    QFilter idFilter = new QFilter("id", "=", (Object)dataEntity.getLong("id"));
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bdm_sms_setting", (String)"id,billstatus", (QFilter[])idFilter.toArray());
                    billStatus = object.getString("billstatus");
                    if (null != billStatus && SmsSettingConstant.BILL_STATUS_CANNOT_SUBMIT.contains(billStatus)) {
                        visible2 = false;
                    }
                    this.getView().setVisible(Boolean.valueOf(visible2), new String[]{"bar_edit"});
                    this.getView().setVisible(Boolean.valueOf(visible2), new String[]{"submit_audit"});
                    throw throwable;
                }
            }
            QFilter idFilter = new QFilter("id", "=", (Object)dataEntity.getLong("id"));
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bdm_sms_setting", (String)"id,billstatus", (QFilter[])idFilter.toArray());
            billStatus = object.getString("billstatus");
            if (null != billStatus && SmsSettingConstant.BILL_STATUS_CANNOT_SUBMIT.contains(billStatus)) {
                visible = false;
            }
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"bar_edit"});
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"submit_audit"});
        }
    }
}

