/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.downloadcenter;

import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.HiddenButtonHelper;
import kd.imc.bdm.common.helper.PermissionHelper;

public class DownloadCenterListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        QFilter applicantFilter = new QFilter("applicant", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        e.getCustomQFilters().add(applicantFilter);
        QFilter delStateQFilter = new QFilter("delstate", "=", (Object)"1");
        e.getCustomQFilters().add(delStateQFilter);
    }

    public void afterCreateNewData(EventObject e) {
        HiddenButtonHelper.hideClose((AbstractFormPlugin)this, (String[])new String[]{"close"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IListView view = (IListView)this.getView();
        if ("btn_download".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ListSelectedRowCollection selectCollection = ((IListView)this.getView()).getSelectedRows();
            FileService fs = FileServiceFactory.getAttachmentFileService();
            String fields = "filename,fileurl,file_detail.detail_url as detail_url,file_detail.detail_file_name as detail_file_name";
            QFilter filter1 = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            QFilter filter2 = new QFilter("handlestate", "=", (Object)"2");
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdm_download_center", (String)fields, (QFilter[])new QFilter[]{filter1, filter2});
            String url = null;
            try {
                for (DynamicObject obj : collection) {
                    if (!StringUtils.isEmpty((Object)obj.getString("fileurl"))) {
                        url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(obj.getString("filename"), fs.getInputStream(obj.getString("fileurl")), 7200);
                    } else if (!StringUtils.isEmpty((Object)obj.getString("detail_url"))) {
                        url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(obj.getString("detail_file_name"), fs.getInputStream(obj.getString("detail_url")), 7200);
                    }
                    if (url == null) continue;
                    this.getView().openUrl(url);
                    PermissionHelper.checkTempFilePermission((String)url, (String)"bdm", (String)"bdm_download_center_v1", (String)ImcPermItemEnum.ITEM_DOWNLOAD.getPermId());
                }
            }
            catch (Exception e) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff01", (String)"DownloadCenterListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            view.refresh();
        }
    }
}

