/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.equipment;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.EquipmentType;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.bdm.formplugin.equipment.control.AddEquipmentControl;
import kd.imc.bdm.formplugin.equipment.control.EquipmentListControl;

public class EquipmentListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        HasPermOrgResultImpl result = OrgHelper.getUserHasPermEpInfo();
        if (!result.hasAllOrgPerm()) {
            e.getCustomQFilters().add(OrgHelper.getIdFilter((Collection)result.getHasPermOrgs(), (String)"epinfo"));
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"activate"});
    }

    public void createNewData(BizDataEventArgs e) {
        new AddEquipmentControl().getLYIsActive();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "activate": {
                DynamicObject[] equipmentList;
                Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
                for (DynamicObject equipmentDO : equipmentList = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_tax_equipment"))) {
                    if ("1".equals(equipmentDO.getString("authstatus"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u5df2\u6fc0\u6d3b", (String)"EquipmentListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), equipmentDO.getString("equipmentno")));
                    }
                    if ("2".equals(equipmentDO.getString("authstatus"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u6fc0\u6d3b\u4e2d\uff0c\u8bf7\u7a0d\u5019", (String)"EquipmentListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]), equipmentDO.getString("equipmentno")));
                    }
                    if (!TaxUtils.isEnterpriseAuth((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)equipmentDO.get("epinfo")))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u6240\u5c5e\u4f01\u4e1a\u7a0e\u53f7\u8fd8\u672a\u6388\u6743\uff0c\u8bf7\u5148\u524d\u5f80'\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u8bb8\u53ef\u6388\u6743'\u8fdb\u884c\u8bb8\u53ef\u6388\u6743 ", (String)"EquipmentListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]), equipmentDO.getString("equipmentno")));
                    }
                    if ((EquipmentType.isLyServer((String)equipmentDO.getString("equipmenttype")) || "8".equals(equipmentDO.getString("equipmenttype"))) && StringUtils.isEmpty((CharSequence)equipmentDO.getString("cabinet"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u672a\u914d\u7f6e\u673a\u67dc\u4fe1\u606f\uff0c\u65e0\u6cd5\u6fc0\u6d3b", (String)"EquipmentListPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]), equipmentDO.getString("equipmentno")));
                    }
                    if (!"0".equalsIgnoreCase(equipmentDO.getString("disen"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7%s\u5df2\u88ab\u7981\u7528\u65e0\u6cd5\u6fc0\u6d3b", (String)"EquipmentListPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), equipmentDO.getString("equipmentno")));
                }
                if (primaryKeyValues.length > 0) {
                    ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)String.format(ResManager.loadKDString((String)"\u8bf7\u518d\u6b21\u786e\u8ba4\u8bbe\u5907\u4fe1\u606f\u6b63\u786e\uff0c\u6fc0\u6d3b\u6210\u529f\u540e\u4e0d\u53ef\u9006\uff0c\u786e\u8ba4\u6fc0\u6d3b\uff1f%s", (String)"EquipmentListPlugin_10", (String)"imc-bdm-formplugin", (Object[])new Object[0]), "\n"), (String)"activate");
                }
                StringBuilder sb = new StringBuilder();
                for (Object primaryKeyValue : primaryKeyValues) {
                    sb.append(primaryKeyValue).append(',');
                }
                this.getPageCache().put("selectList", sb.toString());
                break;
            }
            case "refresh": {
                new AddEquipmentControl().getLYIsActive();
                break;
            }
            case "allocation": {
                Object[] primaryKeyValues = ((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues.length <= 0) break;
                if (primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u8868\u53ea\u80fd\u52fe\u9009\u4e00\u4e2a\u8bbe\u5907\u8fdb\u884c\u5206\u914d\u7ec4\u7ec7", (String)"EquipmentListPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject equipmentDO = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValues[0], (String)"bdm_tax_equipment");
                DynamicObject epInfoDO = equipmentDO.getDynamicObject("epinfo");
                QFilter qFilter = new QFilter("epinfo", "=", epInfoDO.getPkValue()).and("enterprisemainorg", "=", (Object)"1");
                DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])qFilter.toArray());
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u672a\u5173\u8054\u7ec4\u7ec7", (String)"EquipmentListPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("equipmentid", equipmentDO.getPkValue());
                customParams.put("devNo", equipmentDO.getString("equipmentno"));
                customParams.put("terminalNo", equipmentDO.getString("terminalno"));
                customParams.put("orgId", org.getPkValue());
                ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"bdm_dev_bind_org", (String)"bdm_dev_bind_org");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        if ("activate".equals(closedEvent.getCallBackId()) && closedEvent.getResult().name().equals("Yes")) {
            String selectList = this.getPageCache().get("selectList");
            String[] split = selectList.split(",");
            DynamicObject[] equipmentList = BusinessDataServiceHelper.load((Object[])Arrays.stream(split).map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_tax_equipment"));
            EquipmentListControl control = new EquipmentListControl();
            for (DynamicObject equipmentDO : equipmentList) {
                MsgResponse msgResponse = EquipmentListPlugin.doEquipmentActiveRequest(equipmentDO);
                if (!ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6fc0\u6d3b\u5931\u8d25:%s", (String)"EquipmentListPlugin_11", (String)"imc-bdm-formplugin", (Object[])new Object[0]), msgResponse.getErrorMsg()));
                }
                control.activeEquipment(equipmentDO);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6fc0\u6d3b\u6210\u529f", (String)"EquipmentListPlugin_9", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public static MsgResponse doEquipmentActiveRequest(DynamicObject equipmentDO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("devno", (Object)equipmentDO.getString("equipmentno"));
        jsonObject.put("devtype", (Object)equipmentDO.getString("equipmenttype"));
        jsonObject.put("taxno", (Object)equipmentDO.getString("epinfo.number"));
        jsonObject.put("taxname", (Object)equipmentDO.getString("epinfo.name"));
        jsonObject.put("fjh", (Object)equipmentDO.getString("fjh"));
        jsonObject.put("terminalcode", (Object)equipmentDO.getString("terminalno"));
        jsonObject.put("cabinet", (Object)equipmentDO.getString("cabinet"));
        return RequestUtils.doRequest((String)UUID.next(), (String)"EquipmentActive", (Object)jsonObject);
    }
}

