/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicepermission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcLicenseServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.service.CAService;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.common.util.ViewUtil;

public class InvoicePermissionListPlugin
extends AbstractTreeListPlugin {
    private Log LOGGER = LogFactory.getLog(InvoicePermissionListPlugin.class);
    private static final String CURRENT_NODE = "current_node";

    public void setFilter(SetFilterEvent e) {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isNotBlank((CharSequence)currentNode) && !"-1".equals(currentNode)) {
            if ("2".equals(currentNode)) {
                e.setMainOrgQFilter(new QFilter("orginfo", "=", (Object)0));
            }
            QFilter qFilter = new QFilter("servergroup", "=", (Object)currentNode);
            e.getCustomQFilters().add(qFilter);
            this.getTreeListView().getTreeModel().getRoot().getChildren().stream().filter(node -> node.getId().equals(currentNode)).findFirst().ifPresent(node -> this.getTreeListView().getTreeView().focusNode(node));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("authorize".equals(key)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.IMC_PERMISSION_AUTH);
            try {
                this.checkAuthData();
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
                return;
            }
            ViewUtil.openNormalConfirm((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u6388\u6743\u540e\u5c06\u65e0\u6cd5\u4fee\u6539\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e14\u65e0\u6cd5\u64a4\u9500\uff0c \u8bf7\u786e\u4fdd\u7a0e\u53f7\u4fe1\u606f\u7684\u51c6\u786e\u6027\u3002 \u786e\u5b9a\u8981\u6388\u6743\u5417\uff1f", (String)"InvoicePermissionListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]), (String)evt.getItemKey());
        } else if ("btn_refresh".equals(key)) {
            this.refreshList();
        } else if ("btn_select".equals(key)) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bdm_enterprise_baseinfo", (boolean)true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectEp"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void refreshList() {
        this.loadTree();
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    private void checkAuthData() {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isBlank((CharSequence)currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6388\u6743\u7684\u670d\u52a1", (String)"InvoicePermissionListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (!PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode) && !PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u670d\u52a1\u6682\u4e0d\u652f\u6301\u6388\u6743", (String)"InvoicePermissionListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6388\u6743\u7684\u8bb0\u5f55!", (String)"InvoicePermissionListPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        String batchType = objs[0].getString("equipmenttype");
        for (DynamicObject obj : objs) {
            if ("1".equals(obj.get("authstate"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6570\u636e\u6388\u6743\u72b6\u6001\u5305\u542b\u5df2\u6388\u6743\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u6b21\u8fdb\u884c\u6388\u6743\uff01", (String)"InvoicePermissionListPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            if (batchType.equals(obj.getString("equipmenttype"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6570\u636e\u8bbe\u5907\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u6279\u91cf\u8fdb\u884c\u6388\u6743\uff01", (String)"InvoicePermissionListPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        this.checkRemainLicenseCount(currentNode, objs);
    }

    private void checkRemainLicenseCount(String currentNode, DynamicObject[] objs) {
        HashSet<Long> selectEpInfo = new HashSet<Long>(objs.length);
        Set<Long> usedEpInfos = this.getLicenseUseEpInfo(currentNode);
        for (DynamicObject obj : objs) {
            long epinfoId = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("epinfo"));
            if (epinfoId == 0L || usedEpInfos.contains(epinfoId)) continue;
            selectEpInfo.add(epinfoId);
        }
        int total = ImcLicenseServiceHelper.getLicenseTotalNumber((String)currentNode);
        if (total - usedEpInfos.size() - selectEpInfo.size() < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5269\u4f59\u8bb8\u53ef\u6570\u91cf\u4e0d\u591f\uff0c\u8bf7\u8d2d\u4e70\u540e\u518d\u8fdb\u884c\u6388\u6743\uff01", (String)"InvoicePermissionListPlugin_6", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("authorize".equals(callBackId)) {
            PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_PERMISSION_AUTH);
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.authorizationOpr();
                this.refreshList();
            }
        }
    }

    private void authorizationOpr() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdm_invoice_permission"));
        ArrayList<String> taxnoList = new ArrayList<String>(objs.length);
        for (DynamicObject obj : objs) {
            String epinfoNumber = obj.getString("epinfo.number");
            if (taxnoList.contains(epinfoNumber)) continue;
            taxnoList.add(epinfoNumber);
        }
        if (CollectionUtils.isEmpty(taxnoList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6570\u636e\u672a\u5305\u542b\u7a0e\u53f7\u4fe1\u606f,\u65e0\u6cd5\u6388\u6743!", (String)"InvoicePermissionListPlugin_7", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(currentNode) || PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo().equals(currentNode)) {
            this.checkRemainLicenseCount(currentNode, objs);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
            RequestContext request = RequestContext.get();
            for (DynamicObject obj : objs) {
                if ("1".equals(obj.getString("authstate"))) continue;
                obj.set("authstate", (Object)"1");
                obj.set("userfield", (Object)request.getUserId());
                obj.set("authdate", (Object)new Date());
                updateList.add(obj);
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            ThreadPoolsHelper.batchApplyCaThreadPool.execute(() -> {
                RequestContext.copyAndSet((RequestContext)request);
                CAService.batchApplyCA(new ArrayList<DynamicObject>(Arrays.asList(objs)));
            });
        }
    }

    private void loadTree() {
        String currentNode;
        this.getView().setVisible(Boolean.FALSE, new String[]{"btn_select"});
        this.initInvoiceWarningPerm();
        this.getTreeListView().getTreeView().deleteAllNodes();
        TreeNode root = this.createRootNode();
        this.getTreeListView().getTreeModel().setRoot(root);
        this.getTreeListView().getTreeView().addNode(root);
        String permissionNo = currentNode = this.getPageCache().get(CURRENT_NODE);
        if (currentNode == null) {
            permissionNo = PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo();
        }
        String permission = permissionNo;
        this.getTreeListView().getTreeView().treeNodeClick("-1", permission);
        root.getChildren().stream().filter(node -> node.getId().equals(permission)).findFirst().ifPresent(node -> this.getTreeListView().getTreeView().focusNode(node));
    }

    private void initInvoiceWarningPerm() {
        int totalNumber = ImcLicenseServiceHelper.getLicenseTotalNumber((String)PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo());
        QFilter filter = new QFilter("servergroup", "=", (Object)PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo());
        DeleteServiceHelper.delete((String)"bdm_invoice_permission", (QFilter[])filter.toArray());
        if (totalNumber <= 0) {
            return;
        }
        DynamicObject invoiceWarningPerm = BusinessDataServiceHelper.newDynamicObject((String)"bdm_invoice_permission");
        invoiceWarningPerm.set("servergroup", (Object)PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo());
        invoiceWarningPerm.set("authstate", (Object)"1");
        Map dateRange = ImcLicenseServiceHelper.getDateRange((Long)Long.parseLong(CacheKeyEnum.IREW_INVOICE_PERMISSION_AUTH_GROUP_ID.getDefaultValue()));
        if (!CollectionUtils.isEmpty((Map)dateRange)) {
            Date beginDate = (Date)dateRange.get("beginDate");
            Date endDate = (Date)dateRange.get("expireDate");
            invoiceWarningPerm.set("validstarttime", (Object)beginDate);
            invoiceWarningPerm.set("validendtime", (Object)endDate);
            this.LOGGER.info("\u8bb8\u53ef\u63a7\u5236\u521d\u59cb\u5316\u65e5\u671f{}", (Object)dateRange);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceWarningPerm});
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
    }

    public void initializeTree(EventObject e) {
        this.loadTree();
    }

    private TreeNode createRootNode() {
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.addChildren(this.createTreeNodeChildren());
        root.setIsOpened(true);
        String tipMsg = ResManager.loadKDString((String)"\u5168\u90e8", (String)"InvoiceTypeManageFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        root.setText(tipMsg);
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("level", "0");
        root.setData(data);
        root.setLongNumber(root.getId());
        return root;
    }

    private List<TreeNode> createTreeNodeChildren() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(4);
        for (PermissionEnum permission : PermissionEnum.values()) {
            TreeNode node = new TreeNode();
            node.setId(permission.getPermissionNo());
            HashMap<String, String> data = (HashMap<String, String>)node.getData();
            if (data == null) {
                data = new HashMap<String, String>();
            }
            data.put("level", "1");
            String name = permission.getName();
            String description = this.getPermissionUseDescription(permission);
            node.setText(name + description);
            node.setParentid("-1");
            node.setData(data);
            nodes.add(node);
        }
        return nodes;
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        if (PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo().equals(nodeId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_select"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_select"});
        }
        if (PermissionEnum.INVOICE_WARNING_SERVICE.getPermissionNo().equals(nodeId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"authorize"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"authorize"});
        }
        this.getPageCache().put(CURRENT_NODE, nodeId);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    private String getPermissionUseDescription(PermissionEnum permission) {
        if (PermissionEnum.INVOICE_WARNING_SERVICE == permission) {
            int totalNumber = ImcLicenseServiceHelper.getLicenseTotalNumber((String)permission.getPermissionNo());
            if (totalNumber > 0) {
                return "\uff081/1\uff09";
            }
            return "\uff080/0\uff09";
        }
        if (permission != PermissionEnum.ISSUE_INVOICE_SERVICE && permission != PermissionEnum.COLLECT_INVOICE_SERVICE) {
            return "\uff080/0\uff09";
        }
        return String.format("\uff08%d/%d\uff09", this.getLicenseUseEpInfo(permission.getPermissionNo()).size(), ImcLicenseServiceHelper.getLicenseTotalNumber((String)permission.getPermissionNo()));
    }

    private Set<Long> getLicenseUseEpInfo(String permissionType) {
        QFilter filter = new QFilter("authstate", "=", (Object)"1").and("servergroup", "=", (Object)permissionType);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bdm_invoice_permission", (String)"epinfo", (QFilter[])filter.toArray());
        HashSet<Long> distinctCount = new HashSet<Long>(objs.length);
        for (DynamicObject obj : objs) {
            long epInfoPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("epinfo"));
            if (epInfoPk == 0L) continue;
            distinctCount.add(epInfoPk);
        }
        return distinctCount;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRows;
        String actionId = closedCallBackEvent.getActionId();
        if ("selectEp".equals(actionId) && (selectRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !selectRows.isEmpty()) {
            InputPermissionUtils.saveInputPermissionByEp((Object[])selectRows.getPrimaryKeyValues());
            this.refreshList();
        }
    }
}

