/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.invoicetitle.strategy;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.InvIssueTitleConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.model.TitleOtherItem;
import kd.imc.bdm.common.service.OpenInvoiceService;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;

public class InvoiceIssueTitleSavePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String EVENT_QUERY_TITLE = "queryTitle";
    private static final String CUSTOM_EVENT = "eventkey";
    private static final String EVENT_UPDATE_BUYER_TAX_NO = "updateBuyerTaxNo";

    public void afterBindData(EventObject e) {
        HashMap<String, Object> showDataMap = new HashMap<String, Object>();
        CustomControl control = (CustomControl)this.getControl("epnamequery");
        showDataMap.put("showSearchIcon", "none");
        showDataMap.put("inputStyle", "border: none; border-bottom: 1px solid #999;");
        showDataMap.put("buyerNameTxt", ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue());
        showDataMap.put("pageId", this.getView().getPageId());
        showDataMap.put("time", System.currentTimeMillis());
        control.setData(showDataMap);
        boolean visible = CacheKeyEnum.ELE_SCHEDULE_CONFIG.getConfigType().equals(ImcConfigUtil.getValue((String)CacheKeyEnum.ELE_SCHEDULE_CONFIG.getConfigType(), (String)CacheKeyEnum.ELE_SCHEDULE_CONFIG.getConfigKey()));
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"eleschedule"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"name"});
    }

    public void customEvent(CustomEventArgs e) {
        String event = e.getEventName();
        String ars = e.getEventArgs();
        if (EVENT_QUERY_TITLE.equals(event)) {
            this.getModel().setValue("name", (Object)ars);
            this.getView().addClientCallBack(EVENT_QUERY_TITLE);
        } else if (EVENT_UPDATE_BUYER_TAX_NO.equals(event)) {
            JSONObject argsJson = JSONObject.parseObject((String)ars);
            IDataModel model = this.getModel();
            model.setValue("name", (Object)argsJson.getString("name"));
            String tax = argsJson.getString("tax");
            if (StringUtils.isNotBlank((CharSequence)tax)) {
                model.setValue("taxno", (Object)argsJson.getString("tax"));
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (EVENT_QUERY_TITLE.equals(e.getName())) {
            String ars = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
            HashMap<String, Object> showDataMap = new HashMap<String, Object>(4);
            showDataMap.put(CUSTOM_EVENT, EVENT_QUERY_TITLE);
            OpenInvoiceService openInvoiceService = new OpenInvoiceService();
            List companyInfos = openInvoiceService.queryCompany(ars);
            showDataMap.put("companyInfos", companyInfos);
            CustomControl control = (CustomControl)this.getControl("epnamequery");
            showDataMap.put("time", System.currentTimeMillis());
            showDataMap.put("pageId", this.getView().getPageId());
            control.setData(showDataMap);
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"otheradd", "setotherdefault", "otheredit", "delother"});
        BasedataEdit custom = (BasedataEdit)this.getView().getControl("custom");
        custom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "otheradd": {
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)InvIssueTitleConstant.OTHER_FORM, (String)InvIssueTitleConstant.OTHER_FORM);
                break;
            }
            case "setotherdefault": {
                this.setOtherDefaultOrDeleteOrEdit(0);
                break;
            }
            case "otheredit": {
                this.setOtherDefaultOrDeleteOrEdit(2);
                break;
            }
            case "delother": {
                this.setOtherDefaultOrDeleteOrEdit(1);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("custom".equals(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject custom = (DynamicObject)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            IDataModel model = this.getModel();
            if (custom == null) {
                model.setValue("customerno", (Object)"", rowIndex);
                model.setValue("customername", (Object)"", rowIndex);
                model.setValue("customertaxno", (Object)"", rowIndex);
                return;
            }
            model.setValue("customerno", custom.get("number"), rowIndex);
            model.setValue("customername", custom.get("name"), rowIndex);
            model.setValue("customertaxno", custom.get("tx_register_no"), rowIndex);
            DynamicObjectCollection items = this.getModel().getEntryEntity("cust");
            if (items.getRowCount() == 1) {
                if (StringUtils.isBlank((Object)this.getModel().getValue("taxno"))) {
                    this.getModel().setValue("taxno", custom.get("tx_register_no"));
                }
                if (StringUtils.isBlank((CharSequence)((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue())) {
                    this.getModel().setValue("name", custom.get("name"));
                    HashMap<String, String> showDataMap = new HashMap<String, String>();
                    showDataMap.put("buyername", custom.getString("name"));
                    showDataMap.put(CUSTOM_EVENT, "updateTitle");
                    ViewUtil.bindDataToHtml((AbstractFormPlugin)this, showDataMap, (String)"epnamequery");
                }
            }
        }
        if ("buyertype".equals(e.getProperty().getName())) {
            this.getModel().setValue("taxno", (Object)"");
            this.getModel().setValue("idcode", (Object)"");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject[] issueArray;
        HashSet custNumberSet = Sets.newHashSet();
        DynamicObjectCollection custOrders = this.getModel().getEntryEntity("cust");
        custOrders.forEach(o -> custNumberSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)o.get("custom"))));
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("createorg"));
        orgId = orgId == 0L ? RequestContext.get().getOrgId() : orgId;
        QFilter filter = ImcBaseDataHelper.getInvTitleFilter((Object)orgId);
        for (DynamicObject issue : issueArray = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])filter.toArray())) {
            DynamicObjectCollection custArray = issue.getDynamicObjectCollection("cust");
            custArray.forEach(o -> custNumberSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)o.get("custom"))));
        }
        Control control = (Control)event.getSource();
        if (control.getKey().equals("custom")) {
            filter = new QFilter("id", "not in", (Object)custNumberSet.toArray());
            ArrayList filterList = Lists.newArrayListWithExpectedSize((int)1);
            filterList.add(filter);
            event.setCustomQFilters((List)filterList);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        TitleOtherItem otherItem;
        if (InvIssueTitleConstant.OTHER_FORM.equals(event.getActionId()) && Objects.nonNull(otherItem = (TitleOtherItem)event.getReturnData())) {
            this.setOtherItemToCache(otherItem);
        }
    }

    private void setOtherItemToCache(TitleOtherItem otherItem) {
        if ("edit".equals(otherItem.getOperate())) {
            this.setItem(otherItem, otherItem.getSelectRow());
        } else {
            int newEntryRow = this.getModel().createNewEntryRow("items");
            this.setItem(otherItem, newEntryRow);
        }
    }

    private void setItem(TitleOtherItem otherItem, int row) {
        String tipMsg = ResManager.loadKDString((String)"\u65e0", (String)"InvoiceSettingTabPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("otherid", (Object)otherItem.getId(), row);
        this.getModel().setValue("itemaddr", (Object)(StringUtils.isBlank((CharSequence)otherItem.getAddr()) ? tipMsg : otherItem.getAddr()), row);
        this.getModel().setValue("itemopeningbank", (Object)(StringUtils.isBlank((CharSequence)otherItem.getOpeningBank()) ? tipMsg : otherItem.getOpeningBank()), row);
        this.getModel().setValue("itemcontacts", (Object)otherItem.getContacts(), row);
        this.getModel().setValue("itemmobilephone", (Object)otherItem.getMobilePhone(), row);
        this.getModel().setValue("itememail", (Object)otherItem.getEmail(), row);
        this.getModel().setValue("priority", (Object)otherItem.getPriority(), row);
        this.getModel().setValue("filter_tag", (Object)otherItem.getFilter(), row);
        this.getModel().setValue("isdefault", (Object)(otherItem.getIsDefault() ? "1" : "0"), row);
    }

    private void setOtherDefaultOrDeleteOrEdit(int flag) {
        DynamicObjectCollection collection = this.getView().getModel().getEntryEntity("items");
        EntryGrid entryGrid = (EntryGrid)this.getControl("items");
        int row = entryGrid.getSelectRows()[0];
        DynamicObject object = (DynamicObject)collection.get(row);
        if (0 == flag) {
            for (int i = 0; i < collection.size(); ++i) {
                this.getModel().setValue("isdefault", (Object)(row == i ? "1" : "0"), i);
            }
        } else if (1 == flag) {
            this.getModel().deleteEntryRow("items", row);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            TitleOtherItem otherItem = (TitleOtherItem)DynamicObjectUtil.dynamicObject2Bean(TitleOtherItem.class, (DynamicObject)object);
            otherItem.setIsDefault(object.getString("isdefault").equals("1"));
            otherItem.setSelectRow(Integer.valueOf(row));
            map.put("operate", "edit");
            map.put("row", row);
            map.put("otherItem", otherItem);
            ViewUtil.openDialog((AbstractFormPlugin)this, map, (String)InvIssueTitleConstant.OTHER_FORM, (String)InvIssueTitleConstant.OTHER_FORM);
        }
    }
}

