/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.issuesetting;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.enums.DrawerStrategyEnum;
import kd.imc.bdm.common.enums.PayeeStrategyEnum;
import kd.imc.bdm.common.enums.ReviewerStrategyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.PropertieUtil;

public class StrategyDetailPlugin
extends AbstractFormPlugin {
    private String KEY_NAME = "name";
    private String KEY_NUMBER = "number";
    private String KEY_CREATOR = "creator";
    private String KEY_ORGS = "orgs";
    private String KEY_PRIORITY = "priority";
    private String KEY_DRAWERSTRATEGY = "drawerstrategy";
    private String KEY_APPOINTDRAWER = "appointdrawer";
    private String KEY_DRAWER_EDIT = "draweredit";
    private String KEY_PAYEE = "payee";
    private String KEY_APPOINTPAYEE = "appointpayee";
    private String KEY_PAYEE_EDIT = "payeeedit";
    private String KEY_REVIEWER = "reviewer";
    private String KEY_APPOINTREVIEWER = "appointreviewer";
    private String KEY_REVIEWER_EDIT = "revieweredit";
    private static final Log LOGGER = LogFactory.getLog(StrategyDetailPlugin.class);
    private static final String EDIT = "EDIT";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        List fieldKeys = SchemeHelper.getFieldKeys();
        SchemeHelper.initializeFilterGrid((FilterGrid)filterGrid, (List)fieldKeys, (String)"sim_original_bill");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "exit": {
                this.getView().close();
            }
        }
    }

    private void save() {
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(EDIT))) {
            PermissionHelper.checkPermission((String)"bdm", (String)"bdm_drawer_strategy", (ImcPermItemEnum)ImcPermItemEnum.ITEM_EDIT);
        } else {
            PermissionHelper.checkPermission((String)"bdm", (String)"bdm_drawer_strategy", (ImcPermItemEnum)ImcPermItemEnum.ITEM_NEW);
        }
        String lockKey = "DrawerStrategy" + RequestContext.get().getOrgId();
        try (DLock lock = DLock.create((String)lockKey);){
            DynamicObject strategy;
            if (!lock.tryLock(10000L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"StrategyDetailPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            Object number = this.getModel().getValue(this.KEY_NUMBER);
            Object pk = this.getModel().getValue("pk");
            if (!"0".equalsIgnoreCase(String.valueOf(pk))) {
                strategy = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_drawer_strategy");
            } else {
                strategy = BusinessDataServiceHelper.newDynamicObject((String)"bdm_drawer_strategy");
                strategy.set("creator", (Object)RequestContext.get().getUserId());
                strategy.set("createtime", (Object)new Date());
            }
            Object name = this.getModel().getValue(this.KEY_NAME);
            String tipMsg = ResManager.loadKDString((String)"\u7b56\u7565\u540d\u79f0", (String)"StrategyDetailPlugin_23", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.checkEmpty(name, tipMsg);
            strategy.set("name", name);
            strategy.set("number", number);
            QFilter filter = new QFilter("number", "=", number);
            if ("0".equalsIgnoreCase(String.valueOf(pk)) && QueryServiceHelper.exists((String)"bdm_drawer_strategy", (QFilter[])filter.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"StrategyDetailPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            HashMap<Object, Object> orgMap = new HashMap<Object, Object>();
            DynamicObjectCollection itemsNew = this.dealOrgs(orgMap);
            Object priority = this.getModel().getValue(this.KEY_PRIORITY);
            String tipMsg2 = ResManager.loadKDString((String)"\u4f18\u5148\u7ea7", (String)"StrategyDetailPlugin_24", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.checkEmpty(priority, tipMsg2);
            strategy.set("priority", priority);
            Object drawerStrategy = this.getModel().getValue(this.KEY_DRAWERSTRATEGY);
            this.dealDrawer(strategy, drawerStrategy);
            Object payee = this.getModel().getValue(this.KEY_PAYEE);
            this.dealPayee(strategy, payee);
            Object reviewer = this.getModel().getValue(this.KEY_REVIEWER);
            this.dealReviewer(strategy, reviewer);
            this.dealFilter(strategy);
            String strategyStr = String.format("%s,%s,%s", drawerStrategy, payee, reviewer);
            strategy.set("drawerstrategy", (Object)strategyStr);
            this.checkOrgsRepeatPriority(number, orgMap, priority);
            Object pkValue = strategy.getPkValue();
            if (pkValue != null && !Objects.equals(pkValue, 0L)) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bdm_drawer_strategy");
                Iterator collection = obj.getDynamicObjectCollection("item");
                DeleteServiceHelper.delete((IDataEntityType)collection.getDynamicObjectType(), (Object[])collection.stream().map(DataEntityBase::getPkValue).toArray());
            }
            DynamicObjectCollection dynamicObjectCollection = strategy.getDynamicObjectCollection("item");
            dynamicObjectCollection.clear();
            for (DynamicObject object : itemsNew) {
                DynamicObject item = dynamicObjectCollection.addNew();
                DynamicObject sysOrg = object.getDynamicObject("fbasedataid");
                item.set("useorg", sysOrg.getPkValue());
            }
            DynamicObject result = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)strategy);
            this.getModel().setValue("pk", result.getPkValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"StrategyDetailPlugin_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
        }
        catch (MsgException e) {
            this.getView().showErrorNotification(e.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("strategySaveError:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u7b56\u7565\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"StrategyDetailPlugin_5", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkOrgsRepeatPriority(Object number, HashMap<Object, Object> orgMap, Object priority) {
        DynamicObject[] array;
        QFilter allFilter = new QFilter("priority", "=", (Object)Integer.parseInt(String.valueOf(priority))).and("number", "!=", number);
        for (DynamicObject object : array = BusinessDataServiceHelper.load((String)"bdm_drawer_strategy", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_drawer_strategy", (boolean)true), (QFilter[])allFilter.toArray())) {
            DynamicObjectCollection items = object.getDynamicObjectCollection("item");
            for (DynamicObject item : items) {
                Object orgPk;
                DynamicObject org = item.getDynamicObject("useorg");
                if (null == org || !orgMap.containsKey(orgPk = org.getPkValue())) continue;
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u5df2\u7ecf\u5b58\u5728\u4f18\u5148\u7ea7\u4e3a%2$s\u7684\u5f00\u7968\u4eba\u7b56\u7565", (String)"StrategyDetailPlugin_22", (String)"imc-bdm-formplugin", (Object[])new Object[0]), ((DynamicObject)orgMap.get(orgPk)).getString("name"), priority));
            }
        }
    }

    private void dealFilter(DynamicObject strategy) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            String filterStr = SerializationUtils.toJsonString((Object)filterCondition);
            FilterBuilder builder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber()), filterCondition);
            builder.buildFilter();
            strategy.set("filter_tag", (Object)filterStr);
        } else {
            strategy.set("filter_tag", (Object)"");
        }
    }

    private void dealReviewer(DynamicObject strategy, Object reviewer) {
        String tipMsg2 = ResManager.loadKDString((String)"\u590d\u6838\u4eba", (String)"StrategyDetailPlugin_25", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.checkEmpty(reviewer, tipMsg2);
        if (ReviewerStrategyEnum.APPOINT_REVIEWER.getCode().equals(reviewer)) {
            DynamicObject appointReviewer = (DynamicObject)this.getModel().getValue(this.KEY_APPOINTREVIEWER);
            if (appointReviewer != null) {
                strategy.set("reviewerid", (Object)appointReviewer);
                strategy.set("reviewer", (Object)appointReviewer.getString("name"));
            }
        } else if (ReviewerStrategyEnum.PERSON_EDIT.getCode().equals(reviewer)) {
            String reviewerEdit = (String)this.getModel().getValue(this.KEY_REVIEWER_EDIT);
            String tipMsg = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u590d\u6838\u4eba", (String)"StrategyDetailPlugin_26", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            GBKUtils.checkLength((String)reviewerEdit, (String)tipMsg, (Integer)20);
            strategy.set("reviewer", (Object)reviewerEdit);
        } else {
            strategy.set("reviewerid", (Object)0);
            strategy.set("reviewer", (Object)"");
        }
    }

    private void dealPayee(DynamicObject strategy, Object payee) {
        String tipMsg = ResManager.loadKDString((String)"\u6536\u6b3e\u4eba", (String)"StrategyDetailPlugin_27", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.checkEmpty(payee, tipMsg);
        if (PayeeStrategyEnum.APPOINT_PAYEE.getCode().equals(payee)) {
            DynamicObject appointPayee = (DynamicObject)this.getModel().getValue(this.KEY_APPOINTPAYEE);
            if (appointPayee != null) {
                strategy.set("payeeid", (Object)appointPayee);
                strategy.set("payee", (Object)appointPayee.getString("name"));
            }
        } else if (PayeeStrategyEnum.PERSON_EDIT.getCode().equals(payee)) {
            String payeeEdit = (String)this.getModel().getValue(this.KEY_PAYEE_EDIT);
            String tipMsg2 = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u6536\u6b3e\u4eba", (String)"StrategyDetailPlugin_28", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            GBKUtils.checkLength((String)payeeEdit, (String)tipMsg2, (Integer)20);
            strategy.set("payee", (Object)payeeEdit);
        } else {
            strategy.set("payeeid", (Object)0);
            strategy.set("payee", (Object)"");
        }
    }

    private void dealDrawer(DynamicObject strategy, Object drawerStrategy) {
        String tipMsg2 = ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"StrategyDetailPlugin_29", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.checkEmpty(drawerStrategy, tipMsg2);
        if (DrawerStrategyEnum.APPOINT_DRAWER.getCode().equals(drawerStrategy)) {
            Object appointDrawer = this.getModel().getValue(this.KEY_APPOINTDRAWER);
            String tipMsg = ResManager.loadKDString((String)"\u6307\u5b9a\u5f00\u7968\u4eba", (String)"StrategyDetailPlugin_30", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.checkEmpty(appointDrawer, tipMsg);
            strategy.set("DRAWERID", appointDrawer);
            appointDrawer = ((DynamicObject)appointDrawer).getString("name");
            strategy.set("drawer", appointDrawer);
        } else if (DrawerStrategyEnum.PERSON_EDIT.getCode().equals(drawerStrategy)) {
            Object drawerEdit = this.getModel().getValue(this.KEY_DRAWER_EDIT);
            String tipMsg = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u5f00\u7968\u4eba", (String)"StrategyDetailPlugin_31", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            this.checkEmpty(drawerEdit, tipMsg);
            GBKUtils.checkLength((String)drawerEdit.toString(), (String)tipMsg, (Integer)50);
            strategy.set("drawer", drawerEdit);
        } else {
            strategy.set("DRAWERID", (Object)0);
            strategy.set("drawer", (Object)"");
        }
    }

    private DynamicObjectCollection dealOrgs(HashMap<Object, Object> orgMap) {
        Object orgs = this.getModel().getValue(this.KEY_ORGS);
        String tipMsg = ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"StrategyDetailPlugin_32", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
        this.checkEmpty(orgs, tipMsg);
        DynamicObjectCollection orgCollections = (DynamicObjectCollection)orgs;
        for (DynamicObject org : orgCollections) {
            DynamicObject sysOrg = org.getDynamicObject("fbasedataid");
            orgMap.put(sysOrg.getPkValue(), sysOrg);
        }
        return orgCollections;
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object id = parameter.getCustomParams().get("id");
        if (null != id) {
            this.getView().getPageCache().put(EDIT, EDIT);
            this.editStrategy(id);
        } else {
            this.newStrategy();
        }
    }

    private void editStrategy(Object id) {
        DynamicObject strategy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bdm_drawer_strategy");
        this.getModel().setValue("number", strategy.get("number"));
        this.getModel().setValue("name", strategy.get("name"));
        this.getModel().setValue("creator", strategy.get("creator"));
        DynamicObjectCollection collection = strategy.getDynamicObjectCollection("item");
        DynamicObjectCollection orgCollection = new DynamicObjectCollection();
        int rowIndex = 0;
        for (DynamicObject object : collection) {
            orgCollection.add(rowIndex++, object.getDynamicObject("useorg"));
        }
        this.getModel().setValue("orgs", (Object)orgCollection);
        this.getModel().setValue("priority", strategy.get("priority"));
        this.getModel().setValue("pk", strategy.getPkValue());
        String strategyStr = strategy.getString("drawerstrategy");
        if (strategyStr.length() == 5) {
            this.getModel().setValue("drawerstrategy", (Object)new String(new char[]{strategyStr.charAt(0)}));
            this.getModel().setValue("appointdrawer", strategy.get("DRAWERID"));
            this.getModel().setValue(this.KEY_DRAWER_EDIT, (Object)strategy.getString("drawer"));
            this.getModel().setValue("payee", (Object)new String(new char[]{strategyStr.charAt(2)}));
            this.getModel().setValue("appointpayee", strategy.get("payeeid"));
            this.getModel().setValue(this.KEY_PAYEE_EDIT, (Object)strategy.getString("payee"));
            this.getModel().setValue("reviewer", (Object)new String(new char[]{strategyStr.charAt(4)}));
            this.getModel().setValue("appointreviewer", strategy.get("reviewerid"));
            this.getModel().setValue(this.KEY_REVIEWER_EDIT, (Object)strategy.getString("reviewer"));
        }
        String filter = strategy.getString("filter_tag");
        SchemeHelper.setLocal((String)filter);
    }

    public void afterBindData(EventObject e) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtercontrol");
        FilterCondition filterCondition = null;
        String s = SchemeHelper.getLocal();
        if (StringUtils.isNotBlank((CharSequence)s)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)s, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    private void newStrategy() {
        if (StringUtils.isBlank((Object)this.getModel().getValue(this.KEY_NUMBER))) {
            String format = DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            String number = "No" + format;
            this.getModel().setValue(this.KEY_NUMBER, (Object)number);
        }
        if (StringUtils.isBlank((Object)this.getModel().getValue(this.KEY_CREATOR))) {
            this.getModel().setValue(this.KEY_CREATOR, (Object)RequestContext.get().getUserId());
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{this.KEY_NUMBER, this.KEY_CREATOR});
    }

    private void checkEmpty(Object value, String name) {
        if (value instanceof String && StringUtils.isBlank((Object)value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5fc5\u586b", (String)"StrategyDetailPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]), name));
        }
        if (value instanceof Integer && ((Integer)value < 0 || (Integer)value >= 10)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u5fc5\u987b\u4e3a0\u52309\u4e4b\u95f4\u7684\u6574\u6570", (String)"StrategyDetailPlugin_20", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
        }
        if (null == value) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5fc5\u586b", (String)"StrategyDetailPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]), name));
        }
        if (value instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)value).isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5fc5\u586b", (String)"StrategyDetailPlugin_19", (String)"imc-bdm-formplugin", (Object[])new Object[0]), name));
        }
    }
}

