/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.marktax;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.util.GoodsUtil;

public class MarkTaxTabPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject event) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgId = customParams.get("orgid") instanceof Integer ? Long.valueOf(((Integer)customParams.get("orgid")).longValue()) : (Long)customParams.get("orgid");
        this.loadMarkInvoiceView(orgId);
        this.loadTaxTypeCodeView();
        String xmmc = (String)this.getView().getFormShowParameter().getCustomParam("xmmc");
        QFilter markFilter = ImcBaseDataHelper.getGoodsInfoFilter((Object)orgId);
        if (StringUtils.isNotBlank((CharSequence)xmmc)) {
            markFilter.and("name", "like", (Object)("%" + xmmc + "%"));
        }
        if (!QueryServiceHelper.exists((String)"bdm_goods_info", (QFilter[])markFilter.toArray())) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("taxtypecode");
        }
    }

    private void loadMarkInvoiceView(Long orgId) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bdm_goods_quote", (boolean)false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("markinvoice");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.createMarkInvoiceFilter(showParameter, customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "goods_close");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam("orgid", (Object)orgId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void createMarkInvoiceFilter(ListShowParameter showParameter, Map<String, Object> customParams) {
        List filters = showParameter.getListFilterParameter().getQFilters();
        String tobaccoLabel = (String)customParams.get("TOBACCO_LABEL");
        String oilLable = (String)customParams.get("OIL_LABLE");
        String xmmc = (String)customParams.get("xmmc");
        this.createTobaccoFilter(tobaccoLabel, filters);
        this.createOilFilter(oilLable, filters);
        this.createGoodNameFilter(xmmc, filters);
    }

    private void createGoodNameFilter(String xmmc, List<QFilter> filters) {
        if (StringUtils.isNotBlank((CharSequence)xmmc)) {
            QFilter filter = new QFilter("name", "like", (Object)("%" + xmmc + "%"));
            filters.add(filter);
        }
    }

    private void createTobaccoFilter(String tobaccoLabel, List<QFilter> filters) {
        if ("2".equals(tobaccoLabel)) {
            filters.add(new QFilter("taxcode.mergecode", "like", (Object)"1030402%"));
        } else if ("0".equals(tobaccoLabel)) {
            filters.add(new QFilter("taxcode.mergecode", "not like", (Object)"1030402%"));
        }
    }

    private void createOilFilter(String oilLable, List<QFilter> filters) {
    }

    private void loadTaxTypeCodeView() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"er_taxclasscode_queto", (boolean)false);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String tobaccoLabel = (String)customParams.get("TOBACCO_LABEL");
        String oilLable = (String)customParams.get("OIL_LABLE");
        String xmmc = (String)customParams.get("xmmc");
        GoodsUtil.queryByGoodsName((String)xmmc, (ListShowParameter)showParameter);
        Map taxRateParams = showParameter.getCustomParams();
        taxRateParams.put("TOBACCO_LABEL", tobaccoLabel);
        taxRateParams.put("OIL_LABLE", oilLable);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("taxtypecode");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tax_close");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        if ("goods_close".equals(key) && closedCallBackEvent.getReturnData() != null) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("type", "mark");
            returnMap.put("result", closedCallBackEvent.getReturnData());
            this.getView().returnDataToParent(returnMap);
        } else if ("tax_close".equals(key) && closedCallBackEvent.getReturnData() != null) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            returnMap.put("type", "tax");
            returnMap.put("result", closedCallBackEvent.getReturnData());
            this.getView().returnDataToParent(returnMap);
        }
        this.getView().close();
    }
}

