/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.mergeconfig;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.TransferContainer;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.transfer.TransferNode;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.ImcConfigUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BillMergeFieldConfigPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BillMergeFieldConfigPlugin.class);
    private static ImmutableSet<String> BILL_INCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"auditor", "auditdate"}).add((Object[])new String[]{"currency", "exchangedate", "exchangerate"}).add((Object[])new String[]{"buyerbank", "buyeraddr", "billdate", "billremark", "invoiceremark", "specialtype"}).add((Object[])new String[]{"buyeremail", "buyerphone", "drawer", "payee", "reviewer"}).add((Object[])new String[]{"salesorgbase", "settlementorgbase", "capitalorgbase", "customnameid"}).add((Object[])new String[]{"contractno", "contractdate", "purchasername", "purchasercontact", "purchaserphone", "suppliername", "suppliercontact", "supplierphone"}).add((Object[])new String[]{"textfield1", "textfield2", "textfield3", "textfield4", "textfield5"}).add((Object)"operator").build();
    private static ImmutableSet<String> ITEM_INCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"specification", "unit", "num", "goodscode", "amount", "taxamount", "policylogo", "policycontants"}).add((Object[])new String[]{"extrafield", "extrafield2", "extrafield3", "extrafield4", "extrafield5"}).build();
    private static ImmutableSet<String> CLEAR_INFO_INCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"specification", "unit", "num"}).build();
    private static ImmutableSet<String> MATCH_BILL_ITEM_INCLUDE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"goodsid", "goodsname", "goodscode", "specification", "unitprice", "unit", "rowtype"}).add((Object[])new String[]{"extrafield", "extrafield2", "extrafield3", "extrafield4", "extrafield5"}).build();
    private static ImmutableSet<String> MATCH_BILL_ITEM_REMOVE_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"id", "seq", "num", "taxrate", "amount", "tax", "taxunitprice", "unitprice"}).build();
    private static ImmutableSet<String> MATCH_BILL_INVOICE_INCLUDE_FIELD = new ImmutableSet.Builder().add((Object)"invoicetype").build();
    private static ImmutableSet<String> MATCH_REDCONFIRM_ITEM_FIELD = new ImmutableSet.Builder().add((Object[])new String[]{"goodsname", "goodscode", "unitprice", "specification", "unit"}).build();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        List properties;
        Boolean isBill = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBill");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"sim_original_bill");
        String eventName = (String)this.getView().getFormShowParameter().getCustomParam("eventName");
        if (isBill.booleanValue()) {
            properties = "invoicematchconfig".equals(eventName) ? entityType.getProperties().stream().filter(property -> this.getIncludeField(CacheKeyEnum.BDM_MATCH_BILL_HEAD_FIELD, (Set<String>)MATCH_BILL_INVOICE_INCLUDE_FIELD).contains(property.getName())).collect(Collectors.toList()) : ("matchRedConfirmConfig".equals(eventName) ? entityType.getProperties().stream().filter(property -> this.getIncludeField(CacheKeyEnum.BDM_MATCH_RED_CONFIRM_DETAIL_FIELD, (Set<String>)MATCH_REDCONFIRM_ITEM_FIELD).contains(property.getName())).collect(Collectors.toList()) : entityType.getProperties().stream().filter(property -> this.getIncludeField(CacheKeyEnum.BDM_MERGE_BILL_HEAD_FIELD, (Set<String>)BILL_INCLUDE_FIELD).contains(property.getName())).collect(Collectors.toList()));
        } else {
            IDataEntityProperty items = (IDataEntityProperty)entityType.getProperties().get((Object)"sim_original_bill_item");
            DataEntityPropertyCollection propertyCollection = ((EntryProp)items).getItemType().getProperties();
            String clearConfig = (String)this.getView().getFormShowParameter().getCustomParam("clearconfig");
            Set<String> includeField = "matchRedConfirmConfig".equals(eventName) ? this.getIncludeField(CacheKeyEnum.BDM_MATCH_RED_CONFIRM_DETAIL_FIELD, (Set<String>)MATCH_REDCONFIRM_ITEM_FIELD) : (StringUtils.isBlank((CharSequence)clearConfig) ? this.getIncludeField(CacheKeyEnum.BDM_MERGE_BILL_DETAIL_FIELD, (Set<String>)ITEM_INCLUDE_FIELD) : this.getIncludeField(null, (Set<String>)CLEAR_INFO_INCLUDE_FIELD));
            if ("itemmatchconfig".equals(eventName)) {
                MainEntityType entityType1 = EntityMetadataCache.getDataEntityType((String)"sim_match_bill");
                MainEntityType entityType2 = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
                IDataEntityProperty matchItems = (IDataEntityProperty)entityType1.getProperties().get((Object)"sim_original_bill_item");
                DataEntityPropertyCollection matchPropertyCollection = ((EntryProp)matchItems).getItemType().getProperties();
                IDataEntityProperty invoiceItems = (IDataEntityProperty)entityType2.getProperties().get((Object)"items");
                DataEntityPropertyCollection invoicePropertyCollection = ((EntryProp)invoiceItems).getItemType().getProperties();
                properties = propertyCollection.stream().filter(property -> invoicePropertyCollection.stream().anyMatch(p -> p.getName().equals(property.getName())) && matchPropertyCollection.stream().anyMatch(p -> p.getName().equals(property.getName())) && !MATCH_BILL_ITEM_REMOVE_FIELD.contains((Object)property.getName())).collect(Collectors.toList());
            } else {
                properties = "matchRedConfirmConfig".equals(eventName) ? propertyCollection.stream().filter(property -> includeField.contains(property.getName())).collect(Collectors.toList()) : propertyCollection.stream().filter(property -> includeField.contains(property.getName())).collect(Collectors.toList());
            }
        }
        ArrayList<TransferNode> transferNodeListData = new ArrayList<TransferNode>(100);
        for (IDataEntityProperty property2 : properties) {
            transferNodeListData.add(new TransferNode(property2.getName(), property2.getDisplayName().getLocaleValue(), Boolean.FALSE));
        }
        if (!("matchRedConfirmConfig".equals(eventName) || isBill.booleanValue() || "itemmatchconfig".equals(eventName) || "invoicematchconfig".equals(eventName))) {
            String tipMsg3 = ResManager.loadKDString((String)"\u5355\u4ef7", (String)"BillMergeConfigEditPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
            transferNodeListData.add(new TransferNode("price", tipMsg3, Boolean.FALSE));
        }
        TransferContainer transfer = (TransferContainer)this.getControl("transfercontainerap");
        String selectFields = (String)this.getView().getFormShowParameter().getCustomParam("selectFields");
        transfer.setTransferListData(transferNodeListData, Arrays.asList(selectFields.split(",")));
    }

    private Set<String> getIncludeField(CacheKeyEnum cacheKeyEnum, Set<String> baseIncludeFieldSet) {
        if (cacheKeyEnum == null) {
            return baseIncludeFieldSet;
        }
        HashSet<String> includeField = new HashSet<String>(baseIncludeFieldSet.size());
        String addFields = ImcConfigUtil.getValue((CacheKeyEnum)cacheKeyEnum);
        try {
            if (StringUtils.isNotBlank((CharSequence)addFields)) {
                includeField = new HashSet(Splitter.on((String)",").splitToList((CharSequence)addFields));
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("\u8bbe\u7f6e\u5408\u5e76\u5b57\u6bb5\u5931\u8d25\uff0c\u65b0\u589e\u7684\u5408\u5e76\u5b57\u6bb5\u4e3a%s", addFields), (Throwable)e);
        }
        includeField.addAll(baseIncludeFieldSet);
        Boolean isSplit = (Boolean)this.getView().getFormShowParameter().getCustomParam("isSplit");
        if (null != isSplit && isSplit.booleanValue()) {
            includeField.add("goodsname");
            includeField.add("taxrate");
        }
        return includeField;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            Boolean isSplit;
            TransferContainer transfer = (TransferContainer)this.getControl("transfercontainerap");
            List selectedData = transfer.getSelectedData();
            if (selectedData == null) {
                this.getView().close();
                return;
            }
            if (selectedData.size() > 20) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e920\u4e2a\u5408\u5e76\u5b57\u6bb5", (String)"BillMergeFieldConfigPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (CollectionUtils.isEmpty((Collection)selectedData) && null != (isSplit = (Boolean)this.getView().getFormShowParameter().getCustomParam("isSplit")) && isSplit.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5408\u5e76\u5b57\u6bb5", (String)"BillMergeFieldConfigPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> selectKeys = new ArrayList<String>(selectedData.size());
            ArrayList<String> selectNames = new ArrayList<String>(selectedData.size());
            for (Object selectedDatum : selectedData) {
                Map selectData = (Map)selectedDatum;
                selectKeys.add((String)selectData.get("id"));
                selectNames.add((String)selectData.get("text"));
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("clearconfig"))) && (selectKeys.contains("price") && !selectKeys.contains("num") || selectKeys.contains("num") && !selectKeys.contains("price"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u6570\u91cf\u3011/\u3010\u5355\u4ef7\u3011\uff0c\u6570\u91cf\u548c\u5355\u4ef7\u540c\u65f6\u663e\u793a\u540c\u65f6\u4e0d\u663e\u793a", (String)"BillMergeFieldConfigPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("selectKeys", String.join((CharSequence)",", selectKeys));
            customParams.put("selectNames", String.join((CharSequence)"_", selectNames));
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        }
    }
}

