/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.ViewUtil;

public class OrgListPlugin
extends AbstractTreeListPlugin {
    private static final String ACTIONID_CLOSE_IMP = "closeimport";
    private static final String CLOSE_ORG_TREE_EDIT = "closeOrgTreeEdit";
    private static final String BILL_LIST = "billlistap";
    private static final String CURRENT_NODE = "current_node";
    private static final String PARENT_ORG_ID_NOT_FOUNT = "-1";
    private static final String KEY_BIND_ENTERPRISE_INFO = "bdm_bind_enterprise_info";
    public static final String BDM_ORG_IMPORT_UPDATE = "bdm_org_import_update";

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshTree();
                break;
            }
            case "import": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_IMPORT_ORG);
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"bdm_org_import", (String)ACTIONID_CLOSE_IMP);
                break;
            }
            case "edittree": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_IMPORT_ORG);
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"bdm_orgtree_edit", (String)CLOSE_ORG_TREE_EDIT);
                break;
            }
            case "batchimport": {
                PermissionHelper.checkPermission((AbstractFormPlugin)this, (ImcPermItemEnum)ImcPermItemEnum.BDM_ORG_BATCH_IMPORT);
                ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)BDM_ORG_IMPORT_UPDATE, (String)BDM_ORG_IMPORT_UPDATE);
            }
        }
    }

    private void refreshTree() {
        OrgHelper.createOrgTree((ITreeListView)this.getTreeListView(), this.getTreeFilter());
        this.setCurrenNode();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        billList.clearSelection();
        billList.refresh();
    }

    private void setCurrenNode() {
        TreeNode root = this.getTreeListView().getTreeModel().getRoot();
        this.getPageCache().put(CURRENT_NODE, root == null ? String.valueOf(RequestContext.get().getOrgId()) : root.getId());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (ACTIONID_CLOSE_IMP.equals(actionId)) {
            if (event.getReturnData() != null) {
                this.refreshTree();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f", (String)"OrgListPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
        } else if (CLOSE_ORG_TREE_EDIT.equals(actionId)) {
            if ("refresh".equals(event.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7f16\u8f91\u6210\u529f", (String)"OrgListPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            } else if ("not_change".equals(event.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6ca1\u6709\u53d8\u66f4", (String)"OrgListPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            this.refreshTree();
        } else if (BDM_ORG_IMPORT_UPDATE.equals(actionId)) {
            if ("refresh".equals(event.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u6210\u529f", (String)"OrgListPlugin_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            this.refreshTree();
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        HasPermOrgResult userHasPermOrgs;
        long orgId = RequestContext.get().getOrgId();
        String nodeID = this.getPageCache().get(CURRENT_NODE);
        if (!StringUtils.isEmpty((CharSequence)nodeID)) {
            orgId = Long.parseLong(nodeID);
        }
        if ((userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()))).hasAllOrgPerm()) {
            filter = orgId == -1L ? new QFilter("1", "=", (Object)1) : new QFilter("id", "in", (Object)OrgHelper.getChildrenOrgIds((long)orgId, (boolean)true));
        } else {
            List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            if (orgId != -1L) {
                hasPermOrgs.retainAll(OrgHelper.getChildrenOrgIds((long)orgId, (boolean)true));
            }
            filter = OrgHelper.getIdFilter((Collection)hasPermOrgs);
        }
        e.getQFilters().add(filter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST);
        Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject orgDynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bdm_org");
        if (orgDynamicObject.get("epinfo") == null) {
            this.addentrepriseClick(orgDynamicObject);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("orgId", primaryKeyValue);
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, customParams, (String)"bdm_org_edit", (String)"bdm_org_edit");
    }

    private void addentrepriseClick(DynamicObject org) {
        DynamicObject parentOrg;
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("number", org.getString("number"));
        customParams.put("name", org.getString("name"));
        Object parentId = org.get("parent");
        String parentNumber = null;
        String parentName = null;
        if (StringUtils.isNotBlank((Object)parentId) && !PARENT_ORG_ID_NOT_FOUNT.equals(parentId) && null != (parentOrg = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(parentId))).toArray()))) {
            parentNumber = parentOrg.getString("number");
            parentName = parentOrg.getString("name");
        }
        customParams.put("orgId", org.getPkValue());
        customParams.put("parentNumber", parentNumber);
        customParams.put("parentName", parentName);
        customParams.put("viewtype", org.getString("viewtype"));
        ViewUtil.openMainNewTabPage((AbstractFormPlugin)this, null, customParams, (String)KEY_BIND_ENTERPRISE_INFO, (String)KEY_BIND_ENTERPRISE_INFO);
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
    }

    public void initializeTree(EventObject e) {
        List<QFilter> treeFilter = this.getTreeFilter();
        OrgHelper.createOrgTree((ITreeListView)this.getTreeListView(), treeFilter);
        this.setCurrenNode();
    }

    private List<QFilter> getTreeFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        ArrayList qFilters = Lists.newArrayList();
        Object salerTaxNo = formShowParameter.getCustomParam("salerTaxNo");
        if (StringUtils.isNotBlank((Object)salerTaxNo)) {
            QFilter qFilter = new QFilter("epinfo.number", "=", salerTaxNo);
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getPageCache().put(CURRENT_NODE, treenodeevent.getNodeId().toString());
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower", "flexpanel_treebtn"});
        long userId = Long.parseLong(RequestContext.get().getUserId());
        this.getView().setVisible(Boolean.valueOf(PermissionServiceHelper.isSuperUser((long)userId) || PermissionServiceHelper.isAdminUser((long)userId)), new String[]{"edittree"});
    }
}

