/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.staticqrcode;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.util.ViewUtil;

public class BdmStaticQrCodeSettingFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(BdmStaticQrCodeSettingFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBeforeAndAfterF7SelectListener("org");
        this.addTextEditClickListener("fieldname");
    }

    private void addTextEditClickListener(String ... keys) {
        for (String key : keys) {
            TextEdit textEdit = (TextEdit)this.getView().getControl(key);
            if (textEdit == null) continue;
            textEdit.addClickListener((ClickListener)this);
        }
    }

    private void addBeforeAndAfterF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (null == basedataEdit) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "fieldname": {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("static_qrcode_set_entry");
                List fieldKeyList = dynamicObjectCollection.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getString("fieldkey"))).map(item -> item.getString("fieldkey")).collect(Collectors.toList());
                HashMap customParams = new HashMap(fieldKeyList.size());
                customParams.put("fieldKeyList", fieldKeyList);
                String tipMsg = ResManager.loadKDString((String)"\u9009\u62e9\u6269\u5c55\u5b57\u6bb5\u5f39\u6846", (String)"BdmStaticQrCodePlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                ViewUtil.openDialog((AbstractFormPlugin)this, (String)tipMsg, customParams, (String)"bdm_static_select_field", (String)"selectFieldCallBack");
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        DynamicObject epInfoObject;
        Object pkId;
        ListSelectedRow listSelectedRow = event.getListSelectedRow();
        if (listSelectedRow == null) {
            List inputValues = event.getInputValues();
            if (inputValues == null || inputValues.size() == 0) {
                String tipMsg = ResManager.loadKDString((String)"\u8bf7\u5728\u5f39\u6846\u4e2d\u9009\u62e9\u7ec4\u7ec7\u5bf9\u8c61\uff01", (String)"BdmStaticQrCodeSettingFormPlugin_0", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipMsg);
                return;
            }
            pkId = inputValues.get(0);
        } else {
            pkId = listSelectedRow.getPrimaryKeyValue();
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bdm_org");
        if (dynamicObject != null && (epInfoObject = dynamicObject.getDynamicObject("epinfo")) != null) {
            this.getModel().setValue("epinfo", (Object)epInfoObject.getLong("id"));
            this.getModel().setValue("taxno", (Object)epInfoObject.getString("number"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initStaticQrCodeNumberMethod();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("phone_visable".equals(key)) {
            Boolean phone_visable = (Boolean)this.getModel().getValue("phone_visable");
            if (phone_visable.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"phone_input"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"phone_input"});
                this.getModel().setValue("phone_input", (Object)phone_visable);
            }
        } else if ("email_visable".equals(key)) {
            Boolean email_visable = (Boolean)this.getModel().getValue("email_visable");
            if (email_visable.booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"email_input"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"email_input"});
                this.getModel().setValue("email_input", (Object)email_visable);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            String taxNo = (String)this.getModel().getValue("taxno");
            DynamicObject orgObject = (DynamicObject)this.getModel().getValue("org");
            DynamicObject epInfoObject = (DynamicObject)this.getModel().getValue("epinfo");
            if (orgObject == null || epInfoObject == null || StringUtils.isBlank((CharSequence)taxNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3001\u4f01\u4e1a\u5bf9\u8c61\u6216\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BdmStaticQrCodeSettingFormPlugin_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            HashSet<String> fieldKeySet = new HashSet<String>(8);
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("static_qrcode_set_entry");
            if (dynamicObjectCollection != null) {
                for (DynamicObject itemObject : dynamicObjectCollection) {
                    String fieldKey = itemObject.getString("fieldkey");
                    if (fieldKeySet.contains(fieldKey)) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u591f\u51fa\u73b0\u91cd\u590d\u7684\u5b57\u6bb5\u952e:[%s]", (String)"BdmStaticQrCodeSettingFormPlugin_8", (String)"imc-bdm-formplugin", (Object[])new Object[0]), fieldKey);
                        throw new KDBizException(errorMsg);
                    }
                    fieldKeySet.add(fieldKey);
                }
            }
            long pkId = this.getView().getModel().getDataEntity().getLong("id");
            Long orgId = orgObject.getLong("id");
            QFilter qFilter = new QFilter("org.id", "=", (Object)orgId).and("taxno", "=", (Object)taxNo);
            DynamicObject staticQrCodeObject = BusinessDataServiceHelper.loadSingle((String)"bdm_static_qrcode_setting", (QFilter[])qFilter.toArray());
            if (staticQrCodeObject != null) {
                Long id = staticQrCodeObject.getLong("id");
                if (id == pkId) {
                    staticQrCodeObject.set("qrcodestatus", (Object)"0");
                    return;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7a0e\u53f7\u5bf9\u5e94\u7684\u9759\u6001\u4e8c\u7ef4\u7801\u914d\u7f6e\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff01", (String)"BdmStaticQrCodeSettingFormPlugin_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
            }
            staticQrCodeObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_static_qrcode_setting");
            staticQrCodeObject.set("qrcodestatus", (Object)"0");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean phone_visable = (Boolean)this.getModel().getValue("phone_visable");
        if (phone_visable.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"phone_input"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"phone_input"});
        }
        Boolean email_visable = (Boolean)this.getModel().getValue("email_visable");
        if (email_visable.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"email_input"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"email_input"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("selectFieldCallBack".equals(actionId)) {
            int i;
            List returnList = (List)closedCallBackEvent.getReturnData();
            LOG.info("\u5f39\u6846\u8fd4\u56de\u7684\u5185\u5bb9:{}", (Object)returnList);
            if (returnList == null || returnList.isEmpty()) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("static_qrcode_set_entry");
            if (dynamicObjectCollection != null) {
                for (i = 0; i < dynamicObjectCollection.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                    String fieldKey = dynamicObject.getString("fieldkey");
                    if (!StringUtils.isBlank((CharSequence)fieldKey)) continue;
                    this.getView().getModel().deleteEntryRow("static_qrcode_set_entry", i);
                }
            }
            this.getModel().beginInit();
            for (i = 0; i < returnList.size(); ++i) {
                HashMap returnMap = (HashMap)returnList.get(i);
                this.initStaticQrCodeFieldEntryMethod(returnMap);
            }
            this.getModel().endInit();
            this.getView().updateView("static_qrcode_set_entry");
            this.setFieldEnableMethod();
        }
    }

    private void setFieldEnableMethod() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("static_qrcode_set_entry");
        if (dynamicObjectCollection != null) {
            for (int row = 0; row < dynamicObjectCollection.size(); ++row) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldkey"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldtype"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"fieldvalue"});
            }
        }
    }

    private void initStaticQrCodeFieldEntryMethod(HashMap<String, Object> returnMap) {
        int row = this.getView().getModel().createNewEntryRow("static_qrcode_set_entry");
        this.getModel().setValue("fieldname", returnMap.get("fieldName"), row);
        this.getModel().setValue("fieldkey", returnMap.get("fieldKey"), row);
        this.getModel().setValue("fieldrequired", returnMap.get("required"), row);
        Object fieldType = returnMap.get("fieldType");
        this.getModel().setValue("fieldtype", fieldType, row);
        this.getModel().setValue("helptext", returnMap.get("helpText"), row);
        this.getModel().setValue("bizcontrol", returnMap.get("bizControl"));
        Object fieldValue = returnMap.get("fieldValue");
        this.getModel().setValue("fieldvalue", fieldValue, row);
    }

    private void initStaticQrCodeNumberMethod() {
        this.getView().getModel().setValue("number", (Object)System.currentTimeMillis());
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"phone_input"});
    }
}

