/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.taskplan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.service.LqptService;

public class QueryAgricGoodscodeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(QueryAgricGoodscodeTask.class);
    private static final String AGRIC_GOODSCODE = "bdm_agric_goodscode";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("QueryAgricGoodscodeTask\u5f00\u59cb... ");
        try (DLock lock = DLock.create((String)"RimQueryAgricGoodscodeTask", (String)"RimQueryAgricGoodscodeTask");){
            if (lock.tryLock()) {
                this.query();
            } else {
                LOGGER.info("RimQueryAgricGoodscodeTask-Lock");
            }
        }
        LOGGER.info("QueryAgricGoodscodeTask\u7ed3\u675f... ");
    }

    private void query() {
        JSONObject data;
        String taxNo = this.checkTaxNo("1");
        if (taxNo == null) {
            taxNo = this.checkTaxNo("2");
        }
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            LOGGER.info("\u6ca1\u6709\u5f00\u542f\u4e50\u4f01\u80fd\u529b\u5e76\u4e14\u914d\u7f6e\u5b8c\u6574\u7684\u7a0e\u53f7");
            return;
        }
        JSONObject param = new JSONObject();
        param.put("gfsbh", (Object)taxNo);
        param.put("nsrsbh", (Object)taxNo);
        param.put("api_type", (Object)"CXFPNCPSPBMLB");
        JSONObject result = this.invokeService(param);
        if (result != null && "0000".equals(result.getString("errcode")) && (data = result.getJSONObject("data")) != null) {
            JSONArray fpspbmlb = data.getJSONArray("fpspbmlb");
            if (CollectionUtils.isEmpty((Collection)fpspbmlb)) {
                return;
            }
            for (int i = 0; i < fpspbmlb.size(); ++i) {
                JSONObject fpspbm = fpspbmlb.getJSONObject(i);
                this.saveData(fpspbm);
            }
        }
    }

    private String checkTaxNo(String role) {
        QFilter typeFilter = new QFilter("authtype", "=", (Object)"5").or("issuechannel", "=", (Object)"2");
        QFilter roleFilter = new QFilter("enterpriserole", "=", (Object)role);
        DynamicObjectCollection baseinfos = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)"number", (QFilter[])new QFilter[]{typeFilter, roleFilter});
        LqptService lqptService = new LqptService();
        if (!CollectionUtils.isEmpty((Collection)baseinfos)) {
            for (DynamicObject baseinfo : baseinfos) {
                LqEpConfig config = lqptService.getLqEpConfig(baseinfo.getString("number"));
                if (config == null) continue;
                if (StringUtils.isBlank((CharSequence)config.getBaseUrl())) {
                    LOGGER.info("\u6ca1\u6709\u914d\u7f6e\u4e50\u4f01BaseUrl");
                    return "";
                }
                return baseinfo.getString("number");
            }
        }
        return null;
    }

    private JSONObject invokeService(JSONObject param) {
        LOGGER.info("\u8bf7\u6c42\u4e50\u4f01\u63a5\u53e3\u53c2\u6570:{}", (Object)param);
        String unitTestResult = CacheHelper.get((String)("Lq-" + param.getString("api_type")));
        if (StringUtils.isNotEmpty((CharSequence)unitTestResult)) {
            return JSONObject.parseObject((String)unitTestResult);
        }
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"DeductApiService", (String)"send", (Object[])new Object[]{param});
    }

    private void saveData(JSONObject fpspbm) {
        if (fpspbm == null) {
            return;
        }
        String goodsCode = fpspbm.getString("spbm");
        if (StringUtils.isEmpty((CharSequence)goodsCode)) {
            return;
        }
        try {
            QFilter qFilter = new QFilter("number", "=", (Object)goodsCode);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)AGRIC_GOODSCODE, (String)"id,number,name,tax_classification_code,createtime,modifytime,resource,status,enable", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)AGRIC_GOODSCODE);
                dynamicObject.set("createtime", (Object)new Date());
                dynamicObject.set("status", (Object)"A");
                dynamicObject.set("enable", (Object)"1");
            }
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("resource", (Object)"1");
            dynamicObject.set("number", (Object)goodsCode);
            dynamicObject.set("name", (Object)new LocaleString(fpspbm.getString("sphfwmc")));
            dynamicObject.set("tax_classification_code", (Object)fpspbm.getString("ssflbm"));
            ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
        }
        catch (Throwable throwable) {
            LOGGER.error("\u4fdd\u5b58\u519c\u4ea7\u54c1\u7f16\u7801\u5165\u5e93\u5931\u8d25" + goodsCode, throwable);
        }
    }
}

