/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.vehicleinfo.op;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.TaxRateUtil;

public class VehicleInfoSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String msg;
                    DynamicObject vehicleInfo = dataEntity.getDataEntity();
                    try {
                        String tipMsg1 = ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInfoSaveOp_1", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                        String tipMsg2 = ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInfoSaveOp_2", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                        String tipMsg3 = ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInfoSaveOp_3", (String)"imc-bdm-formplugin", (Object[])new Object[0]);
                        GBKUtils.CheckGBKLength((String)(vehicleInfo.getString("producingarea") + ""), (String)tipMsg1, (int)32);
                        GBKUtils.CheckGBKLength((String)(vehicleInfo.getString("producingname") + ""), (String)tipMsg2, (int)40);
                        GBKUtils.CheckGBKLength((String)(vehicleInfo.getString("brandmodel") + ""), (String)tipMsg3, (int)60);
                    }
                    catch (KDBizException e) {
                        this.addErrorMessage(dataEntity, e.getMessage());
                    }
                    DynamicObject goodscode = vehicleInfo.getDynamicObject("goodscode");
                    if (goodscode != null) {
                        vehicleInfo.set("goodsname", (Object)goodscode.getString("name"));
                    }
                    if (vehicleInfo.getPkValue() != null) {
                        vehicleInfo.set("modifier", (Object)RequestContext.get().getUserId());
                        vehicleInfo.set("modifydate", (Object)new Date());
                    } else {
                        vehicleInfo.set("creater", (Object)RequestContext.get().getUserId());
                        vehicleInfo.set("createdate", (Object)new Date());
                    }
                    if (!"1".equals(vehicleInfo.getString("taxpremark"))) continue;
                    if (StringUtils.isBlank((CharSequence)vehicleInfo.getString("zzstsgl"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\"\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\"\u3002\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleInfoSaveOp_4", (String)"imc-bdm-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (goodscode == null || !StringUtils.isNotBlank((CharSequence)(msg = TaxRateUtil.checkPrivilegeType((String)goodscode.getString("vatspecialmanagement"), (String)vehicleInfo.getString("zzstsgl"), (String)vehicleInfo.getString("taxrate"))))) continue;
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        });
    }
}

