/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.formplugin.org.webapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.util.InputPermissionUtils;
import kd.imc.bdm.formplugin.org.webapi.AddorgService;
import org.apache.commons.lang3.StringUtils;

public class AddOrgWebApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(AddOrgWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("\u589e\u52a0\u7ec4\u7ec7\u63a5\u53e3\u4f20\u5165\u53c2\u6570[%s]", SerializationUtils.toJsonString(params)));
        }
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setErrorCode("0000");
        if (params == null) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"AddOrgWebApiPlugin_0", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            return result;
        }
        String tenantNo = (String)params.get("tenantNo");
        String tenantName = (String)params.get("tenantName");
        List orgs = (List)params.get("orgs");
        if (StringUtils.isEmpty((CharSequence)tenantNo)) {
            result.setErrorCode("0001");
            result.setMessage(ResManager.loadKDString((String)"\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddOrgWebApiPlugin_1", (String)"imc-bdm-webapi", (Object[])new Object[0]));
            return result;
        }
        AddorgService service = new AddorgService();
        Long rootId = service.addOrg(tenantNo, tenantName, null, 0L);
        service.addBdmOrg(0L, rootId, tenantNo, tenantName, null, null);
        if (orgs != null && orgs.size() > 0) {
            for (Object org : orgs) {
                Map orgMap = (Map)org;
                String taxNo = (String)orgMap.get("taxNo");
                String name = (String)orgMap.get("name");
                String ouNo = (String)orgMap.get("ouNo");
                String clientId = (String)orgMap.get("clientId");
                String clientSecret = (String)orgMap.get("clientSecret");
                String encKey = (String)orgMap.get("encKey");
                try {
                    Long orgId = service.addOrg(ouNo, name, taxNo, rootId);
                    service.addBdmOrg(rootId, orgId, ouNo, name, taxNo, name);
                    service.addClient(orgId, taxNo, name, clientId, clientSecret, encKey);
                    this.addLicense(orgMap, taxNo, orgId);
                }
                catch (KDException e) {
                    result.setErrorCode(e.getErrorCode().getCode());
                    result.setMessage(e.getErrorCode().getMessage());
                    break;
                }
            }
        }
        result.setData((Object)rootId);
        return result;
    }

    private void addLicense(Map orgMap, String txaNo, Long orgId) {
        List licenseSet = (List)orgMap.get("licenseSet");
        if (licenseSet != null && !licenseSet.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>(licenseSet.size());
            for (Object obj : licenseSet) {
                if ("0".equals(obj)) {
                    list.add(PermissionEnum.COLLECT_INVOICE_SERVICE.getPermissionNo());
                    continue;
                }
                if (!"1".equals(obj)) continue;
                list.add(PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo());
            }
            if (!list.isEmpty()) {
                InputPermissionUtils.savePermission((Long)orgId, (String[])list.toArray(new String[0]), (String)"1");
            }
        }
    }
}

