/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.schedule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.AwsFpyConstant;
import kd.imc.bdm.common.constant.table.EnterPriseBaseInfoConstant;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItem;
import kd.imc.bdm.lqpt.service.SpbmAndSlvService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxCodeUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TaxCodeUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)("bdm" + TaxCodeUpdateTask.class.getSimpleName() + "lock"));){
            if (!lock.tryLock()) {
                logger.info("\u672a\u83b7\u53d6\u5230\u9501\uff0c\u4e0d\u66f4\u65b0");
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)("bdm" + TaxCodeUpdateTask.class.getSimpleName())))) {
                logger.info("\u7f13\u5b58\u672a\u5931\u6548\uff0c\u4e0d\u66f4\u65b0");
                return;
            }
            QFilter qFilter = new QFilter("issuechannel", "in", (Object)EnterPriseBaseInfoConstant.LQPT_CHANNEL);
            DynamicObjectCollection epInfoList = QueryServiceHelper.query((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "number", "enterpriserole"), (QFilter[])qFilter.toArray());
            if (epInfoList.size() == 0) {
                this.querySpbmByAws();
                return;
            }
            List<SpbmResponseItem> itemList = new ArrayList<SpbmResponseItem>(5000);
            SpbmAndSlvService taxpayerService = new SpbmAndSlvService();
            List accessTaxNo = epInfoList.stream().filter(epInfo -> "1".equals(epInfo.getString("enterpriserole"))).map(epInfo -> epInfo.getString("number")).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(accessTaxNo)) {
                DeleteServiceHelper.delete((String)"bdm_lqpt_spbm", (QFilter[])new QFilter("nsrsbh", "not in", accessTaxNo).toArray());
                for (String taxNo : accessTaxNo) {
                    try {
                        List<SpbmResponseItem> tempItemList = taxpayerService.querySpbmFromLq(taxNo);
                        if (!CollectionUtils.isNotEmpty(tempItemList)) continue;
                        itemList = tempItemList;
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u5931\u8d25" + taxNo, (Throwable)e);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(itemList)) {
                this.syncTaxCode2Base("", itemList);
            }
        }
    }

    private void querySpbmByAws() {
        Map awsConfigMap = ImcConfigUtil.getValue((String)"dim_imc_config_fpy");
        String clientId = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientid", "dim_imc_config_fpy_clientid"});
        if (StringUtils.isBlank((CharSequence)clientId)) {
            logger.info("clientId\u4e3a\u7a7a");
            return;
        }
        try {
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String url = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"url", "dim_imc_config_fpy_url"});
            url = url + AwsFpyConstant.getUrl((String)"query_spbm") + "?access_token=" + awsFpyService.getAccessToken(Long.valueOf(0L), awsFpyService.getAwsConfig(clientId));
            JSONObject jsonObject = awsFpyService.getAppJson(url, null);
            if (!ErrorType.SUCCESS.getCode().equals(jsonObject.getString("errcode"))) {
                logger.info("\u540c\u6b65\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u5931\u8d25:" + jsonObject.toJSONString());
                return;
            }
            JSONObject data = jsonObject.getJSONObject("data");
            String versionNum = data.getString("versionNum");
            JSONArray items = data.getJSONArray("items");
            ArrayList<SpbmResponseItem> itemList = new ArrayList<SpbmResponseItem>(items.size());
            for (int i = 0; i < items.size(); ++i) {
                JSONObject spbmJson = items.getJSONObject(i);
                if ("N".equals(spbmJson.getString("availableState"))) continue;
                SpbmResponseItem item = new SpbmResponseItem();
                item.setSphfwssflhbbm(spbmJson.getString("goodsCode"));
                item.setSphfwmc(spbmJson.getString("goodsName"));
                item.setSphfwfljc(spbmJson.getString("goodsJmmc"));
                item.setZzssl(spbmJson.getString("taxRate"));
                item.setSm(spbmJson.getString("instruction"));
                item.setZzstsgl(spbmJson.getString("zzstsgl"));
                item.setXfszcyj("");
                item.setXfstsnrdm("");
                item.setXfsgl("");
                item.setGjz(spbmJson.getString("keyword"));
                item.setZzszcyj(spbmJson.getString("zzszcyj"));
                item.setDytjjbm(spbmJson.getString("tjjbm"));
                item.setSfhzx(spbmJson.getString("summaryItem"));
                itemList.add(item);
            }
            this.syncTaxCode2Base(versionNum, itemList);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5546\u54c1\u5206\u7c7b\u7f16\u7801\u5931\u8d25", (Throwable)e);
        }
    }

    private void syncTaxCode2Base(String versionNum, List<SpbmResponseItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
            return;
        }
        boolean notExistDisable = "1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"taxCode"));
        Map<String, SpbmResponseItem> taxCodeMap = itemList.stream().collect(Collectors.toMap(SpbmResponseItem::getSphfwssflhbbm, v -> v, (v1, v2) -> v2));
        DynamicObject[] taxCodeObjArr = BusinessDataServiceHelper.load((String)"er_taxclasscode", (String)"", null);
        if (taxCodeObjArr != null && taxCodeObjArr.length != 0) {
            for (DynamicObject taxCodeObj : taxCodeObjArr = BusinessDataServiceHelper.load((Object[])Arrays.stream(taxCodeObjArr).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_taxclasscode"))) {
                SpbmResponseItem item = taxCodeMap.remove(taxCodeObj.getString("mergecode"));
                if (StringUtils.isNotBlank((CharSequence)versionNum)) {
                    taxCodeObj.set("version", (Object)versionNum);
                }
                if (item == null) {
                    logger.info("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5728\u8fd4\u56de\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}", (Object)taxCodeObj.getString("mergecode"));
                    if (!notExistDisable) continue;
                    taxCodeObj.set("enable", (Object)"0");
                    logger.info("\u7981\u7528\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}", (Object)taxCodeObj.getString("mergecode"));
                    continue;
                }
                taxCodeObj.set("enable", (Object)"1");
                taxCodeObj.set("status", (Object)"C");
                if (!taxCodeObj.getString("name").equals(item.getSphfwmc())) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u540d\u79f0\uff0c\u539f\u540d\u79f0{},\u73b0\u540d\u79f0{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("name"), item.getSphfwmc()});
                    taxCodeObj.set("name", (Object)item.getSphfwmc());
                }
                if (!taxCodeObj.getString("simplename").equals(item.getSphfwfljc())) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u7b80\u79f0\uff0c\u539f\u7b80\u79f0{},\u73b0\u7b80\u79f0{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("simplename"), item.getSphfwfljc()});
                    taxCodeObj.set("simplename", (Object)item.getSphfwfljc());
                }
                if (!taxCodeObj.getString("vatspecialmanagement").equals(item.getZzstsgl())) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406\uff0c\u539f\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406{},\u73b0\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("vatspecialmanagement"), item.getZzstsgl()});
                    taxCodeObj.set("vatspecialmanagement", (Object)item.getZzstsgl());
                }
                BigDecimal taxRate = new BigDecimal(TaxRateUtil.percent2Point((String)item.getZzssl()));
                if (taxCodeObj.getBigDecimal("taxrate").compareTo(taxRate) != 0) {
                    logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u7a0e\u7387\uff0c\u539f\u7a0e\u7387{},\u73b0\u7a0e\u7387{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("taxrate"), taxRate});
                    taxCodeObj.set("taxrate", (Object)taxRate);
                }
                boolean hzx = "Y".equals(item.getSfhzx());
                if (taxCodeObj.getBoolean("sumitem") == hzx) continue;
                logger.info("\u4fee\u6539\u7a0e\u6536\u5206\u7c7b\u7f16\u7801:{}\uff0c\u4fee\u6539\u6c47\u603b\u9879\uff0c\u539f\u6c47\u603b\u9879{},\u73b0\u6c47\u603b\u9879{}", new Object[]{taxCodeObj.getString("mergecode"), taxCodeObj.getString("sumitem"), item.getSfhzx()});
                taxCodeObj.set("sumitem", (Object)hzx);
            }
            SaveServiceHelper.update((DynamicObject[])taxCodeObjArr);
        }
        CacheHelper.put((String)("bdm" + TaxCodeUpdateTask.class.getSimpleName()), (String)"11", (int)604800);
        Set<Map.Entry<String, SpbmResponseItem>> entries = taxCodeMap.entrySet();
        if (entries.size() == 0) {
            logger.info("\u6ca1\u6709\u65b0\u589e\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801");
            return;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(entries.size());
        for (Map.Entry<String, SpbmResponseItem> entry : entries) {
            saveList.add(this.createTaxClassCodeDynamic(entry.getValue()));
            logger.info("\u4e0d\u5b58\u5728\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u65b0\u589e:{}\uff0c\u4fee\u6539\u4fe1\u606f{}", (Object)entry.getValue().getSphfwssflhbbm(), (Object)JSONObject.toJSONString((Object)entry.getValue()));
        }
        logger.info("\u4e0d\u5b58\u5728\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u65b0\u589e:{}", (Object)saveList.size());
        SaveServiceHelper.saveOperate((String)"er_taxclasscode", (DynamicObject[])saveList.toArray(new DynamicObject[0]), null);
    }

    private DynamicObject createTaxClassCodeDynamic(SpbmResponseItem item) {
        String pid;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"er_taxclasscode");
        String spbm = item.getSphfwssflhbbm();
        String number = spbm.replaceAll("(00)+$", "");
        String longNumber = TaxCodeUpdateTask.getTaxClassCodeLongNumber(number);
        String[] longNumberArr = longNumber.split("\\.");
        Long id = Long.valueOf(number);
        obj.set("id", (Object)id);
        obj.set("number", (Object)number);
        obj.set("masterid", (Object)number);
        obj.set("longnumber", (Object)longNumber);
        obj.set("mergecode", (Object)spbm);
        obj.set("name", (Object)item.getSphfwmc());
        obj.set("level", (Object)(longNumberArr.length - 1));
        String string = pid = longNumber.length() > 1 ? longNumberArr[longNumberArr.length - 2] : null;
        if (pid != null) {
            DynamicObject parent = BusinessDataServiceHelper.newDynamicObject((String)"er_taxclasscode");
            parent.set("id", (Object)Long.valueOf(pid));
            obj.set("parent", (Object)parent);
        }
        obj.set("parentnum", (Object)pid);
        obj.set("taxrate", (Object)new BigDecimal(TaxRateUtil.percent2Point((String)item.getZzssl())));
        obj.set("simplename", (Object)item.getSphfwfljc());
        obj.set("vatspecialmanagement", (Object)item.getZzstsgl());
        obj.set("excisepolicy", (Object)item.getXfszcyj().replaceAll("\\{}", ""));
        obj.set("excisespecialcontentnum", (Object)item.getXfstsnrdm().replaceAll("\\{}", ""));
        obj.set("excisemanagement", (Object)item.getXfsgl().replaceAll("\\{}", ""));
        obj.set("key", (Object)item.getGjz());
        obj.set("vatspecialcontent", (Object)item.getZzszcyj());
        obj.set("vatspecialnum", (Object)item.getZzstsnrdm());
        obj.set("officecode", (Object)item.getDytjjbm());
        obj.set("sumitem", (Object)"Y".equals(item.getSfhzx()));
        obj.set("description", (Object)item.getSm());
        obj.set("status", (Object)"C");
        obj.set("enable", (Object)"1");
        obj.set("source", (Object)"2");
        obj.set("ishidden", (Object)false);
        return obj;
    }

    private static String getTaxClassCodeLongNumber(String spbm) {
        if (StringUtils.isBlank((CharSequence)spbm)) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(16);
        list.add(spbm.substring(0, 1));
        for (int i = 1; i < spbm.length(); i += 2) {
            int endIndex = Math.min(i + 2, spbm.length());
            list.add((String)list.get(list.size() - 1) + spbm.substring(i, endIndex));
        }
        return String.join((CharSequence)".", list);
    }
}

