/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.lqpt.model.request.base.InvoiceNoRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.InvoiceNoResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.service.SxedService;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceNoService {
    private static Log logger = LogFactory.getLog(InvoiceNoService.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yy");
    private static String invoiceno_entity = "bdm_lqpt_invoiceno";
    private static String yfm_entity = "bdm_lqpt_yfm";

    private static int getPreInvoiceSize() {
        int yfmSize = 400;
        try {
            String yfmSizeStr = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"yfm");
            if (StringUtils.isNotBlank((CharSequence)yfmSizeStr)) {
                yfmSize = Integer.parseInt(yfmSizeStr);
                if (yfmSize < 100) {
                    yfmSize = 100;
                }
                if (yfmSize > 5000) {
                    yfmSize = 5000;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5355\u6b21\u9884\u8d4b\u7801\u6570\u91cf\u5931\u8d25");
        }
        return yfmSize;
    }

    private static int getSplitInvoiceSize() {
        int invoiceNoSize = 100;
        try {
            int preInvoiceSize = InvoiceNoService.getPreInvoiceSize();
            invoiceNoSize = preInvoiceSize >> 2;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u62c6\u5206\u53d1\u7968\u5931\u8d25");
        }
        return invoiceNoSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getInvoiceNo(String nsrsbh, Date invoiceDate) {
        long start = System.currentTimeMillis();
        String year = this.sdf.format(invoiceDate);
        String invoiceNo = this.getFromRedis(nsrsbh, year);
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            logger.info("\u8d4b\u7801{}\u4eceredis\u4e2d\u83b7\u53d6-{}\u8017\u65f6{}", new Object[]{nsrsbh, invoiceNo, System.currentTimeMillis() - start});
            return invoiceNo;
        }
        try (DLock lock = DLock.create((String)("lqpt_invoiceno" + nsrsbh), (String)"getLqInvoiceNo");){
            int times = 0;
            do {
                if (times >= 10) return null;
                ++times;
            } while (!lock.tryLock(500L));
            try {
                invoiceNo = this.getFromRedis(nsrsbh, year);
                if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
                    String string = invoiceNo;
                    return string;
                }
                times = 200;
                QFilter[] qFilter = new QFilter("nsrsbh", "=", (Object)nsrsbh).and("status", "=", (Object)"0").and("invoice_no", "like", (Object)(year + "%")).toArray();
                List invocieNoList = QueryServiceHelper.queryPrimaryKeys((String)invoiceno_entity, (QFilter[])qFilter, (String)"id", (int)1);
                if (CollectionUtils.isEmpty((Collection)invocieNoList)) {
                    this.spitInvoiceNo(nsrsbh, year);
                    invocieNoList = QueryServiceHelper.queryPrimaryKeys((String)invoiceno_entity, (QFilter[])qFilter, (String)"id", (int)1);
                }
                if (!CollectionUtils.isNotEmpty((Collection)invocieNoList)) return null;
                invoiceNo = this.getFromRedis(nsrsbh, year);
                if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
                    String string = invoiceNo;
                    return string;
                }
                invoiceNo = (String)invocieNoList.get(0);
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)invoiceno_entity);
                obj.set("id", (Object)invoiceNo);
                obj.set("status", (Object)"1");
                SaveServiceHelper.update((DynamicObject)obj);
                logger.info("\u8d4b\u7801{}-{}\u8017\u65f6{},\u7b49\u5f85\u6b21\u6570{}", new Object[]{nsrsbh, invoiceNo, System.currentTimeMillis() - start, times});
                String string = invoiceNo;
                return string;
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            logger.info("\u83b7\u53d6\u5230\u7684\u53d1\u7968\u53f7\u7801\u662f" + invoiceNo);
        }
    }

    private String getFromRedis(String nsrsbh, String year) {
        String invoiceNo = CacheHelper.rpop((String)(nsrsbh + '-' + year));
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)invoiceno_entity);
            obj.set("id", (Object)invoiceNo);
            obj.set("status", (Object)"1");
            SaveServiceHelper.update((DynamicObject)obj);
        }
        return invoiceNo;
    }

    public void sendBack(String nsrsbh, String invoiceNo) {
        if (!StringUtils.isEmpty((CharSequence)invoiceNo)) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)invoiceno_entity);
            obj.set("id", (Object)invoiceNo);
            obj.set("status", (Object)"0");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{obj});
            new SxedService().updateSxed(nsrsbh, invoiceNo, false);
        }
    }

    public void invoiceSuccess(String nsrsbh, String invoiceNo) {
        if (!StringUtils.isEmpty((CharSequence)invoiceNo)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)invoiceno_entity);
            DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])new Object[]{invoiceNo});
        }
    }

    private void spitInvoiceNo(String nsrsbh, String yy) {
        QFilter[] qFilter = new QFilter("nsrsbh", "=", (Object)nsrsbh).and("year", "=", (Object)yy).and("sysl", ">", (Object)0).toArray();
        DynamicObject[] collect = BusinessDataServiceHelper.load((String)yfm_entity, (String)"id,fpqshm,fpzzhm,lysl,sysl,update_time", (QFilter[])qFilter, (String)"id", (int)5);
        String curryear = this.sdf.format(new Date());
        if ((collect == null || collect.length == 0) && curryear.equals(yy)) {
            collect = this.getYfmInvoiceNo(nsrsbh, qFilter);
        }
        int invoiceNoSize = InvoiceNoService.getSplitInvoiceSize();
        ArrayList<String> allList = new ArrayList<String>(invoiceNoSize);
        if (collect != null && collect.length > 0) {
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(4);
            for (DynamicObject obj : collect) {
                int sysl = obj.getInt("sysl");
                if ((long)sysl <= 0L) continue;
                List<String> list = this.getInvoiceNoList(obj.getString("fpzzhm"), sysl, invoiceNoSize - allList.size());
                allList.addAll(list);
                obj.set("sysl", (Object)(sysl -= list.size()));
                updateList.add(obj);
                if (allList.size() >= invoiceNoSize) break;
            }
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            updateList.clear();
            Object orgId = TaxUtils.getOrgDynamicObjectByTaxNo((String)nsrsbh).getPkValue();
            for (String invoiceNo : allList) {
                DynamicObject obj;
                obj = BusinessDataServiceHelper.newDynamicObject((String)invoiceno_entity);
                obj.set("id", (Object)invoiceNo);
                obj.set("nsrsbh", (Object)nsrsbh);
                obj.set("org", orgId);
                obj.set("invoice_no", (Object)invoiceNo);
                obj.set("status", (Object)"0");
                updateList.add(obj);
                CacheHelper.lpush((String)(nsrsbh + '-' + yy), (String[])new String[]{invoiceNo});
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] getYfmInvoiceNo(String nsrsbh, QFilter[] qFilter) {
        DynamicObject result = this.request(nsrsbh);
        if (result != null) {
            return BusinessDataServiceHelper.load((String)yfm_entity, (String)"id,fpqshm,fpzzhm,lysl,sysl,update_time", (QFilter[])qFilter, (String)"id", (int)5);
        }
        return null;
    }

    private DynamicObject request(String taxNo) {
        InvoiceNoRequest request = new InvoiceNoRequest();
        request.setNsrsbh(taxNo);
        request.setLysl(InvoiceNoService.getPreInvoiceSize());
        LqptService service = new LqptService();
        LqptResponse queryResponse = service.send(request);
        if (queryResponse.success()) {
            InvoiceNoResponse respnse = (InvoiceNoResponse)queryResponse.getData();
            DynamicObject updateObj = BusinessDataServiceHelper.newDynamicObject((String)yfm_entity);
            updateObj.set("fpqshm", (Object)respnse.getFpqshm());
            updateObj.set("fpzzhm", (Object)respnse.getFpzzhm());
            updateObj.set("lysl", (Object)respnse.getLysl());
            updateObj.set("sysl", (Object)respnse.getLysl());
            updateObj.set("create_time", (Object)new Date());
            updateObj.set("update_time", (Object)new Date());
            updateObj.set("year", (Object)respnse.getFpqshm().subSequence(0, 2));
            updateObj.set("nsrsbh", (Object)taxNo);
            updateObj.set("org", TaxUtils.getOrgDynamicObjectByTaxNo((String)taxNo).getPkValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{updateObj});
            return updateObj;
        }
        return null;
    }

    private List<String> getInvoiceNoList(String fpzzhm, int sysl, int size) {
        ArrayList<String> list = new ArrayList<String>(10);
        BigInteger endInvoiceNo = new BigInteger(fpzzhm);
        BigInteger remain = new BigInteger(String.valueOf(sysl));
        BigInteger startInvoiceNo = endInvoiceNo.subtract(remain).add(BigInteger.ONE);
        if (sysl >= size) {
            endInvoiceNo = endInvoiceNo.subtract(remain.subtract(new BigInteger(String.valueOf(size))));
        }
        while (startInvoiceNo.compareTo(endInvoiceNo) <= 0) {
            list.add(startInvoiceNo.toString());
            startInvoiceNo = startInvoiceNo.add(BigInteger.ONE);
        }
        return list;
    }
}

