/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.ability.LqptAbilityService;

public class LqptService {
    static Log log = LogFactory.getLog(LqptService.class);

    public LqptResponse send(LqptRequest request, LqEpConfig config, String body) {
        try {
            LqptAbilityService service = LqptAbilityService.newInstance(request, config);
            long start = System.currentTimeMillis();
            if (log.isInfoEnabled()) {
                log.info(String.format("\u8bf7\u6c42\u4e50\u4f01\u80fd\u529b\u7f16\u7801:[%s], \u63a5\u53e3\u7f16\u7801:[%s], \u53c2\u6570:[%s]", service.getAbilityId(), service.getServiceId(), JSONObject.toJSONString((Object)request)));
            }
            LqptResponse response = service.doBusiness(body);
            if (log.isInfoEnabled()) {
                log.info(String.format("\u8bf7\u6c42\u4e50\u4f01\u80fd\u529b\u7f16\u7801:[%s], \u63a5\u53e3\u7f16\u7801:[%s], \u8fd4\u56de:[%s]", service.getAbilityId(), service.getServiceId(), JSONObject.toJSONString((Object)response)));
            }
            service.saveLog(request, response, System.currentTimeMillis() - start);
            this.setCustomErrorCode(request, response);
            return response;
        }
        catch (KDBizException e) {
            log.error("\u8bf7\u6c42\u4e50\u4f01\u5931\u8d25{},{}", (Object)e.getErrorCode(), (Object)e.getMessage());
            return new LqptResponse(e.getErrorCode());
        }
    }

    private void setCustomErrorCode(LqptRequest request, LqptResponse response) {
        try {
            QFilter filter2;
            String serviceId;
            QFilter filter1;
            DynamicObject obj;
            if (StringUtils.isNotBlank((CharSequence)response.getErrcode()) && StringUtils.isNotBlank((CharSequence)request.getAbilityId()) && (obj = QueryServiceHelper.queryOne((String)"bdm_lqpt_errorcode", (String)"imc_code,imc_desc", (QFilter[])new QFilter[]{filter1 = new QFilter("interface", "=", (Object)(serviceId = request.getAbilityId() + request.getServiceId())), filter2 = new QFilter("out_code", "=", (Object)response.getErrcode())})) != null) {
                String newCode = obj.getString("imc_code");
                if (StringUtils.isNotEmpty((CharSequence)newCode)) {
                    log.info("\u4e50\u4f01\u54cd\u5e94\u7801\u8f6c\u6362{},\u539f\u59cb\u54cd\u5e94\u7801:{},\u8f6c\u6362\u540e:{}", new Object[]{serviceId, response.getErrcode(), newCode});
                    response.setErrcode(newCode);
                }
                if (StringUtils.isNotEmpty((CharSequence)obj.getString("imc_desc"))) {
                    response.setDescription(obj.getString("imc_desc"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LqptResponse send(LqptRequest request) {
        LqEpConfig config = this.getLqEpConfig(request.getNsrsbh());
        return this.send(request, config, null);
    }

    public LqptResponse send(LqptRequest request, String body) {
        LqEpConfig config = this.getLqEpConfig(request.getNsrsbh());
        return this.send(request, config, body);
    }

    public LqEpConfig getLqEpConfig(String nsrsbh) {
        LqEpConfig lqEpConfig = new LqEpConfig();
        DynamicObject ep = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "enterpriserole", "leqiid", "leqisecret", "accessepinfo", "issuechannel"), (QFilter[])new QFilter("number", "=", (Object)nsrsbh).toArray());
        if (ep == null || StringUtils.isBlank((CharSequence)ep.getString("leqiid"))) {
            return lqEpConfig;
        }
        lqEpConfig.setNsrsbh(nsrsbh);
        lqEpConfig.setSydwptbh(ep.getString("leqiid"));
        lqEpConfig.setLqSecret(ep.getString("leqisecret"));
        lqEpConfig.setIssueChannel(ep.getString("issuechannel"));
        String enterpriserole = ep.getString("enterpriserole");
        if ("1".equals(enterpriserole)) {
            lqEpConfig.setJrdwptbh(lqEpConfig.getSydwptbh());
        } else {
            DynamicObject ep2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)String.join((CharSequence)",", "enterpriserole", "leqiid", "leqisecret"), (QFilter[])new QFilter("id", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)ep.get("accessepinfo"))).toArray());
            if (ep2 != null) {
                lqEpConfig.setJrdwptbh(ep2.getString("leqiid"));
                lqEpConfig.setLqSecret(ep2.getString("leqisecret"));
            }
        }
        Map map = ImcConfigUtil.getValue((String)"bdm_lqpt");
        lqEpConfig.setBaseUrl((String)map.get("baseurl"));
        lqEpConfig.setProxy((String)map.get("proxy"));
        if (!StringUtils.isBlank((CharSequence)((CharSequence)map.get("connect_timeout")))) {
            lqEpConfig.setConnectTimeout(Integer.parseInt((String)map.get("connect_timeout")));
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)map.get("socket_timeout")))) {
            lqEpConfig.setSocketTimeout(Integer.parseInt((String)map.get("socket_timeout")));
        }
        if (!StringUtils.isBlank((CharSequence)((CharSequence)map.get("sxcsbz")))) {
            lqEpConfig.setSxcsbz((String)map.get("sxcsbz"));
        }
        return lqEpConfig;
    }
}

